/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlClientException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.GraphqlTopLevelErrorsException;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GraphqlQueryOptions;
import xsquash4gitlab.com.apollographql.apollo.ApolloCall;
import xsquash4gitlab.com.apollographql.apollo.ApolloClient;
import xsquash4gitlab.com.apollographql.apollo.api.Error;
import xsquash4gitlab.com.apollographql.apollo.api.Mutation;
import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Query;
import xsquash4gitlab.com.apollographql.apollo.api.Response;
import xsquash4gitlab.com.apollographql.apollo.exception.ApolloException;
import xsquash4gitlab.okhttp3.Interceptor;
import xsquash4gitlab.okhttp3.OkHttpClient;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

public class GraphqlClient {
    public static final Logger LOGGER = LoggerFactory.getLogger(GraphqlClient.class);
    public static final Duration TIMEOUT_DURATION = Duration.ofSeconds(90L);
    private final ApolloClient apolloClient;

    public GraphqlClient(String endpoint, String token) {
        this.apolloClient = this.getApolloClient(endpoint, token);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> O executeAndConvert(Query<D, T, V> query, Converter<T, O> converter, GraphqlQueryOptions options) {
        Response<T> response = this.executeQuery(query);
        this.checkResponseErrors(response, options);
        T data = response.getData();
        return converter.convert(data);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> O executeAndConvert(Mutation<D, T, V> mutation, Converter<T, O> converter, GraphqlQueryOptions options) {
        Response<T> response = this.executeMutation(mutation);
        this.checkResponseErrors(response, options);
        T data = response.getData();
        return converter.convert(data);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables> Response<T> executeQuery(Query<D, T, V> query) {
        try {
            return GraphqlClient.toCompletableFuture(this.apolloClient.query(query)).get();
        }
        catch (ExecutionException e) {
            LOGGER.error("Error while executing GraphQL query.", (Throwable)e);
            throw new GraphqlClientException("Error while executing GraphQL query.", e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error while executing GraphQL query.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new GraphqlClientException("Error while executing GraphQL query.", e);
        }
    }

    public <D extends Operation.Data, T, V extends Operation.Variables> Response<T> executeMutation(Mutation<D, T, V> mutation) {
        try {
            return GraphqlClient.toCompletableFuture(this.apolloClient.mutate(mutation)).get();
        }
        catch (ExecutionException e) {
            LOGGER.error("Error while executing GraphQL mutation.", (Throwable)e);
            throw new GraphqlClientException("Error while executing GraphQL mutation.", e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error while executing GraphQL mutation.", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new GraphqlClientException("Error while executing GraphQL mutation.", e);
        }
    }

    private static <T> CompletableFuture<Response<T>> toCompletableFuture(@NotNull ApolloCall<T> apolloCall) {
        final CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.whenComplete((tResponse, throwable) -> {
            if (completableFuture.isCancelled()) {
                completableFuture.cancel(true);
            }
        });
        apolloCall.enqueue(new ApolloCall.Callback<T>(){

            @Override
            public void onResponse(@NotNull Response<T> response) {
                completableFuture.complete(response);
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    private <T> void checkResponseErrors(Response<T> response, GraphqlQueryOptions options) {
        List<Error> graphQlErrors = response.getErrors();
        if (graphQlErrors != null && !graphQlErrors.isEmpty()) {
            if (options.shouldThrowTopLevelErrors()) {
                throw new GraphqlTopLevelErrorsException("GraphQL query executed with top-level errors.", graphQlErrors);
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("GraphQL query executed with top-level errors :");
                graphQlErrors.forEach(error -> LOGGER.warn(error.getMessage()));
            }
        }
    }

    private ApolloClient getApolloClient(String endpoint, String token) {
        return ApolloClient.builder().serverUrl(endpoint).okHttpClient(this.buildHttpClient(token)).build();
    }

    private OkHttpClient buildHttpClient(String token) {
        return new OkHttpClient().newBuilder().addInterceptor(this.addAuthorizationHeader(token)).connectTimeout(TIMEOUT_DURATION).readTimeout(TIMEOUT_DURATION).writeTimeout(TIMEOUT_DURATION).proxy(this.getProxyConfiguration()).build();
    }

    private Interceptor addAuthorizationHeader(String token) {
        return chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + token).build());
    }

    private Proxy getProxyConfiguration() {
        Proxy proxy = this.tryToExtractProxyFromSystemProperties("https");
        if (proxy == null) {
            proxy = this.tryToExtractProxyFromSystemProperties("http");
        }
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        return proxy;
    }

    private Proxy tryToExtractProxyFromSystemProperties(String protocolPrefix) {
        try {
            String proxyHost = System.getProperty(String.valueOf(protocolPrefix) + ".proxyHost");
            String proxyPort = System.getProperty(String.valueOf(protocolPrefix) + ".proxyPort");
            int parsedPort = Integer.parseInt(proxyPort);
            if (StringUtils.isNotBlank((CharSequence)proxyHost) && StringUtils.isNotBlank((CharSequence)proxyPort)) {
                InetSocketAddress address = new InetSocketAddress(proxyHost, parsedPort);
                return new Proxy(Proxy.Type.HTTP, address);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.trace(String.format("Error while extracting proxy properties for protocol '%s'", protocolPrefix), (Throwable)ex);
        }
        return null;
    }

    @FunctionalInterface
    public static interface Converter<I, O> {
        public O convert(I var1);
    }
}

