/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;

public class GitLabClientPool {
    private final Map<ClientConfiguration, GitLabClient> clients = new HashMap<ClientConfiguration, GitLabClient>();

    public GitLabClient getClient(String url, String token) {
        ClientConfiguration key = new ClientConfiguration(url, token);
        return this.clients.computeIfAbsent(key, k -> new GitLabClient(url, token));
    }

    private static final class ClientConfiguration {
        public final String url;
        public final String token;

        private ClientConfiguration(String url, String token) {
            this.url = url;
            this.token = token;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientConfiguration that = (ClientConfiguration)o;
            return Objects.equal((Object)this.url, (Object)that.url) && Objects.equal((Object)this.token, (Object)that.token);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.url, this.token});
        }
    }
}

