/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.PagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabGroupClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabIssueClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabNoteClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabProjectClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GraphqlClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GraphqlQueryOptions;
import xsquash4gitlab.com.apollographql.apollo.api.Mutation;
import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Query;

public class GitLabClient {
    private final GraphqlClient graphqlClient;
    private final GitLabProjectClient gitLabProjectClient;
    private final GitLabGroupClient gitLabGroupClient;
    private final GitLabIssueClient gitLabIssueClient;
    private final GitLabNoteClient gitLabNoteClient;

    public GitLabClient(String endpoint, String token) {
        this.graphqlClient = this.createGraphqlClient(endpoint, token);
        this.gitLabProjectClient = new GitLabProjectClient(this);
        this.gitLabGroupClient = new GitLabGroupClient(this);
        this.gitLabIssueClient = new GitLabIssueClient(this);
        this.gitLabNoteClient = new GitLabNoteClient(this);
    }

    protected GraphqlClient createGraphqlClient(String endpoint, String token) {
        return new GraphqlClient(endpoint, token);
    }

    public GitLabProjectClient getProjectClient() {
        return this.gitLabProjectClient;
    }

    public GitLabGroupClient getGroupClient() {
        return this.gitLabGroupClient;
    }

    public GitLabIssueClient getIssueClient() {
        return this.gitLabIssueClient;
    }

    public GitLabNoteClient getNoteClient() {
        return this.gitLabNoteClient;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> O executeAndConvert(Query<D, T, V> query, GraphqlClient.Converter<T, O> converter) {
        return this.executeAndConvert(query, converter, GraphqlQueryOptions.defaultOptions());
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> O executeAndConvert(Query<D, T, V> query, GraphqlClient.Converter<T, O> converter, GraphqlQueryOptions options) {
        return this.graphqlClient.executeAndConvert(query, converter, options);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> O executeAndConvert(Mutation<D, T, V> mutation, GraphqlClient.Converter<T, O> converter) {
        return this.executeAndConvert(mutation, converter, GraphqlQueryOptions.defaultOptions());
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> O executeAndConvert(Mutation<D, T, V> mutation, GraphqlClient.Converter<T, O> converter, GraphqlQueryOptions options) {
        return this.graphqlClient.executeAndConvert(mutation, converter, options);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> Collection<O> executeAndConvertAllPages(int pageSize, PagingAdapter<D, T, V> pagingAdapter, GraphqlClient.Converter<T, O> converter) {
        return this.executeAndConvertAllPagesAfter(pageSize, pagingAdapter, converter, null);
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> Collection<O> executeAndConvertAllPagesAfter(int pageSize, PagingAdapter<D, T, V> pagingAdapter, GraphqlClient.Converter<T, O> converter, String startCursor) {
        boolean hasNextPage;
        ArrayList<O> allPagesResult = new ArrayList<O>();
        String currentCursor = startCursor;
        do {
            Query<D, T, V> currentPageQuery = pagingAdapter.getAfterCursorQuery(currentCursor, pageSize);
            T currentPageData = this.graphqlClient.executeQuery(currentPageQuery).getData();
            O currentPageResult = converter.convert(currentPageData);
            allPagesResult.add(currentPageResult);
            hasNextPage = pagingAdapter.hasNextPage(currentPageData);
            currentCursor = pagingAdapter.getEndCursor(currentPageData);
        } while (hasNextPage);
        return allPagesResult;
    }

    public <D extends Operation.Data, T, V extends Operation.Variables, O> Page<O> getSinglePage(int pageSize, PagingAdapter<D, T, V> pagingAdapter, GraphqlClient.Converter<T, O> converter, String startCursor) {
        Query<D, T, V> currentPageQuery = pagingAdapter.getAfterCursorQuery(startCursor, pageSize);
        T currentPageData = this.graphqlClient.executeQuery(currentPageQuery).getData();
        O currentPageResult = converter.convert(currentPageData);
        String endCursor = pagingAdapter.getEndCursor(currentPageData);
        return new Page<O>(currentPageResult, endCursor);
    }

    public Optional<GitLabIssue> fetchGitLabIssue(GitLabInstanceType gitLabInstanceType, String remoteKey, GitLabClient client) {
        String globalId = "gid://gitlab/Issue/" + remoteKey;
        if (GitLabInstanceType.COMMUNITY.equals((Object)gitLabInstanceType)) {
            return client.getIssueClient().findIssueByGlobalIdCommunity(globalId);
        }
        return client.getIssueClient().findIssueByGlobalIdPremium(globalId);
    }

    public record Page<O>(O items, String endCursor) {
    }
}

