/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import java.util.Date;
import java.util.List;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.IterationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.MilestoneDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.IterationState;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronizedSprintService;

public class SprintToCreate {
    private long id;
    private String name;
    private Date startDate;
    private Date endDate;
    private String status;
    private String iterationGroup;
    private List<GitLabIssue> gitLabIssues;
    private boolean isUpcoming;
    private boolean isExpired;

    public SprintToCreate() {
    }

    public SprintToCreate(MilestoneDto milestone) {
        this.id = SynchronizedSprintService.extractIdFromGitLabId(milestone.getId());
        this.name = milestone.getTitle();
        this.startDate = milestone.getStartDate();
        this.endDate = milestone.getDueDate();
        this.status = milestone.getState().name();
        this.iterationGroup = null;
        this.isUpcoming = milestone.isUpcoming();
        this.isExpired = milestone.isExpired();
    }

    public SprintToCreate(IterationDto iteration) {
        this.id = SynchronizedSprintService.extractIdFromGitLabId(iteration.getId());
        this.name = String.valueOf(iteration.getIterationGroup()) + " : " + iteration.generateIterationName();
        this.startDate = iteration.getStartDate();
        this.endDate = iteration.getDueDate();
        this.status = iteration.getState().name();
        this.iterationGroup = iteration.getIterationGroup();
        this.isUpcoming = iteration.getState() == IterationState.UPCOMING;
        this.isExpired = iteration.getState() == IterationState.CLOSED;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getIterationGroup() {
        return this.iterationGroup;
    }

    public void setIterationGroup(String iterationGroup) {
        this.iterationGroup = iterationGroup;
    }

    public List<GitLabIssue> getGitLabIssues() {
        return this.gitLabIssues;
    }

    public void setGitLabIssues(List<GitLabIssue> gitLabIssues) {
        this.gitLabIssues = gitLabIssues;
    }

    public boolean isUpcoming() {
        return this.isUpcoming;
    }

    public void setUpcoming(boolean upcoming) {
        this.isUpcoming = upcoming;
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public void setExpired(boolean expired) {
        this.isExpired = expired;
    }
}

