/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.OAuthConfiguration;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Occurs;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.PrefixDefinition;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Publisher;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Representation;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.Service;
import plugin.rtc.org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Service Provider Resource Shape", describes={"http://open-services.net/ns/core#ServiceProvider"})
public class ServiceProvider
extends AbstractResource {
    private final SortedSet<URI> details = new TreeSet<URI>();
    private final List<PrefixDefinition> prefixDefinitions = new ArrayList<PrefixDefinition>();
    private final List<Service> services = new ArrayList<Service>();
    private Date created;
    private String description;
    private String identifier;
    private OAuthConfiguration oauthConfiguration;
    private Publisher publisher;
    private String title;

    public void addService(Service srvc) {
        this.services.add(srvc);
    }

    @OslcDescription(value="The date and time that this resource was created")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public final Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Description of the service provider")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcReadOnly
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="URLs that may be used to retrieve web pages to determine additional details about the service provider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#details")
    @OslcReadOnly
    @OslcTitle(value="Details")
    public URI[] getDetails() {
        return this.details.toArray(new URI[this.details.size()]);
    }

    @OslcDescription(value="A unique identifier for this resource")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public final String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Defines the three OAuth URIs required for a client to act as an OAuth consumer")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#oauthConfiguration")
    @OslcRange(value={"http://open-services.net/ns/core#OAuthConfiguration"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="OAuth Configuration")
    @OslcValueShape(value="resourceShapes/oauthConfiguration")
    @OslcValueType(value=ValueType.LocalResource)
    public OAuthConfiguration getOauthConfiguration() {
        return this.oauthConfiguration;
    }

    @OslcDescription(value="Defines namespace prefixes for use in JSON representations and in forming OSLC Query Syntax strings")
    @OslcName(value="prefixDefinition")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#prefixDefinition")
    @OslcRange(value={"http://open-services.net/ns/core#PrefixDefinition"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Prefix Definitions")
    @OslcValueShape(value="resourceShapes/prefixDefinition")
    @OslcValueType(value=ValueType.LocalResource)
    public PrefixDefinition[] getPrefixDefinitions() {
        return this.prefixDefinitions.toArray(new PrefixDefinition[this.prefixDefinitions.size()]);
    }

    @OslcDescription(value="Describes the software product that provides the implementation")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/publisher")
    @OslcRange(value={"http://open-services.net/ns/core#Publisher"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Publisher")
    @OslcValueShape(value="resourceShapes/publisher")
    @OslcValueType(value=ValueType.LocalResource)
    public Publisher getPublisher() {
        return this.publisher;
    }

    @OslcDescription(value="Describes services offered by the service provider")
    @OslcName(value="service")
    @OslcOccurs(value=Occurs.OneOrMany)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#service")
    @OslcRange(value={"http://open-services.net/ns/core#Service"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Services")
    @OslcValueShape(value="resourceShapes/service")
    @OslcValueType(value=ValueType.LocalResource)
    public Service[] getServices() {
        return this.services.toArray(new Service[this.services.size()]);
    }

    @OslcDescription(value="Title of the service provider")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    public final void setCreated(Date created) {
        this.created = created;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDetails(URI[] details) {
        this.details.clear();
        if (details != null) {
            this.details.addAll(Arrays.asList(details));
        }
    }

    public final void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setOauthConfiguration(OAuthConfiguration oauthConfiguration) {
        this.oauthConfiguration = oauthConfiguration;
    }

    public void setPrefixDefinitions(PrefixDefinition[] prefixDefinitions) {
        this.prefixDefinitions.clear();
        if (prefixDefinitions != null) {
            this.prefixDefinitions.addAll(Arrays.asList(prefixDefinitions));
        }
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public void setServices(Service[] services) {
        this.services.clear();
        if (services != null) {
            this.services.addAll(Arrays.asList(services));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

