/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import plugin.rtc.org.apache.wink.common.internal.utils.SimpleMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConcurrentMap<K, V>
implements SimpleMap<K, V> {
    private final Lock readersLock;
    private final Lock writersLock;
    private final Map<K, V> map;

    public SimpleConcurrentMap() {
        this(new HashMap());
    }

    public SimpleConcurrentMap(Map<K, V> map) {
        this.map = map;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readersLock = readWriteLock.readLock();
        this.writersLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.readersLock.lock();
        try {
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.readersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V val) {
        this.writersLock.lock();
        try {
            V v = this.map.put(key, val);
            return v;
        }
        finally {
            this.writersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writersLock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.writersLock.unlock();
        }
    }
}

