/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.header;

import java.util.LinkedList;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.ext.RuntimeDelegate;
import plugin.rtc.org.apache.wink.common.internal.http.Accept;
import plugin.rtc.org.apache.wink.common.internal.utils.SoftConcurrentMap;
import plugin.rtc.org.apache.wink.common.internal.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Accept> {
    private static final SoftConcurrentMap<String, Accept> cache = new SoftConcurrentMap();

    @Override
    public Accept fromString(String value) throws IllegalArgumentException {
        String[] mediaTypes;
        Accept cached = cache.get(value);
        if (cached != null) {
            return cached;
        }
        if (value == null) {
            value = "*/*";
        }
        LinkedList<MediaType> list = new LinkedList<MediaType>();
        for (String mediaRange : mediaTypes = StringUtils.fastSplit(value, ",")) {
            if ((mediaRange = mediaRange.trim()).length() == 0) continue;
            list.add(MediaType.valueOf(mediaRange));
        }
        return cache.put(value, new Accept(list));
    }

    @Override
    public String toString(Accept value) {
        StringBuilder result = new StringBuilder();
        for (MediaType valuedMediaType : value.getMediaTypes()) {
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(valuedMediaType.toString());
        }
        return result.toString();
    }
}

