/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.providers.entity.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.javax.ws.rs.Consumes;
import plugin.rtc.javax.ws.rs.Produces;
import plugin.rtc.javax.ws.rs.WebApplicationException;
import plugin.rtc.javax.ws.rs.core.MediaType;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.javax.ws.rs.core.Response;
import plugin.rtc.javax.ws.rs.ext.MessageBodyReader;
import plugin.rtc.javax.ws.rs.ext.MessageBodyWriter;
import plugin.rtc.javax.ws.rs.ext.Provider;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.providers.entity.xml.AbstractJAXBProvider;
import plugin.rtc.org.apache.wink.common.internal.providers.entity.xml.EntityReferenceXMLStreamException;
import plugin.rtc.org.apache.wink.common.internal.utils.MediaTypeUtils;
import plugin.rtc.org.apache.wink.common.utils.ProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"text/xml", "application/xml", "*/*"})
@Produces(value={"text/xml", "application/xml", "*/*"})
public class JAXBElementXmlProvider
extends AbstractJAXBProvider
implements MessageBodyReader<JAXBElement<?>>,
MessageBodyWriter<JAXBElement<?>> {
    private static final Logger logger = LoggerFactory.getLogger(JAXBElementXmlProvider.class);

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElementXmlProvider.isJAXBElement(type, genericType) && this.isSupportedMediaType(mediaType);
    }

    @Override
    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Class classToFill = (Class)parameterizedType.getActualTypeArguments()[0];
        JAXBElement unmarshaledResource = null;
        Unmarshaller unmarshaller = null;
        XMLStreamReader xmlStreamReader = null;
        try {
            JAXBContext context = this.getContext(classToFill, mediaType);
            unmarshaller = this.getJAXBUnmarshaller(type, context, mediaType);
            String charset = ProviderUtils.getCharsetOrNull(mediaType);
            if (charset == null) {
                xmlStreamReader = this.getXMLStreamReader(entityStream);
                unmarshaledResource = unmarshaller.unmarshal(xmlStreamReader, classToFill);
                JAXBElementXmlProvider.closeXMLStreamReader(xmlStreamReader);
            } else {
                xmlStreamReader = this.getXMLStreamReader(new InputStreamReader(entityStream, Charset.forName(charset)));
                unmarshaledResource = unmarshaller.unmarshal(xmlStreamReader, classToFill);
                JAXBElementXmlProvider.closeXMLStreamReader(xmlStreamReader);
            }
            this.releaseJAXBUnmarshaller(context, unmarshaller);
        }
        catch (JAXBException e) {
            JAXBElementXmlProvider.closeXMLStreamReader(xmlStreamReader);
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbFailToUnmarshal", type.getName()), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (EntityReferenceXMLStreamException e) {
            JAXBElementXmlProvider.closeXMLStreamReader(xmlStreamReader);
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("entityRefsNotSupported"));
            }
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (XMLStreamException e) {
            JAXBElementXmlProvider.closeXMLStreamReader(xmlStreamReader);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (RuntimeException e) {
            JAXBElementXmlProvider.closeXMLStreamReader(xmlStreamReader);
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        return unmarshaledResource;
    }

    @Override
    public long getSize(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElementXmlProvider.isJAXBElement(type, genericType) && this.isSupportedMediaType(mediaType);
    }

    @Override
    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, mediaType);
        try {
            Class declaredType = t.getDeclaredType();
            JAXBContext context = this.getContext(declaredType, mediaType);
            Marshaller marshaller = this.getJAXBMarshaller(declaredType, context, mediaType);
            marshaller.marshal(t, entityStream);
            this.releaseJAXBMarshaller(context, marshaller);
        }
        catch (JAXBException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("jaxbFailToMarshal", t.getName()), (Throwable)e);
            }
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

