/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.internal.lifecycle;

import java.io.IOException;
import java.security.PrivilegedActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.CreationUtils;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.ObjectCreationException;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.ObjectFactory;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.PrototypeObjectFactory;
import plugin.rtc.org.apache.wink.common.internal.lifecycle.SingletonObjectFactory;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ApplicationMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import plugin.rtc.org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleManagerUtils {
    private static Logger logger = LoggerFactory.getLogger(LifecycleManagerUtils.class);

    public static <T> ObjectFactory<T> createSingletonObjectFactory(T object) {
        Class<?> cls = object.getClass();
        ClassMetadata classMetadata = LifecycleManagerUtils.collectClassMetadata(cls, false);
        try {
            CreationUtils.injectFields(object, classMetadata, null);
            return new SingletonObjectFactory<T>(object);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("injectionFailureSingleton", cls.getName()));
            }
            throw new ObjectCreationException(e);
        }
        catch (PrivilegedActionException e) {
            if (logger.isErrorEnabled()) {
                logger.error(Messages.getMessage("injectionFailureSingleton", cls.getName()));
            }
            throw new ObjectCreationException(e);
        }
    }

    public static <T> ObjectFactory<T> createSingletonObjectFactory(Class<T> cls) {
        ClassMetadata classMetadata = LifecycleManagerUtils.collectClassMetadata(cls, true);
        Object object = CreationUtils.createObject(classMetadata, null);
        return new SingletonObjectFactory<Object>(object);
    }

    public static <T> ObjectFactory<T> createPrototypeObjectFactory(Class<T> cls) {
        ClassMetadata classMetadata = LifecycleManagerUtils.collectClassMetadata(cls, true);
        return new PrototypeObjectFactory(classMetadata);
    }

    protected static <T> ClassMetadata collectClassMetadata(Class<T> cls, boolean validateConstructor) {
        ClassMetadata classMetadata = null;
        if (ProviderMetadataCollector.isProvider(cls)) {
            classMetadata = ProviderMetadataCollector.collectMetadata(cls);
        } else if (ResourceMetadataCollector.isResource(cls)) {
            classMetadata = ResourceMetadataCollector.collectMetadata(cls);
        } else if (ApplicationMetadataCollector.isApplication(cls)) {
            classMetadata = ApplicationMetadataCollector.collectMetadata(cls);
        } else {
            throw new IllegalArgumentException(Messages.getMessage("cannotCreateFactoryForClass", cls));
        }
        if (validateConstructor && classMetadata.getConstructor().getConstructor() == null) {
            throw new IllegalStateException(Messages.getMessage("noValidConstructorFoundFor", cls.getCanonicalName()));
        }
        return classMetadata;
    }
}

