/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.common.categories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import plugin.rtc.javax.ws.rs.core.MultivaluedMap;
import plugin.rtc.org.apache.wink.common.model.atom.AtomCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Categories {
    private String scheme;
    private String href;
    private boolean isFixed;
    private List<AtomCategory> categories;
    private Class<?> handlingClass;
    private Object handlingInstance;
    private MultivaluedMap<String, String> templateParams;

    public Categories(List<AtomCategory> categories) {
        this.categories = categories;
        this.isFixed = false;
    }

    public Categories() {
        this.categories = new ArrayList<AtomCategory>();
        this.isFixed = false;
    }

    public String getHref() {
        return this.href;
    }

    public Categories setHref(String href) {
        this.href = href;
        this.handlingClass = null;
        this.templateParams = null;
        this.handlingInstance = null;
        return this;
    }

    public void setHref(Class<?> handlingClass, MultivaluedMap<String, String> templateParams) {
        this.handlingClass = handlingClass;
        this.templateParams = templateParams;
        this.handlingInstance = null;
        this.href = null;
    }

    public void setHref(Object handlingInstance, MultivaluedMap<String, String> templateParams) {
        this.handlingInstance = handlingInstance;
        this.templateParams = templateParams;
        this.handlingClass = null;
        this.href = null;
    }

    public boolean isFixed() {
        return this.isFixed;
    }

    public Categories setFixed(boolean fixed) {
        this.isFixed = fixed;
        return this;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Categories setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public List<AtomCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public List<AtomCategory> getCategories(String scheme) {
        ArrayList<AtomCategory> newcats = new ArrayList<AtomCategory>();
        for (AtomCategory cat : this.categories) {
            if (!cat.getScheme().endsWith(scheme)) continue;
            newcats.add(cat);
        }
        return Collections.unmodifiableList(newcats);
    }

    public Categories addCategory(AtomCategory category) {
        this.categories.add(category);
        return this;
    }

    public AtomCategory addCategory(String term) {
        AtomCategory newCategory = new AtomCategory();
        newCategory.setTerm(term);
        this.categories.add(newCategory);
        return newCategory;
    }

    public AtomCategory addCategory(String scheme, String term, String label) {
        AtomCategory newCategory = new AtomCategory();
        newCategory.setScheme(scheme);
        newCategory.setTerm(term);
        newCategory.setLabel(label);
        this.categories.add(newCategory);
        return null;
    }

    public boolean contains(String term) {
        return this.contains(term, null);
    }

    public boolean contains(String term, String scheme) {
        String catscheme = this.getScheme();
        String searchScheme = scheme != null ? scheme : catscheme;
        for (AtomCategory category : this.categories) {
            String s;
            String t = category.getTerm();
            String string = s = category.getScheme() != null ? category.getScheme() : catscheme;
            if (!t.equals(term) || !(searchScheme != null ? searchScheme.equals(s) : s == null)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutOfLine() {
        boolean answer = false;
        answer = this.getHref() != null || this.handlingClass != null || this.handlingInstance != null;
        return answer;
    }

    public Class<?> getHandlingClass() {
        return this.handlingClass;
    }

    public void setCategories(List<AtomCategory> categories) {
        this.categories = categories;
    }

    public Object getHandlingInstance() {
        return this.handlingInstance;
    }

    public MultivaluedMap<String, String> getTemplateParameters() {
        return this.templateParams;
    }

    public void setTemplateParameters(MultivaluedMap<String, String> templateParams) {
        this.templateParams = templateParams;
    }
}

