/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.wink.client.handlers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugin.rtc.org.apache.wink.client.ClientAuthenticationException;
import plugin.rtc.org.apache.wink.client.ClientRequest;
import plugin.rtc.org.apache.wink.client.ClientResponse;
import plugin.rtc.org.apache.wink.client.handlers.AbstractAuthSecurityHandler;
import plugin.rtc.org.apache.wink.client.handlers.ClientHandler;
import plugin.rtc.org.apache.wink.client.handlers.HandlerContext;
import plugin.rtc.org.apache.wink.common.http.HttpStatus;
import plugin.rtc.org.apache.wink.common.internal.i18n.Messages;

public class ProxyAuthSecurityHandler
extends AbstractAuthSecurityHandler
implements ClientHandler {
    private static Logger logger = LoggerFactory.getLogger(ProxyAuthSecurityHandler.class);
    private static final int PROXY_AUTH_REQ_CODE = HttpStatus.PROXY_AUTHENTICATION_REQUIRED.getCode();

    public ProxyAuthSecurityHandler() {
    }

    public ProxyAuthSecurityHandler(String username, String password) {
        super(username, password);
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        logger.trace("Entering ProxyAuthSecurityHandler.doChain()");
        ClientResponse response = context.doChain(request);
        if (response.getStatusCode() == PROXY_AUTH_REQ_CODE) {
            if (this.handlerUsername != null && !this.handlerUsername.equals("") && this.handlerPassword != null && !this.handlerPassword.equals("")) {
                logger.trace("userid and password set so setting Proxy-Authorization header");
                request.getHeaders().putSingle("Proxy-Connection", "Keep-Alive");
                if (this.handlerEncodedCredentials == null) {
                    this.handlerEncodedCredentials = ProxyAuthSecurityHandler.getEncodedString(this.handlerUsername, this.handlerPassword);
                }
                request.getHeaders().putSingle("Proxy-Authorization", this.handlerEncodedCredentials);
                logger.trace("Issuing request again with Proxy-Authorization header");
                response = context.doChain(request);
                if (response.getStatusCode() == PROXY_AUTH_REQ_CODE) {
                    logger.trace("After sending request with Proxy-Authorization header, still got " + PROXY_AUTH_REQ_CODE + " response");
                    throw new ClientAuthenticationException(Messages.getMessage("serviceFailedToAuthenticateProxyUser", this.handlerUsername));
                }
                logger.trace("Got a non-" + PROXY_AUTH_REQ_CODE + " response, so returning response");
                return response;
            }
            logger.trace("proxy user and/or proxy password were not set so throwing exception");
            throw new ClientAuthenticationException(Messages.getMessage("missingClientAuthenticationCredentialForProxyUser", this.handlerUsername));
        }
        logger.trace("Status code was not " + PROXY_AUTH_REQ_CODE + " so no need to re-issue request.");
        return response;
    }
}

