/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.org.apache.http.protocol;

import java.io.IOException;
import plugin.rtc.org.apache.http.HttpException;
import plugin.rtc.org.apache.http.HttpResponse;
import plugin.rtc.org.apache.http.HttpResponseInterceptor;
import plugin.rtc.org.apache.http.annotation.Contract;
import plugin.rtc.org.apache.http.annotation.ThreadingBehavior;
import plugin.rtc.org.apache.http.protocol.HttpContext;
import plugin.rtc.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

