/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.util.iterator;

import plugin.rtc.com.hp.hpl.jena.util.iterator.ClosableIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Filter;
import plugin.rtc.com.hp.hpl.jena.util.iterator.Map1;

public abstract class LazyIterator<T>
implements ExtendedIterator<T> {
    private ExtendedIterator<T> it = null;

    @Override
    public boolean hasNext() {
        this.lazy();
        return this.it.hasNext();
    }

    @Override
    public T next() {
        this.lazy();
        return (T)this.it.next();
    }

    @Override
    public void remove() {
        this.lazy();
        this.it.remove();
    }

    @Override
    public ExtendedIterator<T> andThen(ClosableIterator<? extends T> other) {
        this.lazy();
        return this.it.andThen(other);
    }

    @Override
    public ExtendedIterator<T> filterKeep(Filter<T> f) {
        this.lazy();
        return this.it.filterKeep(f);
    }

    @Override
    public ExtendedIterator<T> filterDrop(Filter<T> f) {
        this.lazy();
        return this.it.filterDrop(f);
    }

    @Override
    public <U> ExtendedIterator<U> mapWith(Map1<T, U> map1) {
        this.lazy();
        return this.it.mapWith(map1);
    }

    @Override
    public void close() {
        this.lazy();
        this.it.close();
    }

    private void lazy() {
        if (this.it == null) {
            this.it = this.create();
        }
    }

    public abstract ExtendedIterator<T> create();
}

