/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.impl;

import java.util.HashSet;
import plugin.rtc.com.hp.hpl.jena.graph.Graph;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.graph.Triple;
import plugin.rtc.com.hp.hpl.jena.reasoner.Finder;
import plugin.rtc.com.hp.hpl.jena.reasoner.TriplePattern;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import plugin.rtc.com.hp.hpl.jena.reasoner.rulesys.RulePreprocessHook;
import plugin.rtc.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDF;
import plugin.rtc.com.hp.hpl.jena.vocabulary.RDFS;

public class RDFSCMPPreprocessHook
implements RulePreprocessHook {
    protected static String memberPrefix = RDF.getURI() + "_";

    @Override
    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator<Triple> it = dataFind.find(new TriplePattern(null, null, null));
        HashSet<Node> properties = new HashSet<Node>();
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            Node prop = triple.getPredicate();
            if (prop.equals(RDF.Nodes.type) && triple.getObject().equals(RDF.Nodes.Property)) {
                prop = triple.getSubject();
            }
            if (!properties.add(prop) || !prop.getURI().startsWith(memberPrefix)) continue;
            inserts.add(new Triple(prop, RDF.Nodes.type, RDFS.Nodes.ContainerMembershipProperty));
        }
    }

    @Override
    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t) {
        return t.getPredicate().getURI().startsWith(memberPrefix);
    }
}

