/*
 * Decompiled with CFR 0.152.
 */
package plugin.rtc.com.hp.hpl.jena.ontology.impl;

import plugin.rtc.com.hp.hpl.jena.enhanced.EnhGraph;
import plugin.rtc.com.hp.hpl.jena.enhanced.EnhNode;
import plugin.rtc.com.hp.hpl.jena.enhanced.Implementation;
import plugin.rtc.com.hp.hpl.jena.graph.Node;
import plugin.rtc.com.hp.hpl.jena.ontology.ConversionException;
import plugin.rtc.com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import plugin.rtc.com.hp.hpl.jena.ontology.OntModel;
import plugin.rtc.com.hp.hpl.jena.ontology.Profile;
import plugin.rtc.com.hp.hpl.jena.ontology.impl.RestrictionImpl;

public class MaxCardinalityRestrictionImpl
extends RestrictionImpl
implements MaxCardinalityRestriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new MaxCardinalityRestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to MaxCardinalityRestriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, MaxCardinalityRestriction.class);
        }
    };

    public MaxCardinalityRestrictionImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public void setMaxCardinality(int cardinality) {
        this.setPropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public int getMaxCardinality() {
        return this.objectAsInt(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
    }

    @Override
    public boolean hasMaxCardinality(int cardinality) {
        return this.hasPropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }

    @Override
    public void removeMaxCardinality(int cardinality) {
        this.removePropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
    }
}

