/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.AuthenticationFieldsTranslationKeys;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.azuredevops.AzureDevOpsBugtrackerConnectorInterfaceDescriptor;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.FileUploadResponse;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.User;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.ProjectNameFormatter;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.conversion.RemoteIssueContextFormatter;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.SquashCompositeKey;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.extension.DelegateCommands;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.service.AzureDevOpsService;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.utils.ExceptionHandler;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class AzureDevOpsBugtrackerConnector
implements AdvancedBugTrackerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureDevOpsBugtrackerConnector.class);
    private BugTracker bugtracker;
    private static final String TEMP_DIRECTORY_PREFIX = "azure-devops-uploads";
    private final AzureDevOpsService azureDevOpsService;
    private final AzureDevOpsClient azureDevOpsClient;
    private final AzureDevOpsBugtrackerConnectorInterfaceDescriptor interfaceDescriptor;
    private final RemoteIssueContextFormatter remoteIssueContextFormatter;
    private final ExceptionHandler exceptionHandler;

    public AzureDevOpsBugtrackerConnector(AzureDevOpsService azureDevOpsService, AzureDevOpsClient azureDevOpsClient, AzureDevOpsBugtrackerConnectorInterfaceDescriptor interfaceDescriptor, RemoteIssueContextFormatter remoteIssueContextFormatter, ExceptionHandler exceptionHandler) {
        this.azureDevOpsService = azureDevOpsService;
        this.azureDevOpsClient = azureDevOpsClient;
        this.interfaceDescriptor = interfaceDescriptor;
        this.remoteIssueContextFormatter = remoteIssueContextFormatter;
        this.exceptionHandler = exceptionHandler;
    }

    public BugTracker getBugtracker() {
        return this.bugtracker;
    }

    public void setBugtracker(BugTracker bugtracker) {
        this.bugtracker = bugtracker;
    }

    public URL makeViewIssueUrl(String issueKey) {
        SquashCompositeKey compositeKey = SquashCompositeKey.fromString(issueKey);
        String url = String.format("%s/%s/_workitems/edit/%s/", this.bugtracker.getUrl(), compositeKey.getProjectPath(), compositeKey.workItemId);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new BugTrackerRemoteException((Throwable)e);
        }
    }

    public AdvancedProject findProject(String projectPath) throws BugTrackerRemoteException {
        try {
            return AdvancedProject.create((String)projectPath, (String)ProjectNameFormatter.projectPathToDisplayValue(projectPath), Collections.emptyMap());
        }
        catch (BugTrackerRemoteException ex) {
            LOGGER.warn("Could not find project with path " + projectPath);
            return null;
        }
    }

    public AdvancedProject findProjectById(String s) throws BugTrackerRemoteException {
        return null;
    }

    public AdvancedIssue createIssue(RemoteIssue remoteIssue) throws BugTrackerRemoteException {
        return this.azureDevOpsService.createIssue(remoteIssue, this.azureDevOpsClient);
    }

    public RemoteIssue createReportIssueTemplate(String projectPath, RemoteIssueContext context) {
        return this.azureDevOpsService.createIssueReportTemplate(projectPath, context, this.azureDevOpsClient);
    }

    public AdvancedIssue findIssue(String issueKey) {
        List<AdvancedIssue> foundIssues = this.findIssues(Collections.singletonList(issueKey));
        if (foundIssues.size() != 1) {
            throw new BugTrackerLocalException("Could not find issue with key " + issueKey, null);
        }
        return foundIssues.get(0);
    }

    public List<AdvancedIssue> findIssues(List<String> issueKeys) {
        return this.azureDevOpsService.findKnownIssues(issueKeys, this.azureDevOpsClient);
    }

    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
        SquashCompositeKey compositeKey = SquashCompositeKey.fromString(remoteIssueKey);
        try {
            File tempDirectory = Files.createTempDirectory(TEMP_DIRECTORY_PREFIX, new FileAttribute[0]).toFile();
            HashMap<Attachment, FileUploadResponse> fileUploadByAttachment = new HashMap<Attachment, FileUploadResponse>();
            for (Attachment attachment : attachments) {
                File tempFile = new File(tempDirectory, attachment.getName());
                Files.copy(attachment.getStreamContent(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                FileUploadResponse fileUpload = this.azureDevOpsClient.uploadFile(compositeKey, tempFile);
                fileUploadByAttachment.put(attachment, fileUpload);
                Files.delete(tempFile.toPath());
            }
            Files.delete(tempDirectory.toPath());
            List<String> urls = fileUploadByAttachment.values().stream().map(FileUploadResponse::getUrl).collect(Collectors.toList());
            this.azureDevOpsClient.linkAttachmentToWorkItem(urls, compositeKey);
        }
        catch (IOException e) {
            throw new BugTrackerLocalException("Error when creating temp File for attachment", (Throwable)e);
        }
    }

    public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        return this.azureDevOpsService.createIssueSearchForm(bugTrackerBindingInfo);
    }

    public Optional<AdvancedIssue> searchIssue(RemoteIssueSearchRequest searchRequest) {
        return this.azureDevOpsService.searchIssue(searchRequest, this.azureDevOpsClient);
    }

    public Object executeDelegateCommand(DelegateCommand delegateCommand) {
        LOGGER.info(String.format("Executing delegate command '%s'...", delegateCommand.getCommand()));
        if (DelegateCommands.isSetTemplateCommand(delegateCommand)) {
            return DelegateCommands.executeSetTemplateCommand(delegateCommand, this.azureDevOpsClient, this.remoteIssueContextFormatter);
        }
        LOGGER.info(String.format("No suitable handler found for delegate command '%s'", delegateCommand.getCommand()));
        return null;
    }

    public void linkIssues(String s, List<String> list) {
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        return this.interfaceDescriptor;
    }

    public void authenticate(Credentials credentials) {
        this.azureDevOpsClient.init(this.bugtracker, credentials);
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerRemoteException {
        this.authenticate(credentials);
        LOGGER.info("Validating Azure DevOps credentials...");
        BasicAuthenticationCredentials basicAuthenticationCredentials = (BasicAuthenticationCredentials)credentials;
        try {
            this.azureDevOpsClient.findAllProjects(basicAuthenticationCredentials.getUsername());
            LOGGER.info("Successfully logged with organization name.");
        }
        catch (Exception ex) {
            try {
                LOGGER.info("Could not check credentials with the provided organization name. A second try will be made with AzureDevOps Cloud 'profile/profiles/me' endpoint.");
                User actualUser = this.azureDevOpsClient.getActualUser();
                LOGGER.info("Successfully logged in as " + actualUser.getDisplayName());
            }
            catch (Exception e) {
                throw this.exceptionHandler.connexionDenied();
            }
        }
    }

    public String getKeyForLogin(BugTracker bugTracker) {
        return AuthenticationFieldsTranslationKeys.ORGANIZATION_NAME.key;
    }

    public String getKeyForPassword(BugTracker bugTracker) {
        return AuthenticationFieldsTranslationKeys.TOKEN.key;
    }
}

