/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.plugin.jirasync.controller.execplan.IterationFormMetadata;
import org.squashtest.tm.plugin.jirasync.domain.execplan.BoardSprints;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanSpecification;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.jirasync.domain.execplan.JqlSearch;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ProjectReleases;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ReleasesSearch;
import org.squashtest.tm.plugin.jirasync.domain.execplan.SprintSearch;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanJqlService;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanProjectReleaseService;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSprintsService;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanTestCaseService;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanTestplanService;
import org.squashtest.tm.plugin.jirasync.service.execplan.SelectedNode;

@Service(value="squash.tm.plugin.jirasync.explanSyncService")
@Transactional
public class ExecplanSynchronizationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanSynchronizationService.class);
    @Inject
    private ExecplanSynchronizationDao dao;
    @Inject
    private ExecplanJqlService jqlService;
    @Inject
    private ExecplanProjectReleaseService releaseService;
    @Inject
    private ExecplanSprintsService sprintService;
    @Inject
    private ExecplanTestCaseService testcaseService;
    @Inject
    private ExecplanTestplanService testplanService;

    public void updateCampaignTestPlan(ExecplanSpecification specification) {
        LOGGER.debug("updating campaign test plan");
        this.testplanService.updateCampaignTestPlan(specification);
    }

    public void updateIterationTestPlan(ExecplanSpecification specification) {
        LOGGER.debug("updating iteration test plan");
        this.testplanService.updateIterationTestPlan(specification);
    }

    public Iteration createIteration(ExecplanSpecification specification) {
        LOGGER.debug("creating iteration");
        return this.testplanService.createIteration(specification);
    }

    @Transactional(readOnly=true)
    public List<ExecplanTestCase> findCandidateTestCasesForTickets(List<ExecplanIssue> issues) {
        LOGGER.debug("retrieving test cases for issues");
        return this.testcaseService.findTestCasesForIssues(issues);
    }

    @Transactional(readOnly=true)
    public List<BugTracker> findAllSyncedJiraServers() {
        LOGGER.debug("retrieving every synchronized jira servers");
        return this.dao.findAllJiraServers();
    }

    @Transactional(readOnly=true)
    public List<ExecplanIssue> findIssuesForJQL(JqlSearch jsearch) {
        LOGGER.debug("retrieving issues by jql");
        List<ExecplanIssue> issues = this.jqlService.findTicketsByJql(jsearch);
        this.testcaseService.partitionJiraIssues(issues);
        return issues;
    }

    @Transactional(readOnly=true)
    public List<String> findAllSyncedJiraProject() {
        LOGGER.debug("retrieving every synchronized jira projects");
        return this.dao.findAllSyncedJiraProjects();
    }

    @Transactional(readOnly=true)
    public List<String> findSyncedJiraProjectForSquashProject(long squashProjectId) {
        LOGGER.debug("retrieving the jira projects synchronized with Squash project '{}'", (Object)squashProjectId);
        return this.dao.findAllSyncedJiraProjects(squashProjectId);
    }

    @Transactional(readOnly=true)
    public ReleasesSearch findReleases(ReleasesSearch vsearch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("searching for jira project releases : {}", (Object)vsearch.logParameters());
        }
        return this.releaseService.findReleases(vsearch);
    }

    @Transactional(readOnly=true)
    public List<ExecplanIssue> findIssuesForReleases(List<ProjectReleases> releases) {
        LOGGER.debug("retrieving issues by project release");
        List<ExecplanIssue> issues = this.releaseService.findReleasedTickets(releases);
        this.testcaseService.partitionJiraIssues(issues);
        return issues;
    }

    @Transactional(readOnly=true)
    public List<String> findAllSyncedBoards() {
        LOGGER.debug("retrieving every synchronized jira board");
        return this.dao.findAllSyncedBoards();
    }

    @Transactional(readOnly=true)
    public List<String> findSyncedBoardForSquashProject(long squashProjectId) {
        LOGGER.debug("retrieving the jira board synchronized with Squash project '{}'", (Object)squashProjectId);
        return this.dao.findAllSyncedBoards(squashProjectId);
    }

    @Transactional(readOnly=true)
    public SprintSearch findSprints(SprintSearch ssearch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("searching for jira sprints : {}", (Object)ssearch.logParameters());
        }
        return this.sprintService.findSprints(ssearch);
    }

    @Transactional(readOnly=true)
    public List<ExecplanIssue> findIssuesForSprints(List<BoardSprints> boardSprints) {
        LOGGER.debug("retrieving issues by sprints");
        List<ExecplanIssue> issues = this.sprintService.findTicketsInSprints(boardSprints);
        this.testcaseService.partitionJiraIssues(issues);
        return issues;
    }

    @Transactional(readOnly=true)
    public IterationFormMetadata findIterationMetadataForCampaign(Long campaignId) {
        LOGGER.debug("retrieving iteration creation metadata");
        return this.testplanService.getIterationMetadata(campaignId);
    }

    @Transactional(readOnly=true)
    public SelectedNode createSelectedNode(EntityReference reference) {
        return this.dao.loadSelectedNode(reference);
    }

    public boolean isWizardEnabledOnProject(long projectId) {
        return this.dao.isWizardEnabledOnProject(projectId);
    }
}

