/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.QBugTracker;
import org.squashtest.tm.domain.bugtracker.QIssue;
import org.squashtest.tm.domain.campaign.QCampaign;
import org.squashtest.tm.domain.campaign.QCampaignTestPlanItem;
import org.squashtest.tm.domain.campaign.QIteration;
import org.squashtest.tm.domain.campaign.QIterationTestPlanItem;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.execution.QExecution;
import org.squashtest.tm.domain.project.QProject;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.QRequirementVersion;
import org.squashtest.tm.domain.synchronisation.QRemoteSynchronisation;
import org.squashtest.tm.domain.testcase.QRequirementVersionCoverage;
import org.squashtest.tm.domain.testcase.QTestCase;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.Project;
import org.squashtest.tm.jooq.domain.tables.Requirement;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanRequirement;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.jirasync.service.execplan.ReadableProjectsFinder;
import org.squashtest.tm.plugin.jirasync.service.execplan.SelectedNode;

@Repository(value="squash.tm.plugin.jirasync.execplandao")
public class ExecplanSynchronizationDao {
    @PersistenceContext
    private EntityManager em;
    @Inject
    private DSLContext DSL;
    @Inject
    private ReadableProjectsFinder readableProjectsFinder;
    private static final String FILTER_SYNC_KEY = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync where sync.kind = 'squash.tm.plugin.jirasync' and extender.remoteReqId in (:keys)";
    private static final String FILTER_BUGFIXES_KEY = "select distinct issue.remoteIssueId from Issue issue where issue.remoteIssueId in (:keys)";
    private static final String FILTER_COVERED_REQS = "select distinct extender.remoteReqId from RequirementSyncExtender extender inner join extender.remoteSynchronisation sync inner join extender.requirement req inner join req.versions versions inner join versions.requirementVersionCoverages cov where sync.kind = 'squash.tm.plugin.jirasync' and extender.remoteReqId in (:keys)";
    private static final String LOAD_SELECTED_NODE_CPG = "select c.id, 'campaign', c.name, p.id, p.name from Campaign c join c.project p where c.id = :id";
    private static final String LOAD_SELECTED_NODE_IT = "select  it.id, 'iteration', it.name, p.id, p.name from Iteration it join it.campaign c join c.project p where it.id = :id";
    private static final String FIND_ITERATION_NAMES = "select it.name from Iteration it join it.campaign c where c.id = :id";
    private static final String FIND_ITERATION_CUFS = "select cuf from CustomFieldBinding binding join binding.customField cuf join binding.boundProject project where project.id = ( select cpro.id from Campaign c join c.project cpro where c.id = :cpgId ) and binding.boundEntity = :boundEntity order by binding.position asc";
    private static final String FIND_SYNCED_SERVERS = "select distinct serv from RemoteSynchronisation sync join sync.server serv";

    public List<BugTracker> findAllJiraServers() {
        return this.em.createQuery(FIND_SYNCED_SERVERS).getResultList();
    }

    public BugTracker findServerById(long id) {
        return (BugTracker)this.em.find(BugTracker.class, (Object)id);
    }

    public List<String> findAllSyncedJiraProjects() {
        return this.findJiraProjectsFromExtenders(null);
    }

    public List<String> findAllSyncedJiraProjects(long squashProjectId) {
        return this.findJiraProjectsFromExtenders(new RestrictToSquashProject(squashProjectId));
    }

    public Map<BugTracker, List<String>> findJiraProjectsGroupedByServer(Collection<String> serverKeys, Collection<Long> tmProjectIds) {
        QBugTracker server = QBugTracker.bugTracker;
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        QRequirementSyncExtender extender = QRequirementSyncExtender.requirementSyncExtender;
        QRequirement requirement = QRequirement.requirement;
        JPAQuery query = new JPAQuery(this.em);
        return (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select(new Expression[]{server, extender.remoteProjectId}).from((EntityPath)extender)).innerJoin((EntityPath)extender.remoteSynchronisation, (Path)sync)).innerJoin((EntityPath)sync.server, (Path)server)).innerJoin((EntityPath)extender.requirement, (Path)requirement)).where(new Predicate[]{sync.kind.eq((Object)"squash.tm.plugin.jirasync"), extender.remoteProjectId.in(serverKeys), requirement.project.id.in(tmProjectIds)})).transform(GroupBy.groupBy((Expression)server).as((Expression)GroupBy.list((Expression)extender.remoteProjectId)));
    }

    private List<String> findJiraProjectsFromExtenders(QueryCustomizer customizer) {
        List<Long> readableTmProjectIds = this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser();
        QRequirementSyncExtender extender = QRequirementSyncExtender.requirementSyncExtender;
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        QRequirement requirement = QRequirement.requirement;
        JPAQuery query = new JPAQuery(this.em);
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select((Expression)extender.remoteProjectId).from((EntityPath)extender)).innerJoin((EntityPath)extender.remoteSynchronisation, (Path)sync)).innerJoin((EntityPath)extender.requirement, (Path)requirement)).where(new Predicate[]{sync.kind.eq((Object)"squash.tm.plugin.jirasync"), requirement.project.id.in(readableTmProjectIds)})).orderBy(extender.remoteProjectId.asc());
        if (customizer != null) {
            customizer.customize(query);
        }
        return query.fetch();
    }

    public List<String> findAllSyncedBoards() {
        return this.findBoardsFromSync(null);
    }

    public List<String> findAllSyncedBoards(long squashProjectId) {
        return this.findBoardsFromSync(new RestrictToSquashProject(squashProjectId));
    }

    public Map<BugTracker, List<String>> findBoardsGroupedByServer(Collection<String> boardNames) {
        QBugTracker server = QBugTracker.bugTracker;
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        List<Long> readableTmProjectIds = this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser();
        JPAQuery query = new JPAQuery(this.em);
        return (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select(new Expression[]{server, sync.selectValue}).from((EntityPath)sync)).innerJoin((EntityPath)sync.server, (Path)server)).where(new Predicate[]{sync.kind.eq((Object)"squash.tm.plugin.jirasync"), sync.selectType.eq((Object)JiraSelectType.BOARD.toString()), sync.selectValue.in(boardNames), sync.project.id.in(readableTmProjectIds)})).transform(GroupBy.groupBy((Expression)server).as((Expression)GroupBy.list((Expression)sync.selectValue)));
    }

    private List<String> findBoardsFromSync(QueryCustomizer customizer) {
        QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
        List<Long> readableTmProjectIds = this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser();
        JPAQuery query = new JPAQuery(this.em);
        ((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select((Expression)sync.selectValue).from((EntityPath)sync)).where(new Predicate[]{sync.kind.eq((Object)"squash.tm.plugin.jirasync"), sync.selectType.eq((Object)JiraSelectType.BOARD.toString()), sync.project.id.in(readableTmProjectIds)})).orderBy(sync.selectValue.asc());
        if (customizer != null) {
            customizer.customize(query);
        }
        return query.fetch();
    }

    public List<ExecplanTestCase> findTestCasesCoveringFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptyList();
        }
        QTestCase tc = QTestCase.testCase;
        QRequirementVersionCoverage cov = QRequirementVersionCoverage.requirementVersionCoverage;
        QRequirementVersion ver = QRequirementVersion.requirementVersion;
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender ext = QRequirementSyncExtender.requirementSyncExtender;
        Map result = (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select(new Expression[]{tc.id, tc.name, tc.reference, ver.id, ver.reference, ext.remoteReqId}).from((EntityPath)tc)).innerJoin((CollectionExpression)tc.requirementVersionCoverages, (Path)cov)).innerJoin((EntityPath)cov.verifiedRequirementVersion, (Path)ver)).innerJoin((EntityPath)ver.requirement, (Path)req)).innerJoin((EntityPath)req.syncExtender, (Path)ext)).where(new Predicate[]{ext.remoteReqId.in(jiraKeys), tc.project.id.in(this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser())})).transform(GroupBy.groupBy((Expression)Projections.constructor(ExecplanTestCase.class, (Expression[])new Expression[]{tc.id, tc.name, tc.reference})).as((Expression)GroupBy.list((Expression)Projections.constructor(ExecplanRequirement.class, (Expression[])new Expression[]{ver.id, ver.reference, ext.remoteReqId}))));
        return result.entrySet().stream().map(entry -> {
            ExecplanTestCase ctc = (ExecplanTestCase)entry.getKey();
            List creqs = (List)entry.getValue();
            ctc.setRequirements(creqs);
            return ctc;
        }).collect(Collectors.toList());
    }

    public List<ExecplanTestCase> findTestCasesFixedBy(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptyList();
        }
        QTestCase tc = QTestCase.testCase;
        QExecution exec = QExecution.execution;
        QIssue issue = QIssue.issue;
        Map result = (Map)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)new JPAQueryFactory(this.em).select(new Expression[]{tc.id, tc.name, tc.reference, issue.remoteIssueId}).from((EntityPath)exec)).innerJoin((CollectionExpression)exec.issues, (Path)issue)).innerJoin((EntityPath)exec.referencedTestCase, (Path)tc)).where(new Predicate[]{issue.remoteIssueId.in(jiraKeys), tc.project.id.in(this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser())})).transform(GroupBy.groupBy((Expression)Projections.constructor(ExecplanTestCase.class, (Expression[])new Expression[]{tc.id, tc.name, tc.reference})).as((Expression)GroupBy.list((Expression)Projections.constructor(ExecplanIssue.class, (Expression[])new Expression[]{issue.remoteIssueId}))));
        return result.entrySet().stream().map(entry -> {
            ExecplanTestCase ctc = (ExecplanTestCase)entry.getKey();
            List cissues = (List)entry.getValue();
            ctc.setIssues(cissues);
            return ctc;
        }).collect(Collectors.toList());
    }

    public Set<String> filterFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_SYNC_KEY).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterBugfixes(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_BUGFIXES_KEY).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Set<String> filterCoveredFeatures(Collection<String> jiraKeys) {
        if (jiraKeys.isEmpty()) {
            return Collections.emptySet();
        }
        List res = this.em.createQuery(FILTER_COVERED_REQS).setParameter("keys", jiraKeys).getResultList();
        return new HashSet<String>(res);
    }

    public Collection<Long> findTestCasesAlreadyPlannedInCampaign(long campaignId) {
        QCampaign cpg = QCampaign.campaign;
        QCampaignTestPlanItem item = QCampaignTestPlanItem.campaignTestPlanItem;
        QTestCase tc = QTestCase.testCase;
        JPAQuery query = new JPAQuery(this.em);
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select((Expression)tc.id).from((EntityPath)item)).innerJoin((EntityPath)item.campaign, (Path)cpg)).innerJoin((EntityPath)item.referencedTestCase, (Path)tc)).where((Predicate)cpg.id.eq((Object)campaignId));
        return query.fetch();
    }

    public Collection<Long> findTestCasesAlreadyPlannedInIteration(long iterationId) {
        QIteration it = QIteration.iteration;
        QIterationTestPlanItem item = QIterationTestPlanItem.iterationTestPlanItem;
        QTestCase tc = QTestCase.testCase;
        JPAQuery query = new JPAQuery(this.em);
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)query.distinct()).select((Expression)tc.id).from((EntityPath)item)).innerJoin((EntityPath)item.iteration, (Path)it)).innerJoin((EntityPath)item.referencedTestCase, (Path)tc)).where((Predicate)it.id.eq((Object)iterationId));
        return query.fetch();
    }

    public List<String> findIterationNamesForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_NAMES).setParameter("id", (Object)campaignId).getResultList();
    }

    public List<CustomField> findIterationCutomfieldsForCampaign(long campaignId) {
        return this.em.createQuery(FIND_ITERATION_CUFS).setParameter("cpgId", (Object)campaignId).setParameter("boundEntity", (Object)BindableEntity.ITERATION).getResultList();
    }

    public SelectedNode loadSelectedNode(EntityReference reference) {
        Long id = reference.getId();
        String query = null;
        switch (reference.getType()) {
            case CAMPAIGN: {
                query = LOAD_SELECTED_NODE_CPG;
                break;
            }
            case ITERATION: {
                query = LOAD_SELECTED_NODE_IT;
                break;
            }
            default: {
                throw new IllegalArgumentException("Entity Type '" + String.valueOf(reference.getType()) + "' is not yet supported");
            }
        }
        return this.loadSelectedNode(query, id);
    }

    public boolean isWizardEnabledOnProject(long projectId) {
        return (Integer)this.DSL.selectCount().from((TableLike)Tables.LIBRARY_PLUGIN_BINDING).leftJoin((TableLike)Project.PROJECT).on(Project.PROJECT.CL_ID.eq((Field)Tables.LIBRARY_PLUGIN_BINDING.LIBRARY_ID)).where(Project.PROJECT.PROJECT_ID.equal((Object)projectId).and(Tables.LIBRARY_PLUGIN_BINDING.PLUGIN_ID.equal((Object)"squash.tm.plugin.jirasync")).and(Tables.LIBRARY_PLUGIN_BINDING.ACTIVE.eq((Object)true))).fetchOne(0, Integer.class) > 0;
    }

    private SelectedNode loadSelectedNode(String hql, Long entityId) {
        Object[] tuple = (Object[])this.em.createQuery(hql).setParameter("id", (Object)entityId).getSingleResult();
        SelectedNode node = new SelectedNode();
        node.setEntityId((Long)tuple[0]);
        node.setType((String)tuple[1]);
        node.setEntityName((String)tuple[2]);
        node.setProjectId((Long)tuple[3]);
        node.setProjectName((String)tuple[4]);
        return node;
    }

    public Map<Long, String> findHighLevelsHavingLinkInVerifiedRequirements(Map<Long, List<String>> remoteKeysByTestCase) {
        ArrayList<Long> testCaseIds = new ArrayList<Long>(remoteKeysByTestCase.keySet());
        Set remoteKeys = remoteKeysByTestCase.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Requirement REQUIREMENT_LINK_HLR = Tables.REQUIREMENT.as("REQUIREMENT_LINK_HLR");
        return this.DSL.selectDistinct((SelectField)org.jooq.impl.DSL.when((Condition)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNotNull(), (Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).otherwise((Field)REQUIREMENT_LINK_HLR.HIGH_LEVEL_REQUIREMENT_ID).as("HIGH_LEVEL_ID"), (SelectField)org.jooq.impl.DSL.concat((Field[])new Field[]{Tables.REQUIREMENT_VERSION.REFERENCE, org.jooq.impl.DSL.value((String)" - "), Tables.RESOURCE.NAME}).as("REFERENCE")).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds))).leftJoin((TableLike)REQUIREMENT_LINK_HLR).on(REQUIREMENT_LINK_HLR.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID).and(REQUIREMENT_LINK_HLR.HIGH_LEVEL_REQUIREMENT_ID.isNotNull())).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)REQUIREMENT_LINK_HLR.HIGH_LEVEL_REQUIREMENT_ID).or(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID))).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.in(remoteKeys)).fetchMap(org.jooq.impl.DSL.field((String)"HIGH_LEVEL_ID", Long.class), org.jooq.impl.DSL.field((String)"REFERENCE", String.class));
    }

    public List<Long> findTcIdsWhereVerifiedRequirementHavingLink(Long highLevelId, Set<Long> testCaseIds) {
        return this.DSL.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.eq((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID).and(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID.in(testCaseIds))).where(Tables.REQUIREMENT.RLN_ID.eq((Object)highLevelId).or(Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID.eq((Object)highLevelId))).fetchInto(Long.class);
    }

    @FunctionalInterface
    private static interface QueryCustomizer {
        public void customize(JPAQuery<?> var1);
    }

    private static final class RestrictToSquashProject
    implements QueryCustomizer {
        private final long squashProjectId;

        RestrictToSquashProject(long squashProjectId) {
            this.squashProjectId = squashProjectId;
        }

        @Override
        public void customize(JPAQuery<?> query) {
            QRemoteSynchronisation sync = QRemoteSynchronisation.remoteSynchronisation;
            QProject proj = QProject.project1;
            ((JPAQuery)query.innerJoin((EntityPath)sync.project, (Path)proj)).where((Predicate)proj.id.eq((Object)this.squashProjectId));
        }
    }
}

