/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service.execplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import jirasync.com.atlassian.jira.rest.client.api.domain.Version;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ProjectReleases;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ReleasesSearch;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraPagedResource;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResult;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.execplan.ExecplanSynchronizationDao;
import org.squashtest.tm.plugin.jirasync.service.execplan.ReadableProjectsFinder;
import org.squashtest.tm.plugin.jirasync.service.execplan.TicketBrowseUrlFixer;

@Service(value="squash.tm.plugin.jirasync.explanProjectreleaseService")
@Transactional(readOnly=true)
class ExecplanProjectReleaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanProjectReleaseService.class);
    @Inject
    private ClientProvider clientProvider;
    @Inject
    private ExecplanSynchronizationDao dao;
    @Inject
    private ReadableProjectsFinder readableProjectsFinder;

    ExecplanProjectReleaseService() {
    }

    ReleasesSearch findReleases(ReleasesSearch vsearch) {
        Collection<String> projectKeys = vsearch.getJiraProjects();
        List<Long> readableProjectIds = this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser();
        LOGGER.debug("searching jira project releases for the selected projects : {}", projectKeys);
        Map<BugTracker, List<String>> projectsByServer = this.dao.findJiraProjectsGroupedByServer(projectKeys, readableProjectIds);
        ArrayList<ProjectReleases> result = new ArrayList<ProjectReleases>();
        projectsByServer.forEach((bugTracker, projects) -> {
            LOGGER.debug("fetching releases for projects {} on server '{}'", projects, (Object)bugTracker.getName());
            Throwable throwable = null;
            Object var6_7 = null;
            try (JiraClient client = this.clientProvider.createAuthenticatedClient((BugTracker)bugTracker);){
                for (String project : projects) {
                    ProjectReleases proj = this.fetchProjectReleases(client, project, vsearch);
                    result.add(proj);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        vsearch.setResult(result);
        return vsearch;
    }

    @Transactional(readOnly=true)
    List<ExecplanIssue> findReleasedTickets(Collection<ProjectReleases> projectReleases) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("fetching JIRA tickets shipped with released versions : ");
            for (ProjectReleases release : projectReleases) {
                LOGGER.debug("\t{}", (Object)release.log());
            }
        }
        Map<BugTracker, List<ProjectReleases>> releasesByServer = this.locateServerHostingReleases(projectReleases);
        ArrayList<ExecplanIssue> issues = new ArrayList<ExecplanIssue>();
        releasesByServer.forEach((bugTracker, prels) -> {
            LOGGER.debug("fetching JIRA tickets from releases on bugtracker '{}'", (Object)bugTracker.getName());
            Throwable throwable = null;
            Object var5_6 = null;
            try (JiraClient client = this.clientProvider.createAuthenticatedClient((BugTracker)bugTracker);){
                List<Long> releaseIds = prels.stream().flatMap(prel -> prel.getReleases().stream()).map(ProjectReleases.Release::getId).collect(Collectors.toList());
                List<ExecplanIssue> fetched = this.fetchIssuesForVersions(client, releaseIds);
                TicketBrowseUrlFixer urlFixer = new TicketBrowseUrlFixer((BugTracker)bugTracker);
                fetched.forEach(urlFixer::setBrowseUrl);
                issues.addAll(fetched);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        LOGGER.debug("fetched {} issues", (Object)issues.size());
        return issues;
    }

    private ProjectReleases fetchProjectReleases(JiraClient client, String project, ReleasesSearch vsearch) {
        LOGGER.debug("fetching releases for project '{}'", (Object)project);
        ProjectReleases projectReleases = new ProjectReleases();
        projectReleases.setProject(project);
        JiraPagedResource<Version> versionPage = null;
        ReleaseSearchState state = new ReleaseSearchState(vsearch);
        boolean done = false;
        while (!done) {
            LOGGER.trace("paged REST call, page {}", (Object)state.getPage());
            state.nextPage();
            versionPage = client.findPagedVersionsForProject(project, state.getPage(), true).claim();
            List<Version> jiraVersions = versionPage.getValues();
            LOGGER.trace("retrieved {} results", (Object)jiraVersions.size());
            if (jiraVersions.isEmpty()) break;
            LOGGER.trace("...filtering released versions");
            List<ProjectReleases.Release> sqReleases = state.filterAndCollect(jiraVersions);
            LOGGER.trace("{} releases found after filtering", (Object)sqReleases.size());
            projectReleases.addAll(sqReleases);
            done = state.isDone(versionPage);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("done. Releases are : {}", (Object)projectReleases.log());
        }
        return projectReleases;
    }

    private Map<BugTracker, List<ProjectReleases>> locateServerHostingReleases(Collection<ProjectReleases> releases) {
        LOGGER.debug("locating servers hosting those project releases");
        List<String> projectNames = releases.stream().map(ProjectReleases::getProject).collect(Collectors.toList());
        List<Long> readableProjectIds = this.readableProjectsFinder.findAllReadableProjectIdsForCurrentUser();
        Map<BugTracker, List<String>> projectsByServer = this.dao.findJiraProjectsGroupedByServer(projectNames, readableProjectIds);
        return projectsByServer.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List pnames = (List)entry.getValue();
            return releases.stream().filter(rel -> pnames.contains(rel.getProject())).collect(Collectors.toList());
        }));
    }

    private List<ExecplanIssue> fetchIssuesForVersions(JiraClient client, List<Long> versions) {
        LOGGER.debug("fetching issues for version ids : {}", versions);
        ArrayList<ExecplanIssue> issues = new ArrayList<ExecplanIssue>();
        if (client.isJiraCloudServer()) {
            this.fetchIssuesForVersionsCloud(client, versions, issues);
        } else {
            this.fetchIssuesForVersionsDataCenter(client, versions, issues);
        }
        LOGGER.debug("done");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("retrieved issues : {}", issues.stream().map(ExecplanIssue::getKey).toList());
        }
        return issues;
    }

    private void fetchIssuesForVersionsDataCenter(JiraClient client, List<Long> versions, List<ExecplanIssue> issues) {
        JiraSearchResult<ExecplanIssue> result;
        int pagenum = 0;
        int fetchCnt = 0;
        do {
            LOGGER.trace("paged REST call (DC), page {}", (Object)pagenum);
            result = client.findExecplanIssuesForVersions(versions, pagenum).claim();
            for (ExecplanIssue jirssue : result.getIssues()) {
                ++fetchCnt;
                issues.add(jirssue);
            }
            LOGGER.trace("retrieved issues (DC) : {} / {}", (Object)fetchCnt, (Object)result.getTotal());
            ++pagenum;
        } while (fetchCnt < result.getTotal());
    }

    private void fetchIssuesForVersionsCloud(JiraClient client, List<Long> versions, List<ExecplanIssue> issues) {
        JiraSearchResult<ExecplanIssue> result;
        String jql = versions.stream().map(id -> "fixVersion=" + String.valueOf(id)).collect(Collectors.joining(" or "));
        String nextPageToken = null;
        int fetchCnt = 0;
        do {
            LOGGER.trace("paged REST call (Cloud), nextPageToken={}", nextPageToken);
            result = client.findExecplanIssueForJqlCloud(jql, nextPageToken).claim();
            for (ExecplanIssue jirssue : result.getIssues()) {
                ++fetchCnt;
                issues.add(jirssue);
            }
            LOGGER.trace("retrieved issues (Cloud) : {} / {}", (Object)fetchCnt, (Object)result.getTotal());
        } while ((nextPageToken = result.getNextPageToken()) != null);
    }

    private static class ReleaseSearchState {
        private int page = -1;
        private final DateTime minDate;
        private final String nameLike;
        private final Integer maxResult;
        private int foundResults = 0;

        ReleaseSearchState(ReleasesSearch search) {
            Date since = search.getReleasedSince();
            this.minDate = since != null ? new DateTime((Object)since) : null;
            this.maxResult = this.postitiveOrNull(search.getMostRecentReleasesLimit());
            this.nameLike = search.getNameLike();
        }

        private Integer postitiveOrNull(Integer limit) {
            if (limit == null) {
                return null;
            }
            if (limit < 0) {
                return 0;
            }
            return limit;
        }

        ReleaseSearchState(DateTime minDate, String nameLike, Integer maxResult) {
            this.minDate = minDate;
            this.nameLike = nameLike;
            this.maxResult = maxResult;
        }

        int getPage() {
            return this.page;
        }

        void nextPage() {
            ++this.page;
        }

        List<ProjectReleases.Release> filterAndCollect(List<Version> jiraVersions) {
            Stream<Object> stream = jiraVersions.stream();
            stream = stream.filter(Version::isReleased);
            if (this.minDate != null) {
                LOGGER.trace("...filtering versions released after the specified minimal date");
                stream = stream.filter(version -> version.getReleaseDate() == null || version.getReleaseDate().isAfter((ReadableInstant)this.minDate));
            }
            if (this.nameLike != null) {
                LOGGER.trace("...filtering versions matching name '{}'", (Object)this.nameLike);
                stream = stream.filter(version -> version.getName().contains(this.nameLike));
            }
            List<ProjectReleases.Release> sqReleases = stream.map(this::toRelease).collect(Collectors.toList());
            if (this.maxResult != null && this.foundResults + sqReleases.size() >= this.maxResult) {
                LOGGER.trace("triming the extraneous results to '{}'", (Object)this.maxResult);
                sqReleases = sqReleases.subList(0, this.maxResult - this.foundResults);
            }
            this.foundResults += sqReleases.size();
            return sqReleases;
        }

        private ProjectReleases.Release toRelease(Version jiraVersion) {
            return new ProjectReleases.Release(jiraVersion.getId(), jiraVersion.getName(), jiraVersion.getReleaseDate());
        }

        boolean isDone(JiraPagedResource<Version> versionPage) {
            List<Version> jiraVersions = versionPage.getValues();
            boolean isLast = false;
            boolean reachedMinDate = false;
            boolean maxResExceeded = false;
            isLast = versionPage.isLast();
            LOGGER.trace("page was last : {}", (Object)isLast);
            if (this.minDate != null && !jiraVersions.isEmpty()) {
                DateTime lastDateOfPage = jiraVersions.get(jiraVersions.size() - 1).getReleaseDate();
                reachedMinDate = lastDateOfPage != null && this.minDate.isAfter((ReadableInstant)lastDateOfPage);
                LOGGER.trace("reached minimal date : {} ", (Object)reachedMinDate);
            }
            if (this.maxResult != null && this.foundResults >= this.maxResult) {
                maxResExceeded = true;
                LOGGER.trace("reached maximum desired results : {}", (Object)this.maxResult);
            }
            boolean done = isLast || reachedMinDate || maxResExceeded;
            LOGGER.trace("is the job done : {}", (Object)done);
            return done;
        }
    }
}

