/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.advancedissue.customfields.defaultvalue.setter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.validator.GenericValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.ProjectCustomField;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.advancedissue.customfields.defaultvalue.setter.DefaultValueSetter;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.mantisissue.customfields.converter.DateFieldValueSetter;

public class DateDefaultValueSetter
implements DefaultValueSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateFieldValueSetter.class);
    private static final List<String> dateFormats = Arrays.asList("yyyy-MM-dd", "yyyy/MM/dd", "yyyyMMdd", "dd-MM-yyyy", "dd/MM/yyyy");

    @Override
    public void setDefaultValue(ProjectCustomField field, AdvancedIssue issue) {
        block3: {
            String defaultValue = field.getDefaultValue();
            if (!defaultValue.isEmpty()) {
                try {
                    String formattedDate = new SimpleDateFormat("yyyy-MM-dd").format(this.getCorrectDateFormat(defaultValue));
                    issue.setFieldValue(field.getName(), new FieldValue(formattedDate, formattedDate));
                }
                catch (ParseException e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("Invalid date format.", (Throwable)e);
                }
            }
        }
    }

    private Date getCorrectDateFormat(String date) throws ParseException {
        String defaultDateFormat = "";
        for (String format : dateFormats) {
            if (!GenericValidator.isDate((String)date, (String)format, (boolean)true)) continue;
            defaultDateFormat = format;
        }
        return new SimpleDateFormat(defaultDateFormat).parse(date);
    }
}

