/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.conversion;

import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.squashtest.csp.core.bugtracker.core.markdown.ExtendedMarkdownBuilder;
import org.squashtest.tm.bugtracker.definition.context.ExecutionInfo;
import org.squashtest.tm.bugtracker.definition.context.ExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.ExecutionSubItemInfo;
import org.squashtest.tm.bugtracker.definition.context.ExploratorySessionNoteInfo;
import org.squashtest.tm.bugtracker.definition.context.KeywordExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.bugtracker.definition.context.ScriptedExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.StandardExecutionStepInfo;
import org.squashtest.tm.bugtracker.definition.context.TestCaseInfo;
import org.squashtest.tm.bugtracker.definition.context.formatter.DefaultRemoteIssueContextFormatter;

@Service(value="squashtest.bugtracker.gitlab.RemoteIssueContextFormatter")
public class RemoteIssueContextFormatter
extends DefaultRemoteIssueContextFormatter {
    public RemoteIssueContextFormatter(MessageSource messageSource) {
        super(messageSource);
    }

    public String buildDefaultDescription(RemoteIssueContext context) {
        boolean issueWasReportedInStep;
        ExtendedMarkdownBuilder builder = new ExtendedMarkdownBuilder().appendQuoteBlock(this.buildCommonDescription(context));
        String testCasePrerequisite = context.getExecution().getPrerequisite();
        if (StringUtils.hasText((String)testCasePrerequisite)) {
            builder.appendQuoteBlock(this.buildTestCasePrerequisite(context.getTestCase(), context.getExecution()));
        }
        if (issueWasReportedInStep = context.issueWasReportedInStep()) {
            this.buildStepsSection(context, builder);
        }
        return builder.build();
    }

    private ExtendedMarkdownBuilder buildTestCasePrerequisite(TestCaseInfo testCaseInfo, ExecutionInfo executionInfo) {
        boolean isScripted = testCaseInfo.getKind().equals((Object)TestCaseInfo.Kind.GHERKIN);
        if (isScripted) {
            return ((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendHeader2(this.getLocaleTestCaseContext())).appendCodeBlock(executionInfo.getPrerequisite());
        }
        return (ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendHeader2(this.getLocalePrerequisite())).appendParagraph(executionInfo.getPrerequisite());
    }

    private ExtendedMarkdownBuilder buildCommonDescription(RemoteIssueContext context) {
        return (ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendHeader2(this.buildTestCaseTitle(context))).appendParagraph(this.buildExecutionInfo(context))).appendParagraph(this.buildIssuedStepNumber(context))).appendHeader3(this.getLocaleDescriptionTitleLabel());
    }

    private void buildStepsSection(RemoteIssueContext context, ExtendedMarkdownBuilder builder) {
        TestCaseInfo.Kind kind = context.getTestCase().getKind();
        switch (kind) {
            case STANDARD: {
                this.buildStandardStepsSection(context, builder);
                break;
            }
            case KEYWORD: {
                this.buildKeywordStepsSection(context, builder);
                break;
            }
            case GHERKIN: {
                this.buildScriptedStepsSection(context, builder);
                break;
            }
            case EXPLORATORY: {
                this.buildExploratorySessionNotesSection(context, builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot build steps description for kind " + kind.name());
            }
        }
    }

    private void buildScriptedStepsSection(RemoteIssueContext context, ExtendedMarkdownBuilder builder) {
        Optional buggedStep = context.findBuggedStep();
        if (buggedStep.isPresent() && ((ExecutionStepInfo)buggedStep.get()).getClass().isAssignableFrom(ScriptedExecutionStepInfo.class)) {
            ScriptedExecutionStepInfo scriptedStep = (ScriptedExecutionStepInfo)buggedStep.get();
            builder.appendQuoteBlock(((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendHeader2(this.getLocaleScriptLabel())).appendCodeBlock(scriptedStep.getScript()));
        }
    }

    private void buildStandardStepsSection(RemoteIssueContext context, ExtendedMarkdownBuilder builder) {
        for (int i = 0; i < context.getSubItems().size(); ++i) {
            ExecutionSubItemInfo step = (ExecutionSubItemInfo)context.getSubItems().get(i);
            if (!step.getTestCaseKind().equals((Object)TestCaseInfo.Kind.STANDARD)) {
                throw new IllegalArgumentException("RemoteIssueContext seems malformed : found a non standard execution step within a standard execution.");
            }
            builder.appendQuoteBlock(this.buildStandardExecutionStepSection((StandardExecutionStepInfo)step, context));
            if (step.getId().equals(context.getBuggedItemId())) break;
        }
    }

    private ExtendedMarkdownBuilder buildStandardExecutionStepSection(StandardExecutionStepInfo step, RemoteIssueContext context) {
        return (ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendHeader2(this.buildCurrentStepNumber(step, context))).appendHeader3(this.getLocaleActionLabel())).appendPlainText(step.getAction())).appendHeader3(this.getLocaleExpectedResultLabel())).appendPlainText(step.getExpectedResult());
    }

    private void buildKeywordStepsSection(RemoteIssueContext context, ExtendedMarkdownBuilder builder) {
        String allSteps = context.getSubItems().stream().map(step -> ((KeywordExecutionStepInfo)step).getAction()).collect(Collectors.joining(builder.getLineSeparator()));
        builder.appendQuoteBlock(((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendHeader2(this.getLocaleTestStepsTitleLabel())).appendCodeBlock(allSteps));
    }

    private void buildExploratorySessionNotesSection(RemoteIssueContext context, ExtendedMarkdownBuilder builder) {
        Object t;
        Optional buggedItem = context.findBuggedItem();
        if (buggedItem.isPresent() && (t = buggedItem.get()) instanceof ExploratorySessionNoteInfo) {
            ExploratorySessionNoteInfo noteInfo = (ExploratorySessionNoteInfo)t;
            builder.appendQuoteBlock((ExtendedMarkdownBuilder)new ExtendedMarkdownBuilder().appendParagraph(noteInfo.getContent()));
        }
    }
}

