/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerProviderDescriptor;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.gitlab.GitLabBugtrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.GitlabConnectorProvider")
public class GitlabBugtrackerConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    public static final String KIND = "gitlab.bugtracker";
    private static final String LABEL = "GitLab Bugtracker REST connector";
    @Inject
    private Provider<GitLabBugtrackerConnector> connectorProvider;
    @Inject
    @Named(value="gitlabConnectorMessageSource")
    private MessageSource messageSource;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        GitLabBugtrackerConnector connector = this.connectorProvider.get();
        connector.setBugTracker(bugTracker);
        return connector;
    }

    public BugTrackerProviderDescriptor getDescriptor() {
        return new BugTrackerProviderDescriptor(){

            public boolean usePathToProjects() {
                return true;
            }

            public String getProjectHelpMessage() {
                return GitlabBugtrackerConnectorProvider.this.messageSource.getMessage("interface.configuration.project-help-message", null, LocaleContextHolder.getLocale());
            }
        };
    }
}

