/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GitLabBugtrackerConnectorProperties {
    private static final int LIMIT_MIN_RESULTS_PER_SEARCH = 5;
    private static final int LIMIT_MAX_RESULTS_PER_SEARCH = 100;
    private static final String UPDATE_CONFIG_FILE = "Please update the configuration file to customise this value.";
    @Value(value="${squash.bugtracker.max-results-per-search:50}")
    private int maxResultsPerSearch;

    public int getMaxResultsPerSearch() {
        return this.maxResultsPerSearch;
    }

    @PostConstruct
    private void initMaxResultsPerSearch() {
        if (this.maxResultsPerSearch < 5) {
            throw new IllegalArgumentException("The property 'squash.bugtracker.max-results-per-search' has a minimum value of 5. Please update the configuration file to customise this value.");
        }
        if (this.maxResultsPerSearch > 100) {
            throw new IllegalArgumentException("The property 'squash.bugtracker.max-results-per-search' has a maximum value of 100. Please update the configuration file to customise this value.");
        }
    }
}

