/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.client;

import gitlabbt.jakarta.ws.rs.ConstrainedTo;
import gitlabbt.jakarta.ws.rs.RuntimeType;
import gitlabbt.jakarta.ws.rs.WebApplicationException;
import gitlabbt.jakarta.ws.rs.core.MediaType;
import gitlabbt.jakarta.ws.rs.core.MultivaluedMap;
import gitlabbt.jakarta.ws.rs.ext.MessageBodyReader;
import gitlabbt.org.glassfish.jersey.client.ChunkedInput;
import gitlabbt.org.glassfish.jersey.internal.PropertiesDelegate;
import gitlabbt.org.glassfish.jersey.internal.util.ReflectionHelper;
import gitlabbt.org.glassfish.jersey.message.MessageBodyWorkers;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;

@ConstrainedTo(value=RuntimeType.CLIENT)
class ChunkedInputReader
implements MessageBodyReader<ChunkedInput> {
    @Inject
    private Provider<MessageBodyWorkers> messageBodyWorkers;
    @Inject
    private Provider<PropertiesDelegate> propertiesDelegateProvider;

    ChunkedInputReader() {
    }

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return aClass.equals(ChunkedInput.class);
    }

    @Override
    public ChunkedInput readFrom(Class<ChunkedInput> chunkedInputClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream inputStream) throws IOException, WebApplicationException {
        Type chunkType = ReflectionHelper.getTypeArgument(type, 0);
        return new ChunkedInput(chunkType, inputStream, annotations, mediaType, headers, this.messageBodyWorkers.get(), this.propertiesDelegateProvider.get());
    }
}

