/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.Form;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.License;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class LicenseApi
extends AbstractApi {
    public LicenseApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public License getLicense() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "license");
        return response.readEntity(License.class);
    }

    public Optional<License> getOptionalLicense() {
        try {
            return Optional.ofNullable(this.getLicense());
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<License> getAllLicenses() throws GitLabApiException {
        return this.getAllLicenses(this.getDefaultPerPage()).all();
    }

    public Stream<License> getAllLicensesStream() throws GitLabApiException {
        return this.getAllLicenses(this.getDefaultPerPage()).stream();
    }

    public Pager<License> getAllLicenses(int itemsPerPage) throws GitLabApiException {
        return new Pager<License>(this, License.class, itemsPerPage, null, "licenses");
    }

    public License addLicense(String licenseString) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("license", licenseString, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "license");
        return response.readEntity(License.class);
    }

    public License deleteLicense(Integer licenseId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "license", licenseId);
        return response.readEntity(License.class);
    }
}

