/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.jakarta.ws.rs.core.GenericType;
import gitlabbt.jakarta.ws.rs.core.Response;
import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.Constants;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Event;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;

public class EventsApi
extends AbstractApi {
    public EventsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, this.getDefaultPerPage()).all();
    }

    public List<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "events");
        return response.readEntity(new GenericType<List<Event>>(){});
    }

    public Pager<Event> getAuthenticatedUserEvents(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, formData.asMap(), "events");
    }

    public Stream<Event> getAuthenticatedUserEventsStream(Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getAuthenticatedUserEvents(action, targetType, before, after, sortOrder, this.getDefaultPerPage()).stream();
    }

    public List<Event> getUserEvents(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getUserEvents(userIdOrUsername, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).all();
    }

    public List<Event> getUserEvents(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "events");
        return response.readEntity(new GenericType<List<Event>>(){});
    }

    public Pager<Event> getUserEvents(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, formData.asMap(), "users", this.getUserIdOrUsername(userIdOrUsername), "events");
    }

    public Stream<Event> getUserEventsStream(Object userIdOrUsername, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getUserEvents(userIdOrUsername, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).stream();
    }

    public List<Event> getProjectEvents(Object projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getProjectEvents(projectIdOrPath, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).all();
    }

    public List<Event> getProjectEvents(Integer projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "events");
        return response.readEntity(new GenericType<List<Event>>(){});
    }

    public Pager<Event> getProjectEvents(Object projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("action", (Object)action).withParam("target_type", targetType != null ? targetType.toValue().toLowerCase() : null).withParam("before", before).withParam("after", after).withParam("sort", (Object)sortOrder);
        return new Pager<Event>(this, Event.class, itemsPerPage, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "events");
    }

    public Stream<Event> getProjectEventsStream(Object projectIdOrPath, Constants.ActionType action, Constants.TargetType targetType, Date before, Date after, Constants.SortOrder sortOrder) throws GitLabApiException {
        return this.getProjectEvents(projectIdOrPath, action, targetType, before, after, sortOrder, this.getDefaultPerPage()).stream();
    }
}

