/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.wizard.campaignassistant.internal.service;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.springframework.stereotype.Service;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.Issue;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.campaign.CustomCampaignModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.wizard.campaignassistant.internal.exception.InvalidModelException;
import org.squashtest.tm.wizard.campaignassistant.internal.repository.WizardDao;
import org.squashtest.tm.wizard.campaignassistant.internal.service.CampaignAssistantWizardService;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationReplicationCriteria;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationReplicationModel;
import org.squashtest.tm.wizard.campaignassistant.internal.service.dto.IterationTestPlanItemDto;

@Service
@Transactional
public class CampaignAssistantWizardServiceImpl
implements CampaignAssistantWizardService {
    @Inject
    private WizardDao wizardDao;
    @Inject
    private IterationModificationService iterationService;
    @Inject
    private IterationTestPlanManagerService testPlanService;
    @Inject
    private CustomCampaignModificationService customCampaignModificationService;
    @Inject
    private IterationDao iterationDao;
    @Inject
    private BugTrackersLocalService connector;
    @Inject
    private BugTrackerFinderService bugTrackerFinderService;
    @Inject
    private PrivateCustomFieldValueService customFieldValueService;

    @Override
    public List<NamedReference> getIterationsByCampaignId(long campaignId) {
        return this.wizardDao.getIterationsByCampaignId(campaignId);
    }

    @Override
    public PagedCollectionHolder<List<IterationTestPlanItemDto>> getReplicatedITPI(IterationReplicationCriteria criteria, PagingAndSorting pas) {
        Iteration sourceIteration = (Iteration)this.iterationService.findById(criteria.getIterationId());
        List sourceTestPlan = sourceIteration.getTestPlans();
        ArrayList<IterationTestPlanItemDto> targetTestPlan = new ArrayList<IterationTestPlanItemDto>();
        for (IterationTestPlanItem itpi : sourceTestPlan) {
            if (itpi.getReferencedTestCase() == null || !criteria.itpiComplies(itpi)) continue;
            IterationTestPlanItemDto itpiDto = new IterationTestPlanItemDto(itpi, criteria.isKeepTestSuites(), criteria.isKeepAssignees());
            targetTestPlan.add(itpiDto);
        }
        return new PagingBackedPagedCollectionHolder((Paging)pas, (long)targetTestPlan.size(), targetTestPlan);
    }

    @Override
    public List<IterationTestPlanItemDto> getReplicatedITPI(IterationReplicationCriteria criteria) {
        Iteration sourceIteration = (Iteration)this.iterationService.findById(criteria.getIterationId());
        List sourceTestPlan = sourceIteration.getTestPlans();
        ArrayList<IterationTestPlanItemDto> targetTestPlan = new ArrayList<IterationTestPlanItemDto>();
        for (IterationTestPlanItem itpi : sourceTestPlan) {
            if (itpi.getReferencedTestCase() == null || !criteria.itpiComplies(itpi)) continue;
            IterationTestPlanItemDto itpiDto = new IterationTestPlanItemDto(itpi, criteria.isKeepTestSuites(), criteria.isKeepAssignees());
            targetTestPlan.add(itpiDto);
        }
        return targetTestPlan;
    }

    @Override
    public Long replicateIteration(IterationReplicationModel replicationModel) {
        String targetName = replicationModel.getIterationName();
        if (targetName.isEmpty()) {
            throw new InvalidModelException();
        }
        Iteration sourceIteration = (Iteration)this.iterationService.findById(replicationModel.getSourceIterationId().longValue());
        Campaign sourceCampaign = sourceIteration.getCampaign();
        if (!sourceCampaign.isContentNameAvailable(targetName)) {
            throw new DuplicateNameException(targetName, targetName);
        }
        Iteration targetIteration = replicationModel.extractIteration();
        List copiedTestPlan = this.testPlanService.findTestPlanItems(replicationModel.getItpiIds());
        this.iterationDao.persist((Object)targetIteration);
        this.customFieldValueService.createAllCustomFieldValues((BoundEntity)targetIteration, sourceIteration.getProject());
        sourceCampaign.addContent(targetIteration);
        this.replicateTestPlan(targetIteration, copiedTestPlan, replicationModel.isKeepAssignees(), replicationModel.isKeepTestSuites());
        return targetIteration.getId();
    }

    private void replicateTestPlan(Iteration targetIteration, List<IterationTestPlanItem> testPlan, boolean copyAssignees, boolean copyTestSuites) {
        for (IterationTestPlanItem sourceItpi : testPlan) {
            if (sourceItpi.isTestCaseDeleted()) continue;
            IterationTestPlanItem targetItpi = new IterationTestPlanItem(sourceItpi.getReferencedTestCase(), sourceItpi.getReferencedDataset());
            this.copyAssigneesIfNeeded(copyAssignees, sourceItpi, targetItpi);
            targetIteration.addTestPlan(targetItpi);
            this.copyTestSuitesIfNeeded(copyTestSuites, targetIteration, sourceItpi, targetItpi);
        }
    }

    private void copyTestSuitesIfNeeded(boolean copyTestSuites, Iteration targetIteration, IterationTestPlanItem sourceItpi, IterationTestPlanItem targetItpi) {
        if (copyTestSuites) {
            for (TestSuite sourceSuite : sourceItpi.getTestSuites()) {
                TestSuite targetSuite = null;
                try {
                    try {
                        targetSuite = targetIteration.getTestSuiteByName(sourceSuite.getName());
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        targetSuite = sourceSuite.createCopy();
                        this.iterationService.addTestSuite(targetIteration.getId().longValue(), targetSuite);
                        targetSuite.bindTestPlanItem(targetItpi);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    targetSuite.bindTestPlanItem(targetItpi);
                    throw throwable;
                }
                targetSuite.bindTestPlanItem(targetItpi);
            }
        }
    }

    private void copyAssigneesIfNeeded(boolean copyAssignees, IterationTestPlanItem sourceItpi, IterationTestPlanItem targetItpi) {
        if (copyAssignees) {
            targetItpi.setUser(sourceItpi.getUser());
        }
    }

    @Override
    public <NODE> NODE coerceIntoNode(EntityReference ref) {
        return this.wizardDao.coerceIntoNode(ref);
    }

    @Override
    public List<RemoteIssue> findIssues(long iterationId, long serverId) {
        List<String> issueKeys = this.wizardDao.findIssues(iterationId, serverId);
        BugTracker bt = this.bugTrackerFinderService.findById(serverId);
        return this.connector.getIssues(null, issueKeys, bt);
    }

    @Override
    public List<RemoteIssue> findIssuesOnlyLastExec(long iterationId, long serverId) {
        ArrayList<String> issueKeys = new ArrayList<String>();
        BugTracker bt = this.bugTrackerFinderService.findById(serverId);
        Iteration iter = (Iteration)this.iterationService.findById(iterationId);
        List plans = iter.getTestPlans();
        for (IterationTestPlanItem plan : plans) {
            Execution lastExec = plan.getLatestExecution();
            if (lastExec == null || lastExec.getIssues() == null || lastExec.getIssues().size() == 0 || lastExec.getReferencedTestCase() == null) continue;
            for (Issue issue : lastExec.getIssues()) {
                if (issue.getId() == null || issue.getRemoteIssueId() == null) continue;
                issueKeys.add(issue.getRemoteIssueId());
            }
        }
        return this.connector.getIssues(null, issueKeys, bt);
    }

    @Override
    public List<Long> findItpisByRemoteIssues(long iterationId, List<String> remoteIds) {
        return this.wizardDao.findItpisByRemoteIssues(iterationId, remoteIds);
    }

    @Override
    public AuthenticationStatus checkBugtrackerStatus(long projectId) {
        return this.connector.checkAuthenticationStatus(Long.valueOf(projectId));
    }

    @Override
    public Integer getNbIterations(long iterationId) {
        long campaignId = ((Iteration)this.iterationService.findById(iterationId)).getCampaign().getId();
        return this.customCampaignModificationService.countIterations(Long.valueOf(campaignId));
    }

    @Override
    public boolean isWizardEnabledOnProject(long projectId) {
        return this.wizardDao.isWizardEnabledOnProject(projectId);
    }
}

