/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageCampaignBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageRequirementBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.AbstractItemProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QuaCoverageIterationProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QueryContext;

public class QuaCoverageCampaignProcess
extends AbstractItemProcess {
    private List<QuaCoverageCampaignBean> campaignBeans;
    private Collection<Integer> milestoneIds;

    public List<QuaCoverageCampaignBean> getCampaigns(QueryContext ctx, Long projectId) {
        this.campaignBeans = new ArrayList<QuaCoverageCampaignBean>();
        Resource query = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.milestoneIds == null) {
            query = (Resource)ctx.get("campaignsByProject");
            parameters.put("id", projectId);
        } else {
            query = (Resource)ctx.get("campaignsByProjectAndMilestones");
            parameters.put("id", projectId);
            parameters.put("milestones", this.milestoneIds);
        }
        List result = ctx.getRunner().executeSelect(this.loadQuery(query), parameters);
        this.convertResultToCampaignBean(result, ctx);
        return this.campaignBeans;
    }

    private void convertResultToCampaignBean(List<Object[]> result, QueryContext ctx) {
        for (Object[] row : result) {
            QuaCoverageCampaignBean campaignBean = new QuaCoverageCampaignBean();
            campaignBean.setCampaignId(this.evaluateExpressionToLong(row[0]));
            campaignBean.setCampaignName(this.evaluateExpressionToString(row[1]));
            campaignBean.setRequirements(this.getRequirementBeans(ctx, campaignBean.getCampaignId()));
            QuaCoverageIterationProcess iterationProcess = new QuaCoverageIterationProcess();
            campaignBean.setIterations(iterationProcess.getIterations(ctx, campaignBean.getCampaignId()));
            this.campaignBeans.add(campaignBean);
        }
    }

    private List<QuaCoverageRequirementBean> getRequirementBeans(QueryContext ctx, Long campaignId) {
        ArrayList<QuaCoverageRequirementBean> requirementBeans = new ArrayList<QuaCoverageRequirementBean>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("id", campaignId);
        List result = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("requirementsByCampaign")), parameters);
        for (Object[] row : result) {
            QuaCoverageRequirementBean requirementBean = new QuaCoverageRequirementBean();
            requirementBean.setRequirementId(this.evaluateExpressionToLong(row[0]));
            requirementBean.setRequirementName(this.evaluateExpressionToString(row[1]));
            requirementBean.setReference(this.evaluateExpressionToString(row[2]));
            requirementBean.setVersion(this.evaluateExpressionToString(row[3]));
            requirementBean.setCriticality(this.evaluateExpressionToString(row[4]));
            requirementBean.setSuccess(this.evaluateExpressionToLong(row[5]));
            requirementBean.setFailure(this.evaluateExpressionToLong(row[6]));
            requirementBean.setUntestable(this.evaluateExpressionToLong(row[7]));
            requirementBean.setBlocked(this.evaluateExpressionToLong(row[8]));
            requirementBean.setRunning(this.evaluateExpressionToLong(row[9]));
            requirementBean.setReady(this.evaluateExpressionToLong(row[10]));
            requirementBean.setSettled(this.evaluateExpressionToLong(row[11]));
            requirementBeans.add(requirementBean);
        }
        return requirementBeans;
    }

    public void setMilestoneIds(Collection<Integer> milestoneIds) {
        this.milestoneIds = milestoneIds;
    }
}

