/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageRequirementBean;

public abstract class QuaCoverageRequirementVerifier {
    private List<QuaCoverageRequirementBean> requirements = new ArrayList<QuaCoverageRequirementBean>();
    private Map<String, Long> statistics = new HashMap<String, Long>();
    private Long numberOfNontestedCriticalRequirements = 0L;
    private Long numberOfTestedCriticalRequirements = 0L;
    private Long totalNumberOfCriticalRequirements = 0L;
    private Long numberOfVerifiedCriticalRequirements = 0L;
    private Long numberOfNontestedMajorRequirements = 0L;
    private Long numberOfTestedMajorRequirements = 0L;
    private Long totalNumberOfMajorRequirements = 0L;
    private Long numberOfVerifiedMajorRequirements = 0L;
    private Long numberOfNontestedMinorRequirements = 0L;
    private Long numberOfTestedMinorRequirements = 0L;
    private Long totalNumberOfMinorRequirements = 0L;
    private Long numberOfVerifiedMinorRequirements = 0L;
    private Long numberOfNontestedUndefinedRequirements = 0L;
    private Long numberOfTestedUndefinedRequirements = 0L;
    private Long totalNumberOfUndefinedRequirements = 0L;
    private Long numberOfVerifiedUndefinedRequirements = 0L;
    private Long numberOfNontestedRequirements = 0L;
    private Long numberOfTestedRequirements = 0L;
    private Long totalNumberOfRequirements = 0L;
    private Double percentageOfProgress = 0.0;
    private Long totalNumberOfVerifiedRequirements = 0L;

    public List<QuaCoverageRequirementBean> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<QuaCoverageRequirementBean> requirements) {
        this.requirements = requirements;
        this.calculateStatistics();
    }

    private void calculateStatistics() {
        for (QuaCoverageRequirementBean req : this.requirements) {
            String key = req.getStatus() + ":" + req.getCriticality();
            if (this.statistics.containsKey(key)) {
                this.statistics.put(key, this.statistics.get(key) + 1L);
                continue;
            }
            this.statistics.put(key, 1L);
        }
        this.setNumberOfNontestedCriticalRequirements(this.getLongForKey("NOT_CHECKED:CRITICAL"));
        this.setNumberOfTestedCriticalRequirements(this.getLongForKey("CHECKED:CRITICAL") + this.getLongForKey("INCONCLUSIVE:CRITICAL"));
        this.setTotalNumberOfCriticalRequirements(this.numberOfNontestedCriticalRequirements + this.numberOfTestedCriticalRequirements);
        this.setNumberOfVerifiedCriticalRequirements(this.getLongForKey("CHECKED:CRITICAL"));
        this.setNumberOfNontestedMajorRequirements(this.getLongForKey("NOT_CHECKED:MAJOR"));
        this.setNumberOfTestedMajorRequirements(this.getLongForKey("CHECKED:MAJOR") + this.getLongForKey("INCONCLUSIVE:MAJOR"));
        this.setTotalNumberOfMajorRequirements(this.numberOfNontestedMajorRequirements + this.numberOfTestedMajorRequirements);
        this.setNumberOfVerifiedMajorRequirements(this.getLongForKey("CHECKED:MAJOR"));
        this.setNumberOfNontestedMinorRequirements(this.getLongForKey("NOT_CHECKED:MINOR"));
        this.setNumberOfTestedMinorRequirements(this.getLongForKey("CHECKED:MINOR") + this.getLongForKey("INCONCLUSIVE:MINOR"));
        this.setTotalNumberOfMinorRequirements(this.numberOfNontestedMinorRequirements + this.numberOfTestedMinorRequirements);
        this.setNumberOfVerifiedMinorRequirements(this.getLongForKey("CHECKED:MINOR"));
        this.setNumberOfNontestedUndefinedRequirements(this.getLongForKey("NOT_CHECKED:UNDEFINED"));
        this.setNumberOfTestedUndefinedRequirements(this.getLongForKey("CHECKED:UNDEFINED") + this.getLongForKey("INCONCLUSIVE:UNDEFINED"));
        this.setTotalNumberOfUndefinedRequirements(this.numberOfNontestedUndefinedRequirements + this.numberOfTestedUndefinedRequirements);
        this.setNumberOfVerifiedUndefinedRequirements(this.getLongForKey("CHECKED:UNDEFINED"));
        this.setNumberOfNontestedRequirements(this.numberOfNontestedCriticalRequirements + this.numberOfNontestedMajorRequirements + this.numberOfNontestedMinorRequirements + this.numberOfNontestedUndefinedRequirements);
        this.setNumberOfTestedRequirements(this.numberOfTestedCriticalRequirements + this.numberOfTestedMajorRequirements + this.numberOfTestedMinorRequirements + this.numberOfTestedUndefinedRequirements);
        this.setTotalNumberOfRequirements(this.numberOfNontestedRequirements + this.numberOfTestedRequirements);
        this.setPercentageOfProgress(this.numberOfTestedRequirements.doubleValue() / this.totalNumberOfRequirements.doubleValue() * 100.0);
        this.setTotalNumberOfVerifiedRequirements(this.numberOfVerifiedCriticalRequirements + this.numberOfVerifiedMajorRequirements + this.numberOfVerifiedMinorRequirements + this.numberOfVerifiedUndefinedRequirements);
    }

    private Long getLongForKey(String key) {
        Long result = 0L;
        if (this.statistics.containsKey(key)) {
            result = this.statistics.get(key);
        }
        return result;
    }

    public Long getNumberOfNontestedCriticalRequirements() {
        return this.numberOfNontestedCriticalRequirements;
    }

    public void setNumberOfNontestedCriticalRequirements(Long numberOfNontestedCriticalRequirements) {
        this.numberOfNontestedCriticalRequirements = numberOfNontestedCriticalRequirements;
    }

    public Long getNumberOfTestedCriticalRequirements() {
        return this.numberOfTestedCriticalRequirements;
    }

    public void setNumberOfTestedCriticalRequirements(Long numberOfTestedCriticalRequirements) {
        this.numberOfTestedCriticalRequirements = numberOfTestedCriticalRequirements;
    }

    public Long getTotalNumberOfCriticalRequirements() {
        return this.totalNumberOfCriticalRequirements;
    }

    public void setTotalNumberOfCriticalRequirements(Long totalNumberOfCriticalRequirements) {
        this.totalNumberOfCriticalRequirements = totalNumberOfCriticalRequirements;
    }

    public Long getNumberOfVerifiedCriticalRequirements() {
        return this.numberOfVerifiedCriticalRequirements;
    }

    public void setNumberOfVerifiedCriticalRequirements(Long numberOfVerifiedCriticalRequirements) {
        this.numberOfVerifiedCriticalRequirements = numberOfVerifiedCriticalRequirements;
    }

    public Long getNumberOfNontestedMajorRequirements() {
        return this.numberOfNontestedMajorRequirements;
    }

    public void setNumberOfNontestedMajorRequirements(Long numberOfNontestedMajorRequirements) {
        this.numberOfNontestedMajorRequirements = numberOfNontestedMajorRequirements;
    }

    public Long getNumberOfTestedMajorRequirements() {
        return this.numberOfTestedMajorRequirements;
    }

    public void setNumberOfTestedMajorRequirements(Long numberOfTestedMajorRequirements) {
        this.numberOfTestedMajorRequirements = numberOfTestedMajorRequirements;
    }

    public Long getTotalNumberOfMajorRequirements() {
        return this.totalNumberOfMajorRequirements;
    }

    public void setTotalNumberOfMajorRequirements(Long totalNumberOfMajorRequirements) {
        this.totalNumberOfMajorRequirements = totalNumberOfMajorRequirements;
    }

    public Long getNumberOfVerifiedMajorRequirements() {
        return this.numberOfVerifiedMajorRequirements;
    }

    public void setNumberOfVerifiedMajorRequirements(Long numberOfVerifiedMajorRequirements) {
        this.numberOfVerifiedMajorRequirements = numberOfVerifiedMajorRequirements;
    }

    public Long getNumberOfNontestedMinorRequirements() {
        return this.numberOfNontestedMinorRequirements;
    }

    public void setNumberOfNontestedMinorRequirements(Long numberOfNontestedMinorRequirements) {
        this.numberOfNontestedMinorRequirements = numberOfNontestedMinorRequirements;
    }

    public Long getNumberOfTestedMinorRequirements() {
        return this.numberOfTestedMinorRequirements;
    }

    public void setNumberOfTestedMinorRequirements(Long numberOfTestedMinorRequirements) {
        this.numberOfTestedMinorRequirements = numberOfTestedMinorRequirements;
    }

    public Long getTotalNumberOfMinorRequirements() {
        return this.totalNumberOfMinorRequirements;
    }

    public void setTotalNumberOfMinorRequirements(Long totalNumberOfMinorRequirements) {
        this.totalNumberOfMinorRequirements = totalNumberOfMinorRequirements;
    }

    public Long getNumberOfVerifiedMinorRequirements() {
        return this.numberOfVerifiedMinorRequirements;
    }

    public void setNumberOfVerifiedMinorRequirements(Long numberOfVerifiedMinorRequirements) {
        this.numberOfVerifiedMinorRequirements = numberOfVerifiedMinorRequirements;
    }

    public Long getNumberOfNontestedUndefinedRequirements() {
        return this.numberOfNontestedUndefinedRequirements;
    }

    public void setNumberOfNontestedUndefinedRequirements(Long numberOfNontestedUndefinedRequirements) {
        this.numberOfNontestedUndefinedRequirements = numberOfNontestedUndefinedRequirements;
    }

    public Long getNumberOfTestedUndefinedRequirements() {
        return this.numberOfTestedUndefinedRequirements;
    }

    public void setNumberOfTestedUndefinedRequirements(Long numberOfTestedUndefinedRequirements) {
        this.numberOfTestedUndefinedRequirements = numberOfTestedUndefinedRequirements;
    }

    public Long getTotalNumberOfUndefinedRequirements() {
        return this.totalNumberOfUndefinedRequirements;
    }

    public void setTotalNumberOfUndefinedRequirements(Long totalNumberOfUndefinedRequirements) {
        this.totalNumberOfUndefinedRequirements = totalNumberOfUndefinedRequirements;
    }

    public Long getNumberOfVerifiedUndefinedRequirements() {
        return this.numberOfVerifiedUndefinedRequirements;
    }

    public void setNumberOfVerifiedUndefinedRequirements(Long numberOfVerifiedUndefinedRequirements) {
        this.numberOfVerifiedUndefinedRequirements = numberOfVerifiedUndefinedRequirements;
    }

    public Long getNumberOfNontestedRequirements() {
        return this.numberOfNontestedRequirements;
    }

    public void setNumberOfNontestedRequirements(Long numberOfNontestedRequirements) {
        this.numberOfNontestedRequirements = numberOfNontestedRequirements;
    }

    public Long getNumberOfTestedRequirements() {
        return this.numberOfTestedRequirements;
    }

    public void setNumberOfTestedRequirements(Long numberOfTestedRequirements) {
        this.numberOfTestedRequirements = numberOfTestedRequirements;
    }

    public Long getTotalNumberOfRequirements() {
        return this.totalNumberOfRequirements;
    }

    public void setTotalNumberOfRequirements(Long totalNumberOfRequirements) {
        this.totalNumberOfRequirements = totalNumberOfRequirements;
    }

    public Long getPercentageOfProgress() {
        return this.percentageOfProgress.longValue();
    }

    public void setPercentageOfProgress(Double percentageOfProgress) {
        this.percentageOfProgress = percentageOfProgress;
    }

    public Long getTotalNumberOfVerifiedRequirements() {
        return this.totalNumberOfVerifiedRequirements;
    }

    public void setTotalNumberOfVerifiedRequirements(Long totalNumberOfVerifiedRequirements) {
        this.totalNumberOfVerifiedRequirements = totalNumberOfVerifiedRequirements;
    }
}

