/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.helpers;

import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.redminereq.client.RedmineClient;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.plugin.redminereq.helpers.TechnicalDataDictionary;
import org.squashtest.tm.plugin.redminereq.service.ValueMappings;

@Component(value="squash.tm.plugin.redminereq.squashHelper")
@Scope(value="prototype")
public class SquashHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashHelper.class);
    private static final String VERSION = "version";
    private static final String HTML_BREAK = "</br>";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    @Inject
    private TechnicalDataDictionary dictionary;

    public void initForProject(Project p, ValueMappings valueMappings) {
        this.dictionary.initForProject(p, valueMappings);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.dictionary.toString());
        }
    }

    public String getCustomfieldValue(String squashCuf, String value, List<String> values, CustomField customField, RedmineClient client, com.taskadapter.redmineapi.bean.CustomField redmineCuf, BugTracker server, FilterBinding filter, List<ExtendedCustomField> allRedmineCufs) {
        InputType type = this.dictionary.lookupCufType(squashCuf);
        String defaultValue = customField.getDefaultValue();
        if (values.isEmpty() && value != null) {
            values.add(value);
        }
        return switch (type) {
            case InputType.CHECKBOX -> this.getCustomFieldValueForCheckBox(values, defaultValue);
            case InputType.DATE_PICKER -> this.getCustomFieldValueForDatePicker(values, customField);
            case InputType.DROPDOWN_LIST -> this.getCustomFieldValueForDropdownList(customField, values, defaultValue);
            case InputType.PLAIN_TEXT -> this.getCustomFieldValueForPlainText(values, defaultValue, redmineCuf, client, filter, allRedmineCufs);
            case InputType.RICH_TEXT -> this.getCustomFieldValueForRichtext(values, defaultValue, redmineCuf, client, filter, server, allRedmineCufs);
            case InputType.TAG -> this.getCustomFieldValueForTag(values, defaultValue, redmineCuf, client, filter, allRedmineCufs);
            case InputType.NUMERIC -> this.getCustomFieldValueForNumeric(value, defaultValue);
            default -> throw new IllegalArgumentException("custom field of type '" + type.toString() + "' are not implemented here");
        };
    }

    private String getCustomFieldValueForCheckBox(List<String> values, String defaultValue) {
        String result = this.asBoolean(values.get(0));
        if (result == null || result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    private String getCustomFieldValueForDatePicker(List<String> values, CustomField customField) {
        Date date;
        String result;
        block4: {
            result = values.get(0);
            date = null;
            if (result != null && !result.isEmpty()) {
                try {
                    date = this.formatter.parse(result);
                }
                catch (ParseException e) {
                    if (!LOGGER.isErrorEnabled()) break block4;
                    LOGGER.error("could not parse : " + result + " into Date format", (Throwable)e);
                }
            }
        }
        if (date == null || result.isEmpty()) {
            return customField.getDefaultValueAsDate() != null ? this.formatter.format(customField.getDefaultValueAsDate()) : null;
        }
        return result;
    }

    private String getCustomFieldValueForDropdownList(CustomField cuf, List<String> values, String defaultValue) {
        String result = values.get(0);
        if (this.dictionary.lookupItemCode(cuf.getCode(), result) == null || result == null || result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    private String getCustomFieldValueForPlainText(List<String> values, String defaultValue, com.taskadapter.redmineapi.bean.CustomField redmineCuf, RedmineClient client, FilterBinding filter, List<ExtendedCustomField> allRedmineCufs) {
        String redmineType = client.getRedmineCufType(redmineCuf.getId(), allRedmineCufs);
        String result = "";
        if ("user".equals(redmineType) && !values.get(0).isEmpty()) {
            for (String val : values) {
                Integer nb = Integer.parseInt(val);
                User user = client.getUserById(nb);
                if (user == null || user.getFirstName() == null || user.getLastName() == null) continue;
                result = String.valueOf(result) + user.getFirstName() + " " + user.getLastName() + ";";
            }
            result = result.replaceAll(";$", "");
        } else if (VERSION.equals(redmineType) && !values.get(0).isEmpty()) {
            List<Version> versions = client.getVersionsByProjectId(client.getProjectByProjectKey(filter.getKey()).getId());
            for (Version version : versions) {
                for (String valueStr : values) {
                    if (!version.getId().equals(Integer.parseInt(valueStr))) continue;
                    result = String.valueOf(result) + version.getName() + ";";
                }
            }
            result = result.replaceAll(";$", "");
        } else {
            for (String val : values) {
                result = String.valueOf(result) + val + ";";
            }
            result = result.replaceAll(";$", "");
        }
        if (result == null || result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    private String getCustomFieldValueForNumeric(String value, String defaultValue) {
        if ((value == null || value.isEmpty()) && !defaultValue.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private String getCustomFieldValueForRichtext(List<String> values, String defaultValue, com.taskadapter.redmineapi.bean.CustomField redmineCuf, RedmineClient client, FilterBinding filter, BugTracker server, List<ExtendedCustomField> allRedmineCufs) {
        String redmineType = client.getRedmineCufType(redmineCuf.getId(), allRedmineCufs);
        String result = "";
        if ("user".equals(redmineType) && !values.get(0).isEmpty()) {
            String url = String.valueOf(StringUtils.appendIfMissing((String)server.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0])) + "users/";
            for (String val : values) {
                Integer nb = Integer.parseInt(val);
                User user = client.getUserById(nb);
                if (user == null || user.getFirstName() == null || user.getLastName() == null) continue;
                result = String.valueOf(result) + user.getFirstName() + " " + user.getLastName() + " (<a href=" + url + val + " target='user'>" + url + val + "</a>)" + HTML_BREAK;
            }
            result = result.replaceAll("\n", HTML_BREAK);
        } else if ("attachment".equals(redmineType) && !values.get(0).isEmpty()) {
            String url = String.valueOf(StringUtils.appendIfMissing((String)server.getUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0])) + "attachments/" + values.get(0);
            result = "fichier : <a href=" + url + " target='fichier'>" + url + "</a>";
        } else if ("link".equals(redmineType) && !values.get(0).isEmpty()) {
            result = "lien : <a href=" + values.get(0) + " target='lien'>" + values.get(0) + "</a>";
        } else if (VERSION.equals(redmineType) && !values.get(0).isEmpty()) {
            List<Version> versions = client.getVersionsByProjectId(client.getProjectByProjectKey(filter.getKey()).getId());
            for (Version version : versions) {
                for (String valueStr : values) {
                    if (!version.getId().equals(Integer.parseInt(valueStr))) continue;
                    result = String.valueOf(result) + version.getName() + HTML_BREAK;
                }
            }
            result = result.replaceAll("\n", HTML_BREAK);
        } else {
            for (String val : values) {
                result = String.valueOf(result) + val + HTML_BREAK;
            }
            result = result.replaceAll("\n", HTML_BREAK);
        }
        if (result == null || result.isEmpty() || HTML_BREAK.equals(result)) {
            return defaultValue;
        }
        return result;
    }

    private String getCustomFieldValueForTag(List<String> values, String defaultValue, com.taskadapter.redmineapi.bean.CustomField redmineCuf, RedmineClient client, FilterBinding filter, List<ExtendedCustomField> allRedmineCufs) {
        String redmineType = client.getRedmineCufType(redmineCuf.getId(), allRedmineCufs);
        String result = "";
        if ("user".equals(redmineType) && !values.get(0).isEmpty()) {
            for (String val : values) {
                Integer nb = Integer.parseInt(val);
                User user = client.getUserById(nb);
                if (user == null || user.getFirstName() == null || user.getLastName() == null) continue;
                result = String.valueOf(result) + user.getFirstName() + " " + user.getLastName() + "|";
            }
            result = result.replaceAll("|$", "");
        } else if (VERSION.equals(redmineType) && !values.get(0).isEmpty()) {
            List<Version> versions = client.getVersionsByProjectId(client.getProjectByProjectKey(filter.getKey()).getId());
            for (Version version : versions) {
                for (String valueStr : values) {
                    if (!version.getId().equals(Integer.parseInt(valueStr))) continue;
                    result = String.valueOf(result) + version.getName() + "|";
                }
            }
            result = result.replaceAll("|$", "");
        } else {
            for (String val : values) {
                result = String.valueOf(result) + val + "|";
            }
            result = result.replaceAll("|$", "");
        }
        if (result == null || result.isEmpty() || "|".equals(result)) {
            return defaultValue;
        }
        return result;
    }

    private String asBoolean(String val) {
        String value = this.dictionary.lookupBoolean(val);
        if (value != null) {
            return value;
        }
        return null;
    }
}

