/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.redminereq.client;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineManager;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.TimeEntry;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3ClientImpl;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.Redmine3ExtendedManager;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;
import org.squashtest.tm.plugin.redminereq.domain.Configuration;
import org.squashtest.tm.plugin.redminereq.domain.FilterBinding;
import org.squashtest.tm.plugin.redminereq.exceptions.ConfigurationException;
import org.squashtest.tm.plugin.redminereq.service.EffectiveConfiguration;
import org.squashtest.tm.plugin.redminereq.service.ValueMappings;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import org.yaml.snakeyaml.Yaml;

@Component(value="squash.tm.plugin.redminereq.redmineClient")
@Scope(value="prototype")
public class RedmineClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedmineClient.class);
    private static final String FROM_REDMINE_API = " from Redmine API";
    @Inject
    private InternationalizationHelper langHelper;
    @Inject
    private BaseCommunicatorFactory baseCommunicatorFactory;
    private Redmine3ExtendedManager client;

    public void initialize(BugTracker server, Credentials credentials) {
        URI uri;
        try {
            uri = new URL(server.getUrl()).toURI();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            String msg = this.langHelper.getMessage("henix.redminereq.validation.invalidurl", new Object[]{server.getUrl()}, "wrong url", LocaleContextHolder.getLocale());
            LOGGER.error(msg, (Throwable)exception);
            throw new ConfigurationException(msg);
        }
        String urii = uri.toString();
        AuthenticationProtocol protocol = credentials.getImplementedProtocol();
        if (AuthenticationProtocol.BASIC_AUTH.equals((Object)protocol)) {
            this.initializeBasicAuthClient(credentials, server, urii);
        } else if (AuthenticationProtocol.TOKEN_AUTH.equals((Object)protocol)) {
            this.initializeTokenAuthClient(credentials, server, urii);
        } else {
            throw new UnsupportedAuthenticationModeException(protocol.name());
        }
    }

    private void initializeBasicAuthClient(Credentials credentials, BugTracker server, String urii) {
        BasicAuthenticationCredentials bac = (BasicAuthenticationCredentials)credentials;
        new Redmine3ClientImpl().init(server, (Credentials)bac, this.baseCommunicatorFactory);
        this.client = new Redmine3ExtendedManager(urii, bac.getUsername(), new String(bac.getPassword()), this.baseCommunicatorFactory);
    }

    private void initializeTokenAuthClient(Credentials credentials, BugTracker server, String urii) {
        TokenAuthCredentials tac = (TokenAuthCredentials)credentials;
        new Redmine3ClientImpl().init(server, (Credentials)tac, this.baseCommunicatorFactory);
        this.client = new Redmine3ExtendedManager(urii, tac.getToken(), this.baseCommunicatorFactory);
    }

    public void close() {
        this.client.shutdown();
    }

    public Issue getIssueById(Integer id) {
        Issue issue;
        block2: {
            issue = null;
            try {
                issue = this.client.getIssueById(id, new RedmineManager.INCLUDE[]{RedmineManager.INCLUDE.relations});
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not find a Redmine Issue with this following id : " + id + FROM_REDMINE_API, (Throwable)e);
            }
        }
        return issue;
    }

    public List<Version> getVersionsByProjectId(int projectId) {
        ArrayList<Version> versions;
        block2: {
            versions = new ArrayList();
            try {
                versions = this.client.getVersions(projectId);
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not find the list of versions with the following Redmine project id : " + projectId + FROM_REDMINE_API, (Throwable)e);
            }
        }
        return versions;
    }

    public List<String> getClosedStatus(Configuration conf) {
        ArrayList<String> closedStatus = new ArrayList<String>();
        ValueMappings valueMappings = this.getValueMappings(conf);
        if (valueMappings.size() != 0 && valueMappings.get("status") != null) {
            Map statutes = (Map)valueMappings.get("status");
            for (Map.Entry entry : statutes.entrySet()) {
                if (!"obsolete".equals(entry.getValue())) continue;
                closedStatus.add((String)entry.getKey());
            }
        }
        return closedStatus;
    }

    public Project getProjectByProjectKey(String projectKey) {
        Project p;
        block2: {
            p = null;
            try {
                p = this.client.getProjectByKey(projectKey);
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not find the Redmine project with this following projectKey : " + projectKey + FROM_REDMINE_API, (Throwable)e);
            }
        }
        return p;
    }

    public List<TimeEntry> getTimeEntriesForIssue(Integer id) {
        ArrayList<TimeEntry> entries;
        block2: {
            entries = new ArrayList();
            try {
                entries = this.client.getTimeEntriesForIssue(id);
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not find the list of Time entries with this following Redmine Issue id : " + id + FROM_REDMINE_API, (Throwable)e);
            }
        }
        return entries;
    }

    public List<ExtendedCustomField> getAllRedmineCufs() {
        ArrayList<ExtendedCustomField> allRedmineCufs;
        block2: {
            allRedmineCufs = new ArrayList();
            try {
                allRedmineCufs = this.client.getCustomField();
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not find the list of Redmine custom fields from Redmine API", (Throwable)e);
            }
        }
        return allRedmineCufs;
    }

    public User getUserById(int id) {
        User user;
        block2: {
            user = null;
            try {
                user = this.client.getUserById(Integer.valueOf(id));
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block2;
                LOGGER.error("could not find the Redmine user with this following id : " + id + FROM_REDMINE_API, (Throwable)e);
            }
        }
        return user;
    }

    public String getRedmineCufType(int cufId, List<ExtendedCustomField> allRedmineCufs) {
        String type = "";
        int k = 0;
        while (k < allRedmineCufs.size() && allRedmineCufs.get(k).getId() != cufId) {
            ++k;
        }
        if (k < allRedmineCufs.size()) {
            type = allRedmineCufs.get(k).getFieldFormat();
        }
        return type;
    }

    public List<Issue> getIssuesForFilter(FilterBinding filter) {
        ArrayList<Issue> issues;
        block3: {
            issues = new ArrayList<Issue>();
            try {
                if (filter.getFilter() != null && !filter.getFilter().isEmpty()) {
                    issues.addAll(this.client.getIssues(filter.getKey(), Integer.valueOf(Integer.parseInt(filter.getFilter())), new RedmineManager.INCLUDE[]{RedmineManager.INCLUDE.relations}));
                }
            }
            catch (RedmineException e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("could not find the list of Redmine issues with this following filter id : " + filter.getFilter() + FROM_REDMINE_API, (Throwable)e);
            }
        }
        return issues;
    }

    public ValueMappings getValueMappings(Configuration conf) {
        Yaml yaml = new Yaml();
        Map parsed = new HashMap();
        try {
            parsed = (Map)yaml.load(conf.getYamlFieldvalueMapping());
        }
        catch (ClassCastException ex) {
            LOGGER.error("YAML configuration error. Could not cast into Map", (Throwable)ex);
        }
        if (parsed == null) {
            parsed = new HashMap();
        }
        return new ValueMappings(parsed);
    }

    public EffectiveConfiguration createEffectiveConfiguration(Configuration userConf) {
        EffectiveConfiguration eff = new EffectiveConfiguration();
        eff.setServerId(userConf.getServerId());
        eff.setFilterBindings(userConf.getFilterBindings());
        return eff;
    }
}

