/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.campaignassessment.licensevalidator;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.squashtest.tm.plugin.report.campaignassessment.licensevalidator.com.license4j.License;
import org.squashtest.tm.plugin.report.campaignassessment.licensevalidator.com.license4j.exceptions.LicenseSecurityException;
import org.squashtest.tm.plugin.report.campaignassessment.licensevalidator.service.ExternalPluginValidationService;

public class ExternalPluginLicenseValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalPluginLicenseValidator.class);
    private static final String LICENSE_LOCATION = "/license/squash-tm.lic";
    private final ExternalPluginValidationService externalPluginValidationService;
    private String pluginToCheck;
    @Value(value="${squash.license.root-path}")
    private String rootPath;
    private License licenseToCheck;

    @Inject
    public ExternalPluginLicenseValidator(ExternalPluginValidationService service) {
        this.externalPluginValidationService = service;
    }

    public void validate(String plugin) {
        this.pluginToCheck = plugin;
        if (this.licenseToCheck == null) {
            this.retrieveLicense();
        }
        this.doLicenseValidation();
    }

    public void validateForUltimate() {
        if (this.licenseToCheck == null) {
            this.retrieveLicense();
        }
        this.externalPluginValidationService.checkLicenseTypeIsUltimate(this.licenseToCheck);
    }

    private void doLicenseValidation() {
        if (this.licenseToCheck != null) {
            try {
                this.externalPluginValidationService.validateLicenseForPlugin(this.licenseToCheck, this.pluginToCheck);
            }
            catch (LicenseSecurityException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.externalPluginValidationService.shutDownApp();
            }
        } else {
            LOGGER.warn("You do not have any license on your instance. Shut down initialized.");
            this.externalPluginValidationService.shutDownApp();
        }
    }

    private void retrieveLicense() {
        String licenseFromFile = this.externalPluginValidationService.readLicenseFile(String.valueOf(this.rootPath) + LICENSE_LOCATION);
        if (licenseFromFile != null) {
            this.licenseToCheck = this.externalPluginValidationService.validateLicense(licenseFromFile);
        } else {
            LOGGER.warn("An error occurred while retrieving the license file. Shut down initialized.");
            this.externalPluginValidationService.shutDownApp();
        }
    }
}

