-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-7.1.0.xml
-- Ran at: 08/01/2026 11:50
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.19.0
-- *********************************************************************

-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-d19jc3z5 (100.64.14.156)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0::mbrugniere
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '7.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0', 'mbrugniere', '../tm/tm.changelog-7.1.0.xml', NOW(), 1, '8:ea0d172d40d095bc7053c0259b1110ee', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '7869450887');

-- Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-create-api-token-table::mbrugniere
-- Create table API_TOKEN
CREATE TABLE API_TOKEN (TOKEN_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, USER_ID BIGINT NOT NULL, UUID VARCHAR(36) NOT NULL, NAME VARCHAR(255) NOT NULL, PERMISSIONS VARCHAR(50) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, EXPIRY_DATE VARCHAR(10) NOT NULL, LAST_USAGE TIMESTAMP WITHOUT TIME ZONE, CONSTRAINT pk_api_token PRIMARY KEY (TOKEN_ID), UNIQUE (UUID));

COMMENT ON COLUMN API_TOKEN.TOKEN_ID IS 'primary key for API_TOKEN';

COMMENT ON COLUMN API_TOKEN.USER_ID IS 'foreign key to CORE_USER.PARTY_ID';

COMMENT ON COLUMN API_TOKEN.UUID IS 'Unique UUID to identify a token in database';

COMMENT ON COLUMN API_TOKEN.PERMISSIONS IS 'READ for GET and READ_WRITE for all methods';

CREATE INDEX idx_fk_api_token_user_id ON API_TOKEN(USER_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-create-api-token-table', 'mbrugniere', '../tm/tm.changelog-7.1.0.xml', NOW(), 2, '8:a963b876b65dedeee2b60d12c9604d43', 'createTable tableName=API_TOKEN; createIndex indexName=idx_fk_api_token_user_id, tableName=API_TOKEN', 'Create table API_TOKEN', 'EXECUTED', NULL, NULL, '4.19.0', '7869450887');

-- Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-fix-description-default-value-in-third-party-server::jprioux
ALTER TABLE THIRD_PARTY_SERVER ALTER COLUMN  DESCRIPTION SET DEFAULT '';

UPDATE THIRD_PARTY_SERVER SET DESCRIPTION = '' WHERE DESCRIPTION IS NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-fix-description-default-value-in-third-party-server', 'jprioux', '../tm/tm.changelog-7.1.0.xml', NOW(), 3, '8:9f48efe5cf3a47ad251f48cd46084661', 'addDefaultValue columnName=DESCRIPTION, tableName=THIRD_PARTY_SERVER; update tableName=THIRD_PARTY_SERVER', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450887');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

