-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-7.0.0.xml
-- Ran at: 08/01/2026 11:50
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.19.0
-- *********************************************************************

-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-d19jc3z5 (100.64.14.156)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0::mbrugniere
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '7.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 1, '8:4d84039428ec1c6e75236450ae5a2b45', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-45-clean-database-of-nulls-in-action-steps::mbrugniere
-- Clean database of null values in test steps and execution steps
UPDATE ACTION_TEST_STEP SET ACTION = '' WHERE ACTION IS NULL;

UPDATE ACTION_TEST_STEP SET EXPECTED_RESULT = '' WHERE EXPECTED_RESULT IS NULL;

UPDATE EXECUTION_STEP SET ACTION = '' WHERE ACTION IS NULL;

UPDATE EXECUTION_STEP SET EXPECTED_RESULT = '' WHERE EXPECTED_RESULT IS NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-45-clean-database-of-nulls-in-action-steps', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 2, '8:15d6f2ec592778bc044a2ec3442f2b70', 'update tableName=ACTION_TEST_STEP; update tableName=ACTION_TEST_STEP; update tableName=EXECUTION_STEP; update tableName=EXECUTION_STEP', 'Clean database of null values in test steps and execution steps', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-895-action-and-expected_result_should_not_be_nullable::mbrugniere
-- Add not null constraint on columns action and expected_result
ALTER TABLE ACTION_TEST_STEP ALTER COLUMN  ACTION SET NOT NULL;

ALTER TABLE ACTION_TEST_STEP ALTER COLUMN  ACTION SET DEFAULT '';

ALTER TABLE ACTION_TEST_STEP ALTER COLUMN  EXPECTED_RESULT SET NOT NULL;

ALTER TABLE ACTION_TEST_STEP ALTER COLUMN  EXPECTED_RESULT SET DEFAULT '';

ALTER TABLE EXECUTION_STEP ALTER COLUMN  ACTION SET NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER COLUMN  ACTION SET DEFAULT '';

ALTER TABLE EXECUTION_STEP ALTER COLUMN  EXPECTED_RESULT SET NOT NULL;

ALTER TABLE EXECUTION_STEP ALTER COLUMN  EXPECTED_RESULT SET DEFAULT '';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-895-action-and-expected_result_should_not_be_nullable', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 3, '8:c73ee0e5cd76bc2fda03748af103f49f', 'addNotNullConstraint columnName=ACTION, tableName=ACTION_TEST_STEP; addDefaultValue columnName=ACTION, tableName=ACTION_TEST_STEP; addNotNullConstraint columnName=EXPECTED_RESULT, tableName=ACTION_TEST_STEP; addDefaultValue columnName=EXPECTED_RES...', 'Add not null constraint on columns action and expected_result', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-876-update-cufs-in-column-configuration::jma
-- Delete active_column_id if it does not match any cuf code. Replace the cuf's code with the cuf's id.
DELETE
      FROM GRID_COLUMN_DISPLAY_CONFIGURATION
      WHERE active_column_id LIKE 'cuf|%'
        AND active_column_id NOT IN (SELECT CONCAT('cuf|', code) FROM CUSTOM_FIELD);

UPDATE GRID_COLUMN_DISPLAY_CONFIGURATION AS gcdc
      SET active_column_id = (SELECT CONCAT('cuf|', cf.cf_id)
                              FROM CUSTOM_FIELD AS cf
                              WHERE SUBSTRING(gcdc.active_column_id, LENGTH('cuf|') + 1) = cf.code)
      WHERE gcdc.active_column_id LIKE 'cuf|%';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-876-update-cufs-in-column-configuration', 'jma', '../tm/tm.changelog-7.0.0.xml', NOW(), 4, '8:cde1f300d157fb293173c7e75fdf4cfa', 'sql', 'Delete active_column_id if it does not match any cuf code. Replace the cuf''s code with the cuf''s id.', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-table::jprioux
-- Create the sprint table
CREATE TABLE SPRINT (CLN_ID BIGINT NOT NULL, STATUS VARCHAR(50) DEFAULT 'UPCOMING' NOT NULL, REMOTE_SYNCHRONISATION_ID BIGINT, REMOTE_SPRINT_ID BIGINT, REMOTE_NAME VARCHAR(255), REMOTE_STATE VARCHAR(50), START_DATE TIMESTAMP WITHOUT TIME ZONE, END_DATE TIMESTAMP WITHOUT TIME ZONE, REFERENCE VARCHAR(255), CONSTRAINT pk_sprint PRIMARY KEY (CLN_ID), CONSTRAINT fk_sprint_campaign_library_node FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID), CONSTRAINT fk_sprint_remote_synchronisation FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION(REMOTE_SYNCHRONISATION_ID));

COMMENT ON COLUMN SPRINT.CLN_ID IS 'Shared key with CAMPAIGN_LIBRARY_NODE table';

CREATE INDEX idx_fk_sprint_remote_synchronisation ON SPRINT(REMOTE_SYNCHRONISATION_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-table', 'jprioux', '../tm/tm.changelog-7.0.0.xml', NOW(), 5, '8:18267a63e61cdab26f9855b65b90bd0d', 'createTable tableName=SPRINT; createIndex indexName=idx_fk_sprint_remote_synchronisation, tableName=SPRINT', 'Create the sprint table', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-req-version-table::rfortoso
CREATE TABLE SPRINT_REQ_VERSION (SPRINT_REQ_VERSION_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, REQ_VERSION_ID BIGINT, SPRINT_ID BIGINT NOT NULL, REFERENCE VARCHAR(50), NAME VARCHAR(255), STATUS VARCHAR(50), CRITICALITY VARCHAR(50), CATEGORY VARCHAR(50), DESCRIPTION TEXT, MODE VARCHAR(15) DEFAULT 'NATIVE', CONSTRAINT pk_sprint_req_version PRIMARY KEY (SPRINT_REQ_VERSION_ID), CONSTRAINT fk_sprint_req_version_sprint_id FOREIGN KEY (SPRINT_ID) REFERENCES SPRINT(CLN_ID), CONSTRAINT fk_sprint_req_version_req_version_id FOREIGN KEY (REQ_VERSION_ID) REFERENCES REQUIREMENT_VERSION(RES_ID));

COMMENT ON COLUMN SPRINT_REQ_VERSION.SPRINT_REQ_VERSION_ID IS 'primary key for SPRINT_REQ_VERSION';

COMMENT ON COLUMN SPRINT_REQ_VERSION.MODE IS 'Says whether a sprint req version is NATIVE or SYNCHRONIZED';

CREATE INDEX idx_fk_sprint_req_version_req_version_id ON SPRINT_REQ_VERSION(REQ_VERSION_ID);

CREATE INDEX idx_fk_sprint_req_version_sprint_id ON SPRINT_REQ_VERSION(SPRINT_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-req-version-table', 'rfortoso', '../tm/tm.changelog-7.0.0.xml', NOW(), 6, '8:d70d42ae489fc3fd45cf52013e4bfefb', 'createTable tableName=SPRINT_REQ_VERSION; createIndex indexName=idx_fk_sprint_req_version_req_version_id, tableName=SPRINT_REQ_VERSION; createIndex indexName=idx_fk_sprint_req_version_sprint_id, tableName=SPRINT_REQ_VERSION', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-requirement-sync-extender-table::dclaerhout
CREATE TABLE SPRINT_REQUIREMENT_SYNC_EXTENDER (SPRINT_REQ_SYNC_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, SPRINT_REQ_VERSION_ID BIGINT NOT NULL, REMOTE_REQ_ID VARCHAR(50), REMOTE_REQ_URL VARCHAR(300), REMOTE_PROJECT_ID VARCHAR(100), REMOTE_LAST_UPDATED TIMESTAMP WITHOUT TIME ZONE, REMOTE_SYNCHRONISATION_ID BIGINT, REMOTE_PERIMETER_STATUS VARCHAR(30) DEFAULT 'UNKNOWN' NOT NULL, CONSTRAINT pk_sprint_req_sync_extender PRIMARY KEY (SPRINT_REQ_SYNC_ID), CONSTRAINT fk_sprint_req_sync_ext_remote_sync_id FOREIGN KEY (REMOTE_SYNCHRONISATION_ID) REFERENCES REMOTE_SYNCHRONISATION(REMOTE_SYNCHRONISATION_ID), CONSTRAINT fk_sprint_req_sync_ext_sprint_req_version_id FOREIGN KEY (SPRINT_REQ_VERSION_ID) REFERENCES SPRINT_REQ_VERSION(SPRINT_REQ_VERSION_ID));

COMMENT ON COLUMN SPRINT_REQUIREMENT_SYNC_EXTENDER.SPRINT_REQ_SYNC_ID IS 'primary key for SPRINT_REQUIREMENT_SYNC_EXTENDER';

CREATE INDEX idx_fk_sprint_req_sync_ext_sprint_req_version_id ON SPRINT_REQUIREMENT_SYNC_EXTENDER(SPRINT_REQ_VERSION_ID);

CREATE INDEX idx_fk_sprint_req_sync_ext_remote_sync_id ON SPRINT_REQUIREMENT_SYNC_EXTENDER(REMOTE_SYNCHRONISATION_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-requirement-sync-extender-table', 'dclaerhout', '../tm/tm.changelog-7.0.0.xml', NOW(), 7, '8:6c4950fc89283d5d5dd18c568bd1f7ec', 'createTable tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_fk_sprint_req_sync_ext_sprint_req_version_id, tableName=SPRINT_REQUIREMENT_SYNC_EXTENDER; createIndex indexName=idx_fk_sprint_req_sync_ext_remote_sync_id, tableName=...', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-automated-suite-workflows-table::bmsaddek
CREATE TABLE AUTOMATED_SUITE_WORKFLOWS (SUITE_ID VARCHAR(50) NOT NULL, WORKFLOW_ID VARCHAR(100) NOT NULL, PROJECT_ID BIGINT NOT NULL, CONSTRAINT fk_automated_suite_workflows_suite_id FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE(SUITE_ID), CONSTRAINT fk_automated_suite_workflows_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT(PROJECT_ID));

COMMENT ON COLUMN AUTOMATED_SUITE_WORKFLOWS.SUITE_ID IS 'foreign key to AUTOMATED_SUITE';

COMMENT ON COLUMN AUTOMATED_SUITE_WORKFLOWS.WORKFLOW_ID IS 'id of the workflow launched from the suite';

COMMENT ON COLUMN AUTOMATED_SUITE_WORKFLOWS.PROJECT_ID IS 'original project id';

CREATE INDEX idx_fk_automated_suite_workflows_project_id ON AUTOMATED_SUITE_WORKFLOWS(PROJECT_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-automated-suite-workflows-table', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 8, '8:8e126d5712051ba8b1493b708cf78cc7', 'createTable tableName=AUTOMATED_SUITE_WORKFLOWS; createIndex indexName=idx_fk_automated_suite_workflows_project_id, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-ai-server-table::jmarque
-- Create the ai server table
CREATE TABLE AI_SERVER (SERVER_ID BIGINT NOT NULL, PAYLOAD_TEMPLATE TEXT, JSON_PATH VARCHAR(255) DEFAULT null, CONSTRAINT "AI_SERVER_pkey" PRIMARY KEY (SERVER_ID));

COMMENT ON COLUMN AI_SERVER.SERVER_ID IS 'The id of the ai server, foreign key to third_party_server.';

COMMENT ON COLUMN AI_SERVER.PAYLOAD_TEMPLATE IS 'The body of the json sent';

COMMENT ON COLUMN AI_SERVER.JSON_PATH IS 'Specifies the JSON path used to locate the node containing the response in AI-generated test cases.';

ALTER TABLE AI_SERVER ADD CONSTRAINT fk_ai_server_third_party_server FOREIGN KEY (SERVER_ID) REFERENCES THIRD_PARTY_SERVER (SERVER_ID) ON DELETE CASCADE;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-ai-server-table', 'jmarque', '../tm/tm.changelog-7.0.0.xml', NOW(), 9, '8:76fde6bb17ff2d4b5b1579d3d154027b', 'createTable tableName=AI_SERVER; addForeignKeyConstraint baseTableName=AI_SERVER, constraintName=fk_ai_server_third_party_server, referencedTableName=THIRD_PARTY_SERVER', 'Create the ai server table', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-add-column-killswitch-url-in-test-automation-server::ngouriou
-- Add killswitch_url column in test automation server table
ALTER TABLE TEST_AUTOMATION_SERVER ADD KILLSWITCH_URL VARCHAR(255);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-add-column-killswitch-url-in-test-automation-server', 'ngouriou', '../tm/tm.changelog-7.0.0.xml', NOW(), 10, '8:6bbcbe34f1b840c9d8e25847201c9676', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add killswitch_url column in test automation server table', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-add-column-ai_server_id-in-project::mbrugniere
-- Add column ai_server_id in project table
ALTER TABLE PROJECT ADD AI_SERVER_ID BIGINT;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_ai_server FOREIGN KEY (AI_SERVER_ID) REFERENCES AI_SERVER (SERVER_ID);

COMMENT ON COLUMN PROJECT.AI_SERVER_ID IS 'the reference to the artificial intelligence server';

CREATE INDEX idx_fk_project_ai_server ON PROJECT(AI_SERVER_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-add-column-ai_server_id-in-project', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 11, '8:b3f8a0984f0ee0bfd3c730f22b0425a4', 'addColumn tableName=PROJECT; createIndex indexName=idx_fk_project_ai_server, tableName=PROJECT', 'Add column ai_server_id in project table', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-record-info-test-case-drafted-by-artificial-intelligence::mbrugniere
-- Add column drafted_by_ai in test_case table
ALTER TABLE TEST_CASE ADD DRAFTED_BY_AI BOOLEAN DEFAULT FALSE;

COMMENT ON COLUMN TEST_CASE.DRAFTED_BY_AI IS 'is the test case drafted by artificial intelligence';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-record-info-test-case-drafted-by-artificial-intelligence', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 12, '8:bcaf72c1d4f8da1ae849712f9efca60b', 'addColumn tableName=TEST_CASE', 'Add column drafted_by_ai in test_case table', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-filtering-on-drafted-by-ai-in-test-case-search-grid::mbrugniere
-- Add entry in QUERY_COLUMN_PROTOTYPE for filtering on TEST_CASE.drafted_by_ai
INSERT INTO QUERY_COLUMN_PROTOTYPE (COLUMN_TYPE, BUSINESS, LABEL, ENTITY_TYPE, ENTITY_ROLE, DATA_TYPE,
                                         ATTRIBUTE_NAME, SUBQUERY_ID)
      SELECT 'ATTRIBUTE', FALSE, 'TEST_CASE_DRAFTED_BY_AI', 'TEST_CASE', null, 'BOOLEAN', 'draftedByAi', null
      WHERE NOT EXISTS (
        SELECT 1
        FROM QUERY_COLUMN_PROTOTYPE
        WHERE LABEL = 'TEST_CASE_DRAFTED_BY_AI' AND ATTRIBUTE_NAME = 'draftedByAi'
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-filtering-on-drafted-by-ai-in-test-case-search-grid', 'mbrugniere', '../tm/tm.changelog-7.0.0.xml', NOW(), 13, '8:fa118be4a0a61d59568884451e47f8f0', 'sql', 'Add entry in QUERY_COLUMN_PROTOTYPE for filtering on TEST_CASE.drafted_by_ai', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-test_plan-tables::pckerneis
CREATE TABLE TEST_PLAN (TEST_PLAN_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, CL_ID BIGINT NOT NULL, CONSTRAINT "TEST_PLAN_pkey" PRIMARY KEY (TEST_PLAN_ID), CONSTRAINT fk_test_plan_campaign_library FOREIGN KEY (CL_ID) REFERENCES CAMPAIGN_LIBRARY(CL_ID));

COMMENT ON COLUMN TEST_PLAN.TEST_PLAN_ID IS 'primary key';

COMMENT ON COLUMN TEST_PLAN.CL_ID IS 'foreign key to parent CampaignLibrary';

CREATE INDEX idx_fk_test_plan_campaign_library ON TEST_PLAN(CL_ID);

CREATE TABLE TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, TEST_PLAN_ID BIGINT NOT NULL, ITEM_ORDER INTEGER NOT NULL, EXECUTION_STATUS VARCHAR(255) DEFAULT 'READY' NOT NULL, LAST_EXECUTED_BY VARCHAR(255) DEFAULT null, LAST_EXECUTED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null, TCLN_ID BIGINT, DATASET_ID BIGINT, LABEL VARCHAR(255) NOT NULL, ASSIGNEE_ID BIGINT, CREATED_BY VARCHAR(100) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, LAST_MODIFIED_BY VARCHAR(100) DEFAULT null, LAST_MODIFIED_ON TIMESTAMP WITHOUT TIME ZONE DEFAULT null, CONSTRAINT "TEST_PLAN_ITEM_pkey" PRIMARY KEY (TEST_PLAN_ITEM_ID), CONSTRAINT fk_test_plan_item_dataset FOREIGN KEY (DATASET_ID) REFERENCES DATASET(DATASET_ID), CONSTRAINT fk_test_plan_item_test_plan FOREIGN KEY (TEST_PLAN_ID) REFERENCES TEST_PLAN(TEST_PLAN_ID), CONSTRAINT fk_test_plan_item_user FOREIGN KEY (ASSIGNEE_ID) REFERENCES CORE_USER(PARTY_ID), CONSTRAINT fk_test_plan_item_test_case FOREIGN KEY (TCLN_ID) REFERENCES TEST_CASE(TCLN_ID));

COMMENT ON COLUMN TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID IS 'primary key';

COMMENT ON COLUMN TEST_PLAN_ITEM.TEST_PLAN_ID IS 'fk to the parent test plan';

CREATE INDEX idx_fk_test_plan_item_test_plan ON TEST_PLAN_ITEM(TEST_PLAN_ID);

CREATE INDEX idx_fk_test_plan_item_test_case ON TEST_PLAN_ITEM(TCLN_ID);

CREATE INDEX idx_fk_test_plan_item_dataset ON TEST_PLAN_ITEM(DATASET_ID);

CREATE INDEX idx_fk_test_plan_item_user ON TEST_PLAN_ITEM(ASSIGNEE_ID);

ALTER TABLE EXECUTION ADD TEST_PLAN_ITEM_ID BIGINT;

ALTER TABLE EXECUTION ADD CONSTRAINT fk_execution_test_plan_item FOREIGN KEY (TEST_PLAN_ITEM_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

ALTER TABLE EXECUTION ADD EXECUTION_ORDER INTEGER;

CREATE INDEX idx_fk_execution_test_plan_item ON EXECUTION(TEST_PLAN_ITEM_ID);

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW ADD TEST_PLAN_ITEM_ID BIGINT;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW ADD CONSTRAINT fk_exploratory_session_test_plan_item FOREIGN KEY (TEST_PLAN_ITEM_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

CREATE INDEX idx_fk_exploratory_session_test_plan_item ON EXPLORATORY_SESSION_OVERVIEW(TEST_PLAN_ITEM_ID);

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW ALTER COLUMN  ITEM_TEST_PLAN_ID DROP NOT NULL;

ALTER TABLE SPRINT_REQ_VERSION ADD TEST_PLAN_ID BIGINT NOT NULL;

ALTER TABLE SPRINT_REQ_VERSION ADD CONSTRAINT fk_sprint_req_version_test_plan FOREIGN KEY (TEST_PLAN_ID) REFERENCES TEST_PLAN (TEST_PLAN_ID);

CREATE INDEX idx_fk_sprint_req_version_test_plan ON SPRINT_REQ_VERSION(TEST_PLAN_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-test_plan-tables', 'pckerneis', '../tm/tm.changelog-7.0.0.xml', NOW(), 14, '8:c2fef64400785013d39a8bda01b48a35', 'createTable tableName=TEST_PLAN; createIndex indexName=idx_fk_test_plan_campaign_library, tableName=TEST_PLAN; createTable tableName=TEST_PLAN_ITEM; createIndex indexName=idx_fk_test_plan_item_test_plan, tableName=TEST_PLAN_ITEM; createIndex index...', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-tc-add-automation-req-fk::bmsaddek
ALTER TABLE TEST_CASE ADD AUTOMATION_REQUEST_ID BIGINT;

ALTER TABLE TEST_CASE ADD CONSTRAINT fk_test_case_automation_request_id FOREIGN KEY (AUTOMATION_REQUEST_ID) REFERENCES AUTOMATION_REQUEST (AUTOMATION_REQUEST_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-tc-add-automation-req-fk', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 15, '8:79b633d345dc36d5c68b438189b29dd4', 'addColumn tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-tc-import-ar-fk-postgres::bmsaddek
UPDATE TEST_CASE
      SET AUTOMATION_REQUEST_ID = old.AUTOMATION_REQUEST_ID
        FROM (SELECT ar.AUTOMATION_REQUEST_ID, ar.TEST_CASE_ID
              FROM AUTOMATION_REQUEST ar) AS old
      WHERE TEST_CASE.TCLN_ID = old.TEST_CASE_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-tc-import-ar-fk-postgres', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 16, '8:e73c39ec67fe649675eb761079a47487', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-tc-add-columns-indexes::bmsaddek
CREATE INDEX idx_test_case_automation_request_id ON TEST_CASE(AUTOMATION_REQUEST_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-tc-add-columns-indexes', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 17, '8:05a38a10abfc634c2a9ac197cd2efc10', 'createIndex indexName=idx_test_case_automation_request_id, tableName=TEST_CASE', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-automation-request-drop-column::bmsaddek
ALTER TABLE AUTOMATION_REQUEST DROP CONSTRAINT fk_automation_request_test_case;

ALTER TABLE AUTOMATION_REQUEST DROP COLUMN TEST_CASE_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-automation-request-drop-column', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 18, '8:64c56c847b133ec34241efc1e34234a8', 'dropForeignKeyConstraint baseTableName=AUTOMATION_REQUEST, constraintName=fk_automation_request_test_case; dropColumn columnName=TEST_CASE_ID, tableName=AUTOMATION_REQUEST', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-create-sprint-group-table::jprioux
-- Create the sprint group table
CREATE TABLE SPRINT_GROUP (CLN_ID BIGINT NOT NULL, CONSTRAINT pk_sprint_group PRIMARY KEY (CLN_ID), CONSTRAINT fk_sprint_group_campaign_library_node FOREIGN KEY (CLN_ID) REFERENCES CAMPAIGN_LIBRARY_NODE(CLN_ID));

COMMENT ON COLUMN SPRINT_GROUP.CLN_ID IS 'Shared key with CAMPAIGN_LIBRARY_NODE table';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-create-sprint-group-table', 'jprioux', '../tm/tm.changelog-7.0.0.xml', NOW(), 19, '8:fb4b09576cc2cdef18f619b0053c946e', 'createTable tableName=SPRINT_GROUP', 'Create the sprint group table', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-expand_cln_relationship_ancestor_fk::jprioux
-- Expand ANCESTOR_ID from cln_relationship to include campaign library node, not only folder
ALTER TABLE CLN_RELATIONSHIP DROP CONSTRAINT fk_cln_relationship_ancestor;

DROP INDEX dx_cln_relationship_ancestor;

ALTER TABLE CLN_RELATIONSHIP ADD CONSTRAINT fk_cln_relationship_ancestor FOREIGN KEY (ANCESTOR_ID) REFERENCES CAMPAIGN_LIBRARY_NODE (CLN_ID);

CREATE INDEX idx_fk_cln_relationship_ancestor ON CLN_RELATIONSHIP(ANCESTOR_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-expand_cln_relationship_ancestor_fk', 'jprioux', '../tm/tm.changelog-7.0.0.xml', NOW(), 20, '8:a3838d3d4e3a8e1fb286740c4e800049', 'dropForeignKeyConstraint baseTableName=CLN_RELATIONSHIP, constraintName=fk_cln_relationship_ancestor; dropIndex indexName=dx_cln_relationship_ancestor, tableName=CLN_RELATIONSHIP; addForeignKeyConstraint baseTableName=CLN_RELATIONSHIP, constraintN...', 'Expand ANCESTOR_ID from cln_relationship to include campaign library node, not only folder', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-replace-invalid-br-tags::pckerneis
-- Replace invalid br tags in test case description
UPDATE EXECUTION_STEP SET ACTION = REPLACE(ACTION, '</br>', '<br>');

UPDATE EXECUTION SET PREREQUISITE = REPLACE(PREREQUISITE, '</br>', '<br>');

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-replace-invalid-br-tags', 'pckerneis', '../tm/tm.changelog-7.0.0.xml', NOW(), 21, '8:aebb68aba075b09e4c850463b32407d7', 'sql', 'Replace invalid br tags in test case description', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-bugtracker-project-binding::bmsaddek
ALTER TABLE BUGTRACKER_PROJECT ADD PROJECT_ID BIGINT;

ALTER TABLE BUGTRACKER_PROJECT ADD CONSTRAINT fk_bugtracker_project_project_id FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID);

ALTER TABLE PROJECT ADD BUGTRACKER_ID BIGINT DEFAULT null;

ALTER TABLE PROJECT ADD CONSTRAINT fk_project_bugtracker_id FOREIGN KEY (BUGTRACKER_ID) REFERENCES BUGTRACKER (BUGTRACKER_ID);

CREATE INDEX idx_fk_bugtracker_project_project_id ON BUGTRACKER_PROJECT(PROJECT_ID);

CREATE INDEX idx_fk_project_bugtracker_id ON PROJECT(BUGTRACKER_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-binding', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 22, '8:18cfd43a240330ad96073c3a5ae96319', 'addColumn tableName=BUGTRACKER_PROJECT; addColumn tableName=PROJECT; createIndex indexName=idx_fk_bugtracker_project_project_id, tableName=BUGTRACKER_PROJECT; createIndex indexName=idx_fk_project_bugtracker_id, tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-bugtracker-project-import-fk-postgresql::bmsaddek
UPDATE BUGTRACKER_PROJECT
      SET
        PROJECT_ID = BUGTRACKER_BINDING.PROJECT_ID
        FROM BUGTRACKER_BINDING
      WHERE BUGTRACKER_PROJECT.BUGTRACKER_BINDING_ID = BUGTRACKER_BINDING.BUGTRACKER_BINDING_ID;

UPDATE PROJECT
      SET
        BUGTRACKER_ID = BUGTRACKER_BINDING.BUGTRACKER_ID
      FROM BUGTRACKER_BINDING
      WHERE PROJECT.PROJECT_ID = BUGTRACKER_BINDING.PROJECT_ID;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-import-fk-postgresql', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 23, '8:3cddfff904a21d5c4e515bd11a1e7225', 'sql', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-fix-mapping-bugtracker-project-drop-table::bmsaddek
ALTER TABLE BUGTRACKER_PROJECT DROP CONSTRAINT fk_bugtracker_project_bugtracker_binding;

ALTER TABLE BUGTRACKER_PROJECT DROP COLUMN BUGTRACKER_BINDING_ID;

DROP TABLE BUGTRACKER_BINDING;

ALTER TABLE BUGTRACKER_PROJECT ALTER COLUMN  PROJECT_ID SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-fix-mapping-bugtracker-project-drop-table', 'bmsaddek', '../tm/tm.changelog-7.0.0.xml', NOW(), 24, '8:54b76e597930c56c35c72c1a8f78384a', 'dropForeignKeyConstraint baseTableName=BUGTRACKER_PROJECT, constraintName=fk_bugtracker_project_bugtracker_binding; dropColumn columnName=BUGTRACKER_BINDING_ID, tableName=BUGTRACKER_PROJECT; dropTable tableName=BUGTRACKER_BINDING; addNotNullConstr...', '', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-1558-add-playwright-automated_test_technologies::xzhao-meinman
-- Add automated test technology Playwright
INSERT INTO AUTOMATED_TEST_TECHNOLOGY (NAME, ACTION_PROVIDER_KEY, PREMIUM)
      SELECT 'Playwright', 'playwright/execute@v1', false
      WHERE NOT EXISTS (
        SELECT 1
        FROM AUTOMATED_TEST_TECHNOLOGY
        WHERE NAME = 'Playwright'
      );

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-1558-add-playwright-automated_test_technologies', 'xzhao-meinman', '../tm/tm.changelog-7.0.0.xml', NOW(), 25, '8:e80a70004244bf60542d2d151dd65f72', 'sql', 'Add automated test technology Playwright', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Changeset ../tm/tm.changelog-7.0.0.xml::tm-7.0.0-squash-1647-add-auditables-and-description-to-third-party-server-postgresql::jpmarque
-- Add auditables and description to THIRD_PARTY_SERVER, copy data from TEST_AUTOMATION_SERVER, remove columns from TEST_AUTOMATION_SERVER
ALTER TABLE THIRD_PARTY_SERVER
        ADD COLUMN CREATED_BY VARCHAR(100),
        ADD COLUMN CREATED_ON TIMESTAMP,
        ADD COLUMN LAST_MODIFIED_BY VARCHAR(100) NULL,
        ADD COLUMN LAST_MODIFIED_ON TIMESTAMP  NULL,
        ADD COLUMN DESCRIPTION TEXT DEFAULT '';

UPDATE THIRD_PARTY_SERVER tps
      SET CREATED_BY = tas.CREATED_BY,
          CREATED_ON = tas.CREATED_ON,
          LAST_MODIFIED_BY = tas.LAST_MODIFIED_BY,
          DESCRIPTION = tas.DESCRIPTION
      FROM TEST_AUTOMATION_SERVER tas
      WHERE tas.SERVER_ID = tps.SERVER_ID;

UPDATE THIRD_PARTY_SERVER tps
        SET LAST_MODIFIED_ON = tas.LAST_MODIFIED_ON
        FROM TEST_AUTOMATION_SERVER tas
        WHERE tas.SERVER_ID = tps.SERVER_ID AND tas.LAST_MODIFIED_ON IS NOT NULL;

ALTER TABLE TEST_AUTOMATION_SERVER
        DROP COLUMN IF EXISTS CREATED_BY,
        DROP COLUMN IF EXISTS CREATED_ON,
        DROP COLUMN IF EXISTS LAST_MODIFIED_BY,
        DROP COLUMN IF EXISTS LAST_MODIFIED_ON,
        DROP COLUMN IF EXISTS DESCRIPTION;

UPDATE THIRD_PARTY_SERVER tps
      SET CREATED_BY = 'Upgrade Squash 7.0',
          CREATED_ON = NOW()
      WHERE tps.CREATED_BY is NULL;

ALTER TABLE THIRD_PARTY_SERVER ALTER COLUMN CREATED_BY SET NOT NULL;

ALTER TABLE THIRD_PARTY_SERVER ALTER COLUMN CREATED_ON SET NOT NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.0.0-squash-1647-add-auditables-and-description-to-third-party-server-postgresql', 'jpmarque', '../tm/tm.changelog-7.0.0.xml', NOW(), 26, '8:60030c4ffb1a01e51af92acaa977724e', 'sql', 'Add auditables and description to THIRD_PARTY_SERVER, copy data from TEST_AUTOMATION_SERVER, remove columns from TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, NULL, '4.19.0', '7869450816');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

