/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.service.impl;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.License;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.LicenseValidator;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.exceptions.LicenseSecurityException;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.com.license4j.util.FileUtils;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.dto.LicenseType;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.exception.SquashLicenseValidatorException;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.service.ExternalPluginValidationService;
import org.squashtest.tm.plugin.security.ad.ldap.licensevalidator.service.helper.DateHelper;

public class ExternalPluginValidationServiceImpl
implements ExternalPluginValidationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalPluginValidationServiceImpl.class);
    private static final String PUBLIC_KEY = "/org/squashtest/tm/plugin/security/ad/ldap/licensevalidator/squash-tm.pub";
    private static final String PRODUCT_ID = "Squash-TM";
    private static final int TWO_MONTH_TOLERANCE_PERIOD = -61;
    private ApplicationContext appCtx;
    private DateHelper dateHelper = DateHelper.INSTANCE;

    @Override
    public License validateLicense(String encodedLicense) {
        String publicKey = null;
        try {
            publicKey = this.readPublicKeyFromResources();
        }
        catch (IOException e) {
            LOGGER.error("Error occurs while reading Squash public key.", (Throwable)e);
            return null;
        }
        return LicenseValidator.validate(encodedLicense, publicKey, PRODUCT_ID, null, null, this.dateHelper.getCurrentDate(), null);
    }

    @Override
    public String readLicenseFile(String path) {
        String encodedLicense = null;
        try {
            encodedLicense = FileUtils.readFile(path);
        }
        catch (IOException e) {
            LOGGER.error("Error occurs while reading Squash license file.", (Throwable)e);
        }
        return encodedLicense;
    }

    @Override
    public void validateLicenseForPlugin(@NotNull License license, String plugin) throws LicenseSecurityException {
        this.isLicenseValid(license);
        String isAllowed = license.getLicenseText().getCustomSignedFeature(plugin);
        if (isAllowed == null) {
            LOGGER.warn("{} is not indicated in your license file, please contact support.", (Object)plugin);
            isAllowed = "false";
        }
        if (!Boolean.valueOf(isAllowed).booleanValue()) {
            throw new LicenseSecurityException("Current license does not grant access to this plugin: " + plugin);
        }
    }

    @Override
    public String getLicenseType(@NotNull License license) {
        return license.getLicenseText().getCustomSignedFeatures().get("license-type");
    }

    @Override
    public void checkLicenseTypeIsUltimate(@NotNull License license) {
        if (!LicenseType.ULTIMATE.name().equals(this.getLicenseType(license))) {
            LOGGER.warn("You do not have an Ultimate Squash license. Shut down initialized.");
            this.shutDownApp();
        }
    }

    @Override
    public void checkExpirationDate(LocalDate expirationDate) throws LicenseSecurityException {
        long remainingDays = this.dateHelper.getCurrentLocalDate().until(expirationDate, ChronoUnit.DAYS);
        if (remainingDays < -61L) {
            throw new LicenseSecurityException("License has expired more than two months.");
        }
    }

    @Override
    public void shutDownApp() {
        if (this.appCtx != null) {
            ((ConfigurableApplicationContext)this.appCtx).close();
        }
        throw new SquashLicenseValidatorException("The license validation has failed, shutting down...");
    }

    private String readPublicKeyFromResources() throws IOException {
        URL url = this.getClass().getResource(PUBLIC_KEY);
        String result = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        return result.replace("\n", "").replace("\r", "");
    }

    private void isLicenseValid(License license) throws LicenseSecurityException {
        switch (license.getValidationStatus()) {
            case LICENSE_VALID: {
                this.checkExpirationDate(this.dateHelper.convertDateToLocalDate(license.getLicenseText().getLicenseExpireDate()));
                break;
            }
            case LICENSE_INVALID: {
                throw new LicenseSecurityException("License file is not valid.");
            }
            case LICENSE_EXPIRED: {
                LocalDate expiredDate = this.dateHelper.convertDateToLocalDate(license.getLicenseText().getLicenseExpireDate());
                LOGGER.info("License has expired since {}", (Object)expiredDate);
                this.checkExpirationDate(expiredDate);
                break;
            }
            default: {
                throw new LicenseSecurityException("Errors occurs when validating the license file.");
            }
        }
    }

    @Inject
    public void setAppCtx(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }
}

