/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.security.ad.ldap;

import java.util.Collection;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.squashtest.tm.plugin.security.ad.ldap.ActiveDirectoryAuthenticationException;

public class ActiveDirectoryLdapAuthenticationProvider
extends AbstractLdapAuthenticationProvider
implements InitializingBean {
    private static final String DEFAULT_SEARCH_FILTER = "(&(objectClass=user)(userPrincipalName={0}))";
    private static final Pattern SUB_ERROR_CODE = Pattern.compile(".*data\\s([0-9a-f]{3,4}).*");
    private static final int USERNAME_NOT_FOUND = 1317;
    private static final int INVALID_PASSWORD = 1326;
    private static final int NOT_PERMITTED = 1328;
    private static final int PASSWORD_EXPIRED = 1330;
    private static final int ACCOUNT_DISABLED = 1331;
    private static final int ACCOUNT_EXPIRED = 1793;
    private static final int PASSWORD_NEEDS_RESET = 1907;
    private static final int ACCOUNT_LOCKED = 1909;
    private final String domain;
    private final String rootDn;
    private final String url;
    private boolean convertSubErrorCodesToExceptions;
    private LdapAuthoritiesPopulator authoritiesPopulator;
    private ContextFactory contextFactory = new ContextFactory();
    private String searchFilter = "(&(objectClass=user)(userPrincipalName={0}))";
    private String searchBase;

    public ActiveDirectoryLdapAuthenticationProvider(String domain, String url) {
        Assert.isTrue((boolean)StringUtils.hasText((String)url), (String)"Url cannot be empty");
        this.domain = StringUtils.hasText((String)domain) ? domain.toLowerCase() : null;
        this.url = url;
        this.rootDn = this.domain == null ? null : this.rootDnFromDomain(this.domain);
    }

    protected DirContextOperations doAuthentication(UsernamePasswordAuthenticationToken auth) {
        String username = auth.getName();
        String password = (String)auth.getCredentials();
        DirContext ctx = this.bindAsUser(username, password);
        try {
            DirContextOperations dirContextOperations = this.searchForUser(ctx, username);
            return dirContextOperations;
        }
        catch (NamingException e) {
            this.logger.error((Object)("Failed to locate directory entry for authenticated user: " + username), (Throwable)e);
            throw this.badCredentials(e);
        }
        finally {
            LdapUtils.closeContext((DirContext)ctx);
        }
    }

    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        return this.authoritiesPopulator.getGrantedAuthorities(userData, username);
    }

    DirContext bindAsUser(String username, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        String bindPrincipal = this.createBindPrincipal(username);
        env.put("java.naming.security.principal", bindPrincipal);
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.factory.object", DefaultDirObjectFactory.class.getName());
        try {
            return this.contextFactory.createContext(env);
        }
        catch (NamingException e) {
            if (e instanceof AuthenticationException || e instanceof OperationNotSupportedException) {
                this.handleBindException(bindPrincipal, e);
                throw this.badCredentials(e);
            }
            throw LdapUtils.convertLdapException((NamingException)e);
        }
    }

    private void handleBindException(String bindPrincipal, NamingException exception) {
        int subErrorCode;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication for " + bindPrincipal + " failed:" + exception));
        }
        if ((subErrorCode = this.parseSubErrorCode(exception.getMessage())) <= 0) {
            this.logger.debug((Object)"Failed to locate AD-specific sub-error code in message");
            return;
        }
        this.logger.info((Object)("Active Directory authentication failed: " + this.subCodeToLogMessage(subErrorCode)));
        if (this.convertSubErrorCodesToExceptions) {
            this.raiseExceptionForErrorCode(subErrorCode, exception);
        }
    }

    private int parseSubErrorCode(String message) {
        Matcher m = SUB_ERROR_CODE.matcher(message);
        if (m.matches()) {
            return Integer.parseInt(m.group(1), 16);
        }
        return -1;
    }

    private void raiseExceptionForErrorCode(int code, NamingException exception) {
        String hexString = Integer.toHexString(code);
        ActiveDirectoryAuthenticationException cause = new ActiveDirectoryAuthenticationException(hexString, exception.getMessage(), exception);
        throw switch (code) {
            case 1330 -> new CredentialsExpiredException(this.messages.getMessage("LdapAuthenticationProvider.credentialsExpired", "User credentials have expired"), (Throwable)((Object)cause));
            case 1331 -> new DisabledException(this.messages.getMessage("LdapAuthenticationProvider.disabled", "User is disabled"), (Throwable)((Object)cause));
            case 1793 -> new AccountExpiredException(this.messages.getMessage("LdapAuthenticationProvider.expired", "User account has expired"), (Throwable)((Object)cause));
            case 1909 -> new LockedException(this.messages.getMessage("LdapAuthenticationProvider.locked", "User account is locked"), (Throwable)((Object)cause));
            default -> this.badCredentials((Throwable)((Object)cause));
        };
    }

    private String subCodeToLogMessage(int code) {
        return switch (code) {
            case 1317 -> "User was not found in directory";
            case 1326 -> "Supplied password was invalid";
            case 1328 -> "User not permitted to logon at this time";
            case 1330 -> "Password has expired";
            case 1331 -> "Account is disabled";
            case 1793 -> "Account expired";
            case 1907 -> "User must reset password";
            case 1909 -> "Account locked";
            default -> "Unknown (error code " + Integer.toHexString(code) + ")";
        };
    }

    private BadCredentialsException badCredentials() {
        return new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
    }

    private BadCredentialsException badCredentials(Throwable cause) {
        return (BadCredentialsException)this.badCredentials().initCause(cause);
    }

    private DirContextOperations searchForUser(DirContext ctx, String username) throws NamingException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        String bindPrincipal = this.createBindPrincipal(username);
        String searchRoot = this.buildSearchRoot(bindPrincipal);
        try {
            return SpringSecurityLdapTemplate.searchForSingleEntryInternal((DirContext)ctx, (SearchControls)searchCtls, (String)searchRoot, (String)this.searchFilter, (Object[])new Object[]{bindPrincipal, username});
        }
        catch (IncorrectResultSizeDataAccessException incorrectResults) {
            if (incorrectResults.getActualSize() == 0) {
                UsernameNotFoundException userNameNotFoundException = new UsernameNotFoundException("User " + username + " not found in directory.", (Throwable)incorrectResults);
                throw this.badCredentials((Throwable)userNameNotFoundException);
            }
            throw incorrectResults;
        }
    }

    private String buildSearchRoot(String bindPrincipal) {
        if (this.searchBase != null) {
            return this.searchBase;
        }
        return this.rootDn != null ? this.rootDn : this.searchRootFromPrincipal(bindPrincipal);
    }

    private String searchRootFromPrincipal(String bindPrincipal) {
        int atChar = bindPrincipal.lastIndexOf(64);
        if (atChar < 0) {
            this.logger.debug((Object)("User principal '" + bindPrincipal + "' does not contain the domain, and no domain has been configured"));
            throw this.badCredentials();
        }
        return this.rootDnFromDomain(bindPrincipal.substring(atChar + 1));
    }

    String rootDnFromDomain(String domain) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)domain, (String)".");
        StringBuilder root = new StringBuilder();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (root.length() > 0) {
                root.append(',');
            }
            root.append("dc=").append(token);
            ++n2;
        }
        return root.toString();
    }

    private String createBindPrincipal(String username) {
        if (this.domain == null || username.toLowerCase().endsWith(this.domain)) {
            return username;
        }
        return String.valueOf(username) + "@" + this.domain;
    }

    void setConvertSubErrorCodesToExceptions(boolean convertSubErrorCodesToExceptions) {
        this.convertSubErrorCodesToExceptions = convertSubErrorCodesToExceptions;
    }

    public void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        this.authoritiesPopulator = authoritiesPopulator;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.authoritiesPopulator, (String)"authoritiesPopulator property should not be null");
        Assert.hasText((String)this.searchFilter, (String)"searchFilter property should not be blank");
    }

    void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    static class ContextFactory {
        ContextFactory() {
        }

        DirContext createContext(Hashtable<?, ?> env) throws NamingException {
            return new InitialLdapContext(env, null);
        }
    }
}

