/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.webhook;

import com.google.common.base.CharMatcher;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.CharUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.IllegalGitLabTokenException;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

@Component
public class WebhookSecretTokenProvider {
    @Value(value="${plugin.synchronisation.gitlab.webhook.secret-token:#{null}}")
    private String secretToken;
    @Value(value="${plugin.synchronisation.gitlab.webhook.show-secret-token:true}")
    private boolean showSecretToken = true;

    public String getSecretToken() {
        return this.secretToken;
    }

    public boolean isSecretTokenShown() {
        return this.showSecretToken;
    }

    @PostConstruct
    public void checkCurrentTokenValidity() {
        if (this.secretToken != null && !WebhookSecretTokenProvider.isTokenWellFormed(this.secretToken)) {
            throw new IllegalGitLabTokenException();
        }
    }

    public static boolean isTokenWellFormed(@NotNull String token) {
        if (!CharMatcher.ascii().matchesAllOf((CharSequence)token)) {
            return false;
        }
        char[] cArray = token.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!CharUtils.isAsciiPrintable((char)c)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

