/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.ReportingNoteFormatter;
import org.squashtest.tm.service.internal.configuration.CallbackUrlProvider;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatus;
import org.squashtest.tm.service.statistics.testingstatus.exception.IllegalStatisticRatesException;

@Service(value="org.squashtest.tm.plugin.xsquash4gitlab.GitLabReportingHelper")
public class GitLabReportingLocaleHelper {
    private static final String RATIO_PATTERN = "%d%% (%d/%d)";
    private static final String REQUIREMENT_ROUTE_FORMAT = "requirement-workspace/requirement/%d/content";
    private final ReportingNoteFormatter reportingNoteFormatter;
    private final CallbackUrlProvider callbackUrlProvider;
    private final MessageSource messageSource;
    private final String tmSignature;
    private final ReportingNoteFormatter.LocaleCode localeToUse;

    public GitLabReportingLocaleHelper(ReportingNoteFormatter reportingNoteFormatter, CallbackUrlProvider callbackUrlProvider, @Named(value="xsquash4GitLabMessageSource") @Named(value="xsquash4GitLabMessageSource") MessageSource messageSource) {
        this.reportingNoteFormatter = reportingNoteFormatter;
        this.callbackUrlProvider = callbackUrlProvider;
        this.messageSource = messageSource;
        this.tmSignature = this.getLocalizedSignature();
        this.localeToUse = this.findLocaleToUse();
    }

    public String getTmSignature() {
        return this.tmSignature;
    }

    public String buildReportNote(RemoteRequirementStatistics stats, String issueRemoteKey, Set<Long> requirementIds) {
        ReportingNoteFormatter.NoteParameters parameters = this.buildNoteParameters(stats, issueRemoteKey, requirementIds);
        return this.reportingNoteFormatter.formatReportNote(parameters, this.localeToUse);
    }

    private ReportingNoteFormatter.NoteParameters buildNoteParameters(RemoteRequirementStatistics stats, String issueRemoteKey, Set<Long> requirementIds) {
        try {
            RemoteTestingStatus status = RemoteTestingStatus.findStatus((RemoteRequirementStatistics)stats);
            return new ReportingNoteFormatter.NoteParameters(this.getStatusEmoji(status), this.getStatusText(status), this.getRedactionRatio(stats), this.getVerificationRatio(stats), this.getValidationRatio(stats), this.makeLinksToRequirement(requirementIds), this.tmSignature);
        }
        catch (IllegalStatisticRatesException ex) {
            throw new IllegalArgumentException(String.format("Could not find testing status for remote key %s", issueRemoteKey), ex);
        }
    }

    private String getStatusEmoji(RemoteTestingStatus status) {
        switch (status) {
            case VALIDATION_IN_PROGRESS: {
                return ":arrow_forward:";
            }
            case CONCEPTION: {
                return ":pencil2:";
            }
            case INVALID: {
                return ":x:";
            }
            case TO_EXECUTE: {
                return ":checkered_flag:";
            }
            case VALID: {
                return ":white_check_mark:";
            }
        }
        return "";
    }

    private String getStatusText(RemoteTestingStatus status) {
        String code = "reporting.testing.status." + status.name();
        return this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
    }

    private String getLocalizedSignature() {
        return this.messageSource.getMessage("reporting.signature", null, LocaleContextHolder.getLocale());
    }

    private String getRedactionRatio(RemoteRequirementStatistics stats) {
        return String.format(RATIO_PATTERN, stats.redactionRate.percentRoundedRate, stats.redactionRate.matchingCount, stats.redactionRate.totalCount);
    }

    private String getVerificationRatio(RemoteRequirementStatistics stats) {
        return String.format(RATIO_PATTERN, stats.verificationRate.percentRoundedRate, stats.verificationRate.matchingCount, stats.verificationRate.totalCount);
    }

    private String getValidationRatio(RemoteRequirementStatistics stats) {
        return String.format(RATIO_PATTERN, stats.validationRate.percentRoundedRate, stats.validationRate.matchingCount, stats.validationRate.totalCount);
    }

    private String makeLinksToRequirement(Set<Long> requirementIds) {
        return requirementIds.stream().sorted().map(this::makeLinkToRequirement).collect(Collectors.joining(", "));
    }

    private String makeLinkToRequirement(Long requirementId) {
        String url = this.makeUrlToRequirement(requirementId);
        return String.format("[%d](%s)", requirementId, url);
    }

    private String makeUrlToRequirement(Long requirementId) {
        String baseUrl = this.callbackUrlProvider.getCallbackUrl().toExternalForm();
        if (!baseUrl.endsWith("/")) {
            baseUrl = String.valueOf(baseUrl) + "/";
        }
        return String.valueOf(baseUrl) + String.format(REQUIREMENT_ROUTE_FORMAT, requirementId);
    }

    private ReportingNoteFormatter.LocaleCode findLocaleToUse() {
        Locale squashLocale = LocaleContextHolder.getLocale();
        if (Locale.FRENCH.getLanguage().equals(squashLocale.getLanguage())) {
            return ReportingNoteFormatter.LocaleCode.FR;
        }
        return ReportingNoteFormatter.LocaleCode.EN;
    }
}

