/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.finder;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.squashtest.tm.domain.campaign.SprintRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.internal.repository.SprintRequirementSyncExtenderDao;

public class RemoteRequirementFinder {
    private static final Duration UPDATE_INTERVAL_THRESHOLD = Duration.ofSeconds(1L);
    private final RequirementSyncExtenderDao requirementSyncExtenderDao;
    private final SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao;

    public RemoteRequirementFinder(RequirementSyncExtenderDao requirementSyncExtenderDao, SprintRequirementSyncExtenderDao sprintRequirementSyncExtenderDao) {
        this.requirementSyncExtenderDao = requirementSyncExtenderDao;
        this.sprintRequirementSyncExtenderDao = sprintRequirementSyncExtenderDao;
    }

    public Result findRemoteRequirementsToUpdate(List<GitLabIssue> gitLabIssues, long remoteSyncId) {
        HashSet<GitLabIssue> toUpdate = new HashSet<GitLabIssue>();
        HashSet<GitLabIssue> toCreate = new HashSet<GitLabIssue>();
        HashSet<GitLabIssue> allIssues = new HashSet<GitLabIssue>(gitLabIssues);
        HashMap<String, RequirementSyncExtender> knownExtenders = new HashMap<String, RequirementSyncExtender>();
        gitLabIssues.forEach(issue -> {
            String remoteKey = GitLabEntityHelper.getKey(issue);
            RequirementSyncExtender knownSyncExtender = this.requirementSyncExtenderDao.retrieveByRemoteKeyAndSyncId(remoteKey, Long.valueOf(remoteSyncId));
            if (knownSyncExtender == null) {
                toCreate.add((GitLabIssue)issue);
            } else {
                knownExtenders.put(remoteKey, knownSyncExtender);
                if (RemoteRequirementFinder.hasRemoteModifications(issue, knownSyncExtender)) {
                    toUpdate.add((GitLabIssue)issue);
                }
            }
        });
        return Result.of(toCreate, toUpdate, allIssues, knownExtenders);
    }

    public Result findSprintReqVersionsToUpdate(List<GitLabIssue> gitLabIssues, long remoteSyncId, long squashSprintId) {
        HashSet<GitLabIssue> toUpdate = new HashSet<GitLabIssue>();
        HashSet<GitLabIssue> toCreate = new HashSet<GitLabIssue>();
        HashSet<GitLabIssue> allIssues = new HashSet<GitLabIssue>(gitLabIssues);
        HashMap<String, SprintRequirementSyncExtender> knownExtenders = new HashMap<String, SprintRequirementSyncExtender>();
        gitLabIssues.forEach(issue -> {
            String remoteKey = GitLabEntityHelper.getKey(issue);
            SprintRequirementSyncExtender knownSyncExtender = this.sprintRequirementSyncExtenderDao.findBySprintIdRemoteSyncIdAndRemoteReqId(squashSprintId, remoteSyncId, remoteKey);
            if (knownSyncExtender == null) {
                toCreate.add((GitLabIssue)issue);
            } else {
                knownExtenders.put(remoteKey, knownSyncExtender);
                if (RemoteRequirementFinder.hasRemoteSprintReqModifications(issue, knownSyncExtender)) {
                    toUpdate.add((GitLabIssue)issue);
                }
            }
        });
        return Result.ofSprintRequirementExtenders(toCreate, toUpdate, allIssues, knownExtenders);
    }

    public static boolean hasRemoteModifications(GitLabIssue issue, RequirementSyncExtender knownSyncExtender) {
        long lastSync;
        long lastModification = issue.getUpdatedAt().getTime();
        return (double)Math.abs(lastModification - (lastSync = knownSyncExtender.getRemoteLastUpdated().getTime())) > (double)UPDATE_INTERVAL_THRESHOLD.getSeconds() * 1000.0;
    }

    public static boolean hasRemoteSprintReqModifications(GitLabIssue issue, SprintRequirementSyncExtender knownSyncExtender) {
        long lastSync;
        long lastModification = issue.getUpdatedAt().getTime();
        return (double)Math.abs(lastModification - (lastSync = knownSyncExtender.getRemoteLastUpdated().getTime())) > (double)UPDATE_INTERVAL_THRESHOLD.getSeconds() * 1000.0;
    }

    public static final class Result {
        public final Set<GitLabIssue> toCreate;
        public final Set<GitLabIssue> toUpdate;
        public final Set<GitLabIssue> allIssues;
        public final Map<String, RequirementSyncExtender> knownExtenders;
        public final Map<String, SprintRequirementSyncExtender> knownSprintReqVersionExtenders;

        private Result(Set<GitLabIssue> toCreate, Set<GitLabIssue> toUpdate, Set<GitLabIssue> allIssues, Map<String, RequirementSyncExtender> knownExtenders, Map<String, SprintRequirementSyncExtender> knownSprintReqVersionExtenders) {
            this.toCreate = toCreate;
            this.toUpdate = toUpdate;
            this.allIssues = allIssues;
            this.knownExtenders = knownExtenders;
            this.knownSprintReqVersionExtenders = knownSprintReqVersionExtenders;
        }

        public static Result of(Set<GitLabIssue> toCreate, Set<GitLabIssue> toUpdate, Set<GitLabIssue> allIssues, Map<String, RequirementSyncExtender> knownExtenders) {
            return new Result(toCreate, toUpdate, allIssues, knownExtenders, new HashMap<String, SprintRequirementSyncExtender>());
        }

        public static Result ofSprintRequirementExtenders(Set<GitLabIssue> toCreate, Set<GitLabIssue> toUpdate, Set<GitLabIssue> allIssues, Map<String, SprintRequirementSyncExtender> knownSprintReqVersionExtenders) {
            return new Result(toCreate, toUpdate, allIssues, new HashMap<String, RequirementSyncExtender>(), knownSprintReqVersionExtenders);
        }

        public boolean isKnownSyncExtender(String issueKey) {
            return this.knownExtenders.containsKey(issueKey);
        }

        public boolean shouldUpdateOrCreate(GitLabIssue gitLabIssue) {
            return this.toCreate.contains(gitLabIssue) || this.toUpdate.contains(gitLabIssue);
        }
    }
}

