/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementSyncExtender;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabEntityHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.service.FieldMappingService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementHierarchyHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.RequirementMover;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronizedFolderService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinder;
import org.squashtest.tm.plugin.xsquash4gitlab.service.finder.RemoteRequirementFinderFactory;
import org.squashtest.tm.service.importer.ImportMode;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.importer.LogEntry;
import org.squashtest.tm.service.internal.batchimport.FacilityImpl;
import org.squashtest.tm.service.internal.batchimport.LogTrain;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.library.HibernatePathService;
import org.squashtest.tm.service.internal.repository.RequirementSyncExtenderDao;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Scope(value="prototype")
@Component(value="squash.tm.plugin.xsquash4gitlab.RequirementImporter")
@Transactional
public class RequirementImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementImporter.class);
    private final RemoteRequirementFinderFactory remoteRequirementFinderFactory;
    private final FacilityImpl facility;
    private final InternationalizationHelper internationalizationHelper;
    private final RequirementMover requirementMover;
    private final RequirementSyncExtenderDao requirementSyncExtenderDao;
    private final HibernatePathService hibernatePathService;
    private final FieldMappingService fieldMappingService;
    private final SynchronizedFolderService synchronizedFolderService;
    private final RequirementLibraryNavigationService reqLibNavigationService;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public RequirementImporter(RemoteRequirementFinderFactory remoteRequirementFinderFactory, FacilityImpl facility, InternationalizationHelper internationalizationHelper, RequirementMover requirementMover, RequirementSyncExtenderDao requirementSyncExtenderDao, HibernatePathService hibernatePathService, SynchronizedFolderService synchronizedFolderService, FieldMappingService fieldMappingService, RequirementLibraryNavigationService reqLibNavigationService) {
        this.remoteRequirementFinderFactory = remoteRequirementFinderFactory;
        this.facility = facility;
        this.internationalizationHelper = internationalizationHelper;
        this.requirementMover = requirementMover;
        this.requirementSyncExtenderDao = requirementSyncExtenderDao;
        this.hibernatePathService = hibernatePathService;
        this.synchronizedFolderService = synchronizedFolderService;
        this.fieldMappingService = fieldMappingService;
        this.reqLibNavigationService = reqLibNavigationService;
    }

    public void importGitLabIssues(List<GitLabIssue> gitLabIssues, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        RemoteRequirementFinder.Result finderResult = this.remoteRequirementFinderFactory.create().findRemoteRequirementsToUpdate(gitLabIssues, gitLabRemoteSynchronisation.getRemoteSynchronisation().getId());
        Long rootFolderId = this.prepareRootFolder(gitLabRemoteSynchronisation);
        String rootFolderPath = this.requirementMover.getFolderPath(rootFolderId);
        this.prepareSubFolders(gitLabRemoteSynchronisation, gitLabIssues);
        ArrayList instructionsToPostProcess = new ArrayList();
        gitLabIssues.forEach(gitLabIssue -> {
            RequirementVersionInstruction instruction;
            if (finderResult.shouldUpdateOrCreate((GitLabIssue)gitLabIssue) && !(instruction = this.generateAndProcessInstruction((GitLabIssue)gitLabIssue, finderResult, gitLabRemoteSynchronisation, rootFolderPath)).isFatalError()) {
                instructionsToPostProcess.add(instruction);
            }
        });
        this.facility.postprocess(instructionsToPostProcess);
    }

    private Long prepareRootFolder(GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        return this.synchronizedFolderService.prepareRootTargetFolder(gitLabRemoteSynchronisation.getRemoteSynchronisation());
    }

    private void prepareSubFolders(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, List<GitLabIssue> gitLabIssues) {
        this.synchronizedFolderService.prepareSubFolders(gitLabRemoteSynchronisation, gitLabIssues);
    }

    private RequirementVersionInstruction generateAndProcessInstruction(GitLabIssue gitLabIssue, RemoteRequirementFinder.Result finderResult, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String rootFolderPath) {
        boolean isKnownSyncExtender = finderResult.isKnownSyncExtender(GitLabEntityHelper.getKey(gitLabIssue));
        if (isKnownSyncExtender) {
            return this.updateRequirement(gitLabIssue, gitLabRemoteSynchronisation, finderResult, rootFolderPath);
        }
        return this.createRequirement(gitLabIssue, gitLabRemoteSynchronisation, rootFolderPath);
    }

    private RequirementVersionInstruction createRequirement(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String rootFolderPath) {
        String newRequirementPath = this.requirementMover.buildRequirementPath(gitLabRemoteSynchronisation, gitLabIssue, rootFolderPath);
        RequirementVersionInstruction instruction = this.createBaseInstruction(gitLabIssue, gitLabRemoteSynchronisation, newRequirementPath);
        instruction.setMode(ImportMode.CREATE);
        this.logTrace("attempting to create requirement version '" + ((RequirementVersionTarget)instruction.getTarget()).getPath() + "'");
        LogTrain logs = this.facility.createRequirementVersion(instruction);
        if (logs.hasCriticalErrors()) {
            this.logCriticalErrors(logs);
        } else {
            this.logTrace(String.format("Import went with no critical errors (%s entries)", logs.getEntries().size()));
            this.createSyncExtender(instruction, gitLabIssue, gitLabRemoteSynchronisation);
        }
        return instruction;
    }

    private RequirementVersionInstruction updateRequirement(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RemoteRequirementFinder.Result finderResult, String rootFolderPath) {
        RequirementSyncExtender syncExtender = finderResult.knownExtenders.get(GitLabEntityHelper.getKey(gitLabIssue));
        Long requirementId = syncExtender.getRequirement().getId();
        String currentRequirementPath = this.hibernatePathService.buildRequirementPath(requirementId.longValue());
        RequirementVersionInstruction instruction = this.createBaseInstruction(gitLabIssue, gitLabRemoteSynchronisation, currentRequirementPath);
        instruction.setMode(ImportMode.UPDATE);
        this.addExistingMilestonesInInstruction(instruction, requirementId);
        this.logTrace("attempting to update requirement version '" + currentRequirementPath + "' with new data");
        LogTrain logs = this.facility.updateRequirementVersion(instruction);
        this.moveExistingRequirementIfNeeded(gitLabIssue, gitLabRemoteSynchronisation, syncExtender, rootFolderPath, currentRequirementPath);
        if (logs.hasCriticalErrors()) {
            this.logCriticalErrors(logs);
        } else {
            this.logTrace(String.format("Import went with no critical errors (%s entries)", logs.getEntries().size()));
            String issueKey = GitLabEntityHelper.getKey(gitLabIssue);
            long syncId = gitLabRemoteSynchronisation.getRemoteSynchronisation().getId();
            RequirementSyncExtender extender = this.requirementSyncExtenderDao.retrieveByRemoteKeyAndSyncId(issueKey, Long.valueOf(syncId));
            this.updateSyncExtender(extender, gitLabIssue, gitLabRemoteSynchronisation);
        }
        return instruction;
    }

    private void addExistingMilestonesInInstruction(RequirementVersionInstruction instruction, Long requirementId) {
        Requirement req = this.reqLibNavigationService.findRequirement(requirementId);
        String[] existingMilestoneNames = (String[])req.getCurrentVersion().getMilestones().stream().map(Milestone::getLabel).toArray(String[]::new);
        instruction.setMilestones(existingMilestoneNames);
    }

    private void moveExistingRequirementIfNeeded(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, RequirementSyncExtender syncExtender, String rootFolderPath, String currentRequirementPath) {
        boolean shouldMoveRequirement;
        String desiredRequirementPath = this.requirementMover.buildRequirementPath(gitLabRemoteSynchronisation, gitLabIssue, rootFolderPath);
        boolean requirementHasDesiredPath = desiredRequirementPath.equals(currentRequirementPath);
        if (!requirementHasDesiredPath && (shouldMoveRequirement = RequirementHierarchyHelper.shouldMoveSyncedRequirement(gitLabRemoteSynchronisation, rootFolderPath, currentRequirementPath, true, gitLabIssue, true))) {
            this.requirementMover.updateRequirementPath(gitLabIssue, gitLabRemoteSynchronisation, syncExtender, rootFolderPath);
        }
    }

    private RequirementVersionInstruction createBaseInstruction(GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation, String requirementPath) {
        RequirementVersion version = new RequirementVersion();
        version.setVersionNumber(1);
        new Requirement(version);
        Long projectId = gitLabRemoteSynchronisation.getRemoteSynchronisation().getProject().getId();
        CustomFieldValueCollection customFieldValueCollection = new CustomFieldValueCollection();
        this.populate(gitLabRemoteSynchronisation, projectId, version, gitLabIssue, customFieldValueCollection);
        RequirementTarget requirementTarget = new RequirementTarget(requirementPath);
        requirementTarget.setRemoteKey(GitLabEntityHelper.getKey(gitLabIssue));
        requirementTarget.setRemoteSynchronisationId(Long.valueOf(gitLabRemoteSynchronisation.getRemoteSynchronisation().getId()));
        RequirementVersionTarget requirementVersionTarget = new RequirementVersionTarget(requirementTarget, null);
        RequirementVersionInstruction instruction = new RequirementVersionInstruction(requirementVersionTarget, version);
        for (Map.Entry<String, String> cuf : customFieldValueCollection.entrySet()) {
            instruction.addCustomField(cuf.getKey(), cuf.getValue());
        }
        requirementVersionTarget.setVersion(Integer.valueOf(1));
        return instruction;
    }

    private void populate(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, Long projectId, RequirementVersion version, GitLabIssue gitLabIssue, CustomFieldValueCollection customFieldValueCollection) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Parsing issue '%s'", gitLabIssue.getId()));
        }
        this.fieldMappingService.processFieldMappings(gitLabRemoteSynchronisation, projectId, version, gitLabIssue, customFieldValueCollection);
    }

    private void createSyncExtender(RequirementVersionInstruction instruction, GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        Requirement requirement = instruction.getRequirementVersion().getRequirement();
        if (requirement.getSyncExtender() != null) {
            throw new IllegalArgumentException("this was supposed to be a new requirement !");
        }
        RequirementSyncExtender extender = new RequirementSyncExtender();
        this.updateSyncExtender(extender, gitLabIssue, gitLabRemoteSynchronisation);
        requirement.setSyncExtender(extender);
        extender.setRequirement(requirement);
        this.entityManager.persist((Object)extender);
    }

    private void updateSyncExtender(RequirementSyncExtender extender, GitLabIssue gitLabIssue, GitLabRemoteSynchronisation gitLabRemoteSynchronisation) {
        String url = gitLabIssue.getWebUrl();
        String issueKey = GitLabEntityHelper.getKey(gitLabIssue);
        extender.setServer(gitLabRemoteSynchronisation.getRemoteSynchronisation().getServer());
        extender.setRemoteProjectId(gitLabIssue.getProjectId().toString());
        extender.setRemoteSynchronisation(gitLabRemoteSynchronisation.getRemoteSynchronisation());
        extender.setRemoteReqId(issueKey);
        extender.setRemoteLastUpdated(gitLabIssue.getUpdatedAt());
        try {
            extender.setRemoteUrl(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            this.logTrace("could not set url correctly for issue '" + issueKey + "', offending url being '" + url + "'");
        }
    }

    private void logCriticalErrors(LogTrain logs) {
        if (!this.isLogEnabled()) {
            return;
        }
        this.logTrace("Some critical errors occurred during requirement import :");
        for (LogEntry log : logs.getEntries()) {
            if (log.getStatus() != ImportStatus.FAILURE) continue;
            RequirementVersionTarget target = (RequirementVersionTarget)log.getTarget();
            String localeMessage = this.internationalizationHelper.getMessage(log.getI18nError(), log.getErrorArgs(), log.getI18nError(), LocaleContextHolder.getLocale());
            this.logTrace(String.valueOf(target.getPath()) + " : " + localeMessage);
        }
    }

    private boolean isLogEnabled() {
        return LOGGER.isTraceEnabled();
    }

    private void logTrace(String message) {
        if (this.isLogEnabled()) {
            LOGGER.trace(message);
        }
    }

    static class CustomFieldValueCollection {
        private final Map<String, String> customFieldValues = new HashMap<String, String>();

        CustomFieldValueCollection() {
        }

        void setValue(String code, String value) {
            this.customFieldValues.put(code, value);
        }

        Iterable<Map.Entry<String, String>> entrySet() {
            return this.customFieldValues.entrySet();
        }

        public Map<String, String> c() {
            return this.customFieldValues;
        }

        public Map<String, String> getCustomFieldValues() {
            return this.customFieldValues;
        }
    }
}

