/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jooq.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.SynchronisationDto;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.CreateSynchronisationModel;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.model.Mappings;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabField;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSelectType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabRemoteSynchronisation;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.PersistedConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SyncedRequirementHierarchy;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.SynchronisationFilterValue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.FieldMappingAlreadyExistsException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.NoneSelectedGitLabServerException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.UnauthorisedCufMappingException;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.Xsquash4GitLabConfigurationException;
import org.squashtest.tm.plugin.xsquash4gitlab.helpers.ValueMappingsYamlDeserializer;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.ConfigurationDao;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabPerimeterService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.UserConfigurationService;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.project.CustomGenericProjectManager;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Service(value="squash.tm.plugin.xsquash4gitlab.configurationService")
@Transactional
public class ConfigurationService {
    public static final WorkspaceType CONFIGURING_WORKSPACE = WorkspaceType.CAMPAIGN_WORKSPACE;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationService.class);
    public static final String CONFIGURATION_ERROR_MESSAGE = "Unable to fetch the configuration from project ";
    private static final String MANAGE_SYNC_OR_ROLE_ADMIN = "hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')";
    private static final List<InputType> ACCEPTED_INPUT_TYPES_FOR_GITLAB_ISSUE_STATE_FIELD = List.of(InputType.PLAIN_TEXT, InputType.RICH_TEXT, InputType.TAG);
    @PersistenceContext
    private EntityManager entityManager;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final ConfigurationDao configurationDao;
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final CampaignLibraryNavigationService campaignLibraryNavigationService;
    private final InternationalizationHelper internationalizationHelper;
    private final PluginRequirementDao pluginRequirementDao;
    private final UserConfigurationService userConfigurationService;
    private final CustomGenericProjectManager customGenericProjectManager;
    private final ValueMappingsYamlDeserializer valueMappingsYamlDeserializer;
    private final PermissionEvaluationService permissionEvaluationService;
    private final GitLabPerimeterService gitLabPerimeterService;
    private final GenericProjectDao genericProjectDao;
    private final CustomFieldDao customFieldDao;

    @Autowired
    public ConfigurationService(RemoteSynchronisationDao remoteSynchronisationDao, ConfigurationDao configurationDao, RequirementLibraryNavigationService requirementLibraryNavigationService, CampaignLibraryNavigationService campaignLibraryNavigationService, InternationalizationHelper internationalizationHelper, PluginRequirementDao pluginRequirementDao, UserConfigurationService userConfigurationService, CustomGenericProjectManager customGenericProjectManager, ValueMappingsYamlDeserializer valueMappingsYamlDeserializer, PermissionEvaluationService permissionEvaluationService, GitLabPerimeterService gitLabPerimeterService, GenericProjectDao genericProjectDao, CustomFieldDao customFieldDao) {
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.configurationDao = configurationDao;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.campaignLibraryNavigationService = campaignLibraryNavigationService;
        this.internationalizationHelper = internationalizationHelper;
        this.pluginRequirementDao = pluginRequirementDao;
        this.userConfigurationService = userConfigurationService;
        this.customGenericProjectManager = customGenericProjectManager;
        this.valueMappingsYamlDeserializer = valueMappingsYamlDeserializer;
        this.permissionEvaluationService = permissionEvaluationService;
        this.gitLabPerimeterService = gitLabPerimeterService;
        this.genericProjectDao = genericProjectDao;
        this.customFieldDao = customFieldDao;
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public SynchronisationDto createNewSynchronisation(long projectId, CreateSynchronisationModel model) {
        String modelName = model.getName();
        model.setName(modelName.trim());
        this.validateName(modelName);
        this.checkProjectIsNotATemplate(projectId);
        model.cleanPaths();
        Project project = (Project)this.entityManager.find(Project.class, (Object)projectId);
        this.requirementLibraryNavigationService.validatePathForSync(project.getName(), model.getSynchronisationPath());
        if (model.isSprintSynchronisationEnable()) {
            this.campaignLibraryNavigationService.validatePathForSync(project.getName(), model.getSprintSynchronisationPath());
        }
        try {
            GitLabRemoteSynchronisation sync = this.buildGitLabRemoteSynchronisationFromModel(project, model);
            this.checkMaxItems(model, sync);
            this.entityManager.persist((Object)sync.getRemoteSynchronisation());
            this.entityManager.flush();
            if (sync.isSprintSynchronisationEnable()) {
                this.configurationDao.saveConfiguration(projectId, sync.getId(), model.getMappings(), model.isDisplayState());
            }
            return this.transformRemoteSynchronisationInDto(sync.getRemoteSynchronisation());
        }
        catch (IOException ioException) {
            throw new Xsquash4GitLabConfigurationException("Could not create synchronisation.", ioException);
        }
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public SynchronisationDto createNewSprintSynchronisation(long syncId, CreateSynchronisationModel model) {
        model.cleanPaths();
        RemoteSynchronisation syncToUpdate = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        this.campaignLibraryNavigationService.validatePathForSync(syncToUpdate.getProject().getName(), model.getSprintSynchronisationPath());
        try {
            GitLabRemoteSynchronisation syncToTest = this.buildGitLabRemoteSynchronisationFromModel(syncToUpdate.getProject(), model);
            this.gitLabPerimeterService.checkIfMaxNumberOfIssuesInPerimeterExceeded(syncToTest, true);
        }
        catch (IOException ioException) {
            throw new Xsquash4GitLabConfigurationException("Could not create sprint synchronisation.", ioException);
        }
        return this.updateSynchronisationWithSprintAttributesFromModel(model, syncToUpdate);
    }

    private SynchronisationDto updateSynchronisationWithSprintAttributesFromModel(CreateSynchronisationModel model, RemoteSynchronisation syncToUpdate) {
        GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(syncToUpdate);
        try {
            gitLabRemoteSynchronisation.setSprintSynchronisationEnable(true);
            gitLabRemoteSynchronisation.setSprintSynchronisationPath(model.getSprintSynchronisationPath());
        }
        catch (IOException e) {
            throw new Xsquash4GitLabConfigurationException("Could not update synchronisation.", e);
        }
        return this.updateSprintBoardOrFiltersFromModel(gitLabRemoteSynchronisation, model);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public SynchronisationDto updateSprintSynchronisation(long syncId, CreateSynchronisationModel model) {
        RemoteSynchronisation syncToUpdate = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(syncToUpdate);
        return this.updateSprintBoardOrFiltersFromModel(gitLabRemoteSynchronisation, model);
    }

    private SynchronisationDto updateSprintBoardOrFiltersFromModel(GitLabRemoteSynchronisation gitLabRemoteSynchronisation, CreateSynchronisationModel model) {
        try {
            gitLabRemoteSynchronisation.setSprintRemoteSelectType(model.getSprintRemoteSelectType());
            if (GitLabRemoteSelectType.BOARD.name().equals(model.getSprintRemoteSelectType())) {
                gitLabRemoteSynchronisation.setSprintSelectValue(model.getSprintSelectValue());
                gitLabRemoteSynchronisation.setSprintFilterValues(null);
            } else {
                gitLabRemoteSynchronisation.setSprintSelectValue(null);
                gitLabRemoteSynchronisation.setSprintFilterValues(model.getSprintFilterValues());
            }
            this.configurationDao.saveConfiguration(gitLabRemoteSynchronisation.getProject().getId(), gitLabRemoteSynchronisation.getId(), model.getMappings(), model.isDisplayState());
        }
        catch (IOException e) {
            throw new Xsquash4GitLabConfigurationException("Could not update synchronisation.", e);
        }
        return this.transformRemoteSynchronisationInDto(gitLabRemoteSynchronisation.getRemoteSynchronisation());
    }

    public Mappings getMappingsFromProjectAndSync(Long projectId, Long syncId) {
        try {
            PersistedConfiguration persistedConfiguration = this.configurationDao.loadOrGetDefaultConfiguration(projectId);
            return persistedConfiguration.getMappingsBySyncIds().get(syncId);
        }
        catch (IOException e) {
            throw new BugTrackerLocalException("Cannot read configuration for project " + projectId, (Throwable)e);
        }
    }

    public Map<Long, Boolean> getDisplayStateBySyncIdFromProject(long projectId) {
        try {
            PersistedConfiguration persistedConfiguration = this.configurationDao.loadOrGetDefaultConfiguration(projectId);
            return persistedConfiguration.getDisplayStateBySyncId();
        }
        catch (IOException e) {
            throw new BugTrackerLocalException("Cannot read configuration for project " + projectId, (Throwable)e);
        }
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public SynchronisationDto deleteSprintSynchronisation(long syncId) {
        RemoteSynchronisation syncToUpdate = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(syncToUpdate);
        try {
            gitLabRemoteSynchronisation.removeSprintSynchronisation();
            this.configurationDao.removeSyncPropertyBindings(syncToUpdate.getProject().getId(), Collections.singletonList(syncId));
        }
        catch (IOException e) {
            throw new Xsquash4GitLabConfigurationException("Could not delete sprint synchronisation.", e);
        }
        this.customGenericProjectManager.removeSprintSynchronisationBySyncIds(Collections.singletonList(syncId));
        return this.transformRemoteSynchronisationInDto(gitLabRemoteSynchronisation.getRemoteSynchronisation());
    }

    private void checkMaxItems(CreateSynchronisationModel model, GitLabRemoteSynchronisation sync) {
        if (model.isCheckMaxItems()) {
            this.gitLabPerimeterService.checkIfMaxNumberOfIssuesInPerimeterExceeded(sync, false);
            if (model.isSprintSynchronisationEnable()) {
                this.gitLabPerimeterService.checkIfMaxNumberOfIssuesInPerimeterExceeded(sync, true);
            }
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void validateFormStepOne(long projectId, CreateSynchronisationModel model) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)projectId);
        if (Objects.isNull(project)) {
            throw new Xsquash4GitLabConfigurationException("Project not found");
        }
        this.validateName(model.getName());
        model.cleanPaths();
        this.requirementLibraryNavigationService.validatePathForSync(project.getName(), model.getSynchronisationPath());
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void deleteRemoteSynchronisations(long projectId, List<Long> syncIds) {
        if (!syncIds.isEmpty()) {
            this.checkPermissionOnSyncIds(syncIds);
            this.customGenericProjectManager.removeSynchronisationsByIds(syncIds);
            this.configurationDao.removeSyncPropertyBindings(projectId, syncIds);
        }
    }

    public GitLabRemoteSynchronisation buildGitLabRemoteSynchronisationFromModel(Project project, CreateSynchronisationModel model) throws IOException {
        RemoteSynchronisation remoteSync = new RemoteSynchronisation();
        String modelRemoteSelectType = model.getRemoteSelectType();
        Long modelServerId = model.getServerId();
        String modelHierarchy = model.getHierarchy();
        remoteSync.setKind("squash.tm.plugin.xsquash4gitlab");
        remoteSync.setName(model.getName());
        remoteSync.setProject(Objects.requireNonNull(project));
        remoteSync.setSynchronisationEnable(true);
        remoteSync.setSelectType(modelRemoteSelectType);
        if (modelServerId == null || modelServerId.equals(0L)) {
            throw new NoneSelectedGitLabServerException("serverId");
        }
        BugTracker bugTracker = (BugTracker)this.entityManager.find(BugTracker.class, (Object)modelServerId);
        remoteSync.setServer(Objects.requireNonNull(bugTracker));
        GitLabRemoteSynchronisation sync = new GitLabRemoteSynchronisation(remoteSync);
        sync.setSynchronisationPath(model.getSynchronisationPath().trim());
        sync.setPerimeter(model.getPerimeter());
        sync.setSyncedRequirementHierarchy(SyncedRequirementHierarchy.valueOf(modelHierarchy));
        if (modelRemoteSelectType.equals(GitLabRemoteSelectType.BOARD.name())) {
            remoteSync.setSelectValue(model.getBoardId());
        } else if (modelRemoteSelectType.equals(GitLabRemoteSelectType.ISSUE.name())) {
            sync.setFilterValues(model.getFilterValues());
        }
        if (modelHierarchy.equals(SyncedRequirementHierarchy.MILESTONE.name()) || modelHierarchy.equals(SyncedRequirementHierarchy.ITERATION.name())) {
            boolean isSprintSynchronisationEnable = model.isSprintSynchronisationEnable();
            sync.setSprintSynchronisationEnable(isSprintSynchronisationEnable);
            if (isSprintSynchronisationEnable) {
                String modelSprintRemoteSelectType = model.getSprintRemoteSelectType();
                sync.setSprintSynchronisationPath(model.getSprintSynchronisationPath());
                sync.setSprintRemoteSelectType(modelSprintRemoteSelectType);
                if (modelSprintRemoteSelectType.equals(GitLabRemoteSelectType.BOARD.name())) {
                    sync.setSprintSelectValue(model.getSprintSelectValue());
                } else if (modelSprintRemoteSelectType.equals(GitLabRemoteSelectType.ISSUE.name())) {
                    sync.setSprintFilterValues(model.getSprintFilterValues());
                }
            }
        }
        return sync;
    }

    private void validateName(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new RequiredFieldException("name");
        }
        List existingSynchronisations = this.remoteSynchronisationDao.findByNameAndKind(name, "squash.tm.plugin.xsquash4gitlab");
        if (!existingSynchronisations.isEmpty()) {
            throw new NameAlreadyInUseException("RemoteSynchronisation", name, "name");
        }
    }

    private void checkProjectIsNotATemplate(long projectId) {
        boolean isTemplate = this.genericProjectDao.isProjectTemplate(projectId);
        if (isTemplate) {
            throw new Xsquash4GitLabConfigurationException("The project is a template");
        }
    }

    public void toggleSync(Long syncId, boolean isEnabled) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        remoteSynchronisation.setSynchronisationEnable(isEnabled);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void updateFilterValues(long syncId, List<SynchronisationFilterValue> filterValues) throws IOException {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        GitLabRemoteSynchronisation gitLabRemoteSynchronisation = new GitLabRemoteSynchronisation(remoteSynchronisation);
        gitLabRemoteSynchronisation.setFilterValues(filterValues);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void updateBoard(long syncId, String boardId) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        remoteSynchronisation.setSelectValue(boardId);
    }

    public List<SynchronisationDto> getRemoteSynchronisationsByProject(long projectId) {
        return this.remoteSynchronisationDao.findByProjectIdAndKind(Long.valueOf(projectId), "squash.tm.plugin.xsquash4gitlab").stream().map(this::transformRemoteSynchronisationInDto).toList();
    }

    private SynchronisationDto transformRemoteSynchronisationInDto(RemoteSynchronisation remoteSync) {
        Mappings mappings = Mappings.empty();
        Boolean displayState = null;
        if (GitLabRemoteSynchronisation.isSprintSynchronisationEnable(remoteSync)) {
            mappings = this.getMappingsFromProjectAndSync(remoteSync.getProject().getId(), remoteSync.getId());
            Map<Long, Boolean> displayStateBySyncId = this.getDisplayStateBySyncIdFromProject(remoteSync.getProject().getId());
            displayState = displayStateBySyncId.getOrDefault(remoteSync.getId(), true);
        }
        return SynchronisationDto.fromRemoteSynchronisationAndConfiguration(remoteSync, mappings, displayState);
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void commandFullSynchronisation(Long syncId) {
        this.commandFullSynchronisationUnsecured(syncId);
    }

    private void commandFullSynchronisationUnsecured(Long syncId) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("[Xsquash4GitLab : Command given to perform full synchronisation on %d", syncId));
        }
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        this.pluginRequirementDao.resetLastSyncDate(remoteSynchronisation);
    }

    private void commandFullSynchronisationForProject(Long projectId) {
        LOGGER.info("[Xsquash4GitLab : Command given to perform full synchronisation for {}", (Object)projectId);
        List<SynchronisationDto> synchronisations = this.getRemoteSynchronisationsByProject(projectId);
        synchronisations.forEach(synchronisation -> this.commandFullSynchronisationUnsecured(synchronisation.getId()));
    }

    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void updateName(long syncId, String newName) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        if (remoteSynchronisation.getName().equals(newName)) {
            return;
        }
        this.validateName(newName);
        remoteSynchronisation.setName(newName);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void addFieldMapping(Long projectId, FieldMapping mapping) {
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        if (userConfiguration.hasFieldMapping(mapping.getSquashField())) {
            throw new FieldMappingAlreadyExistsException();
        }
        userConfiguration.addFieldMapping(mapping);
        this.pluginRequirementDao.storeConfigurationForProject(projectId, userConfiguration);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public FieldMapping updateFieldMappingSquashField(Long projectId, String mappingId, String newValue) {
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        FieldMapping mapping = userConfiguration.getFieldMapping(mappingId);
        if (mapping == null) {
            return null;
        }
        if (mapping.getSquashField().equals(newValue)) {
            return mapping;
        }
        if (userConfiguration.hasFieldMapping(newValue)) {
            throw new PluginValidationException(this.internationalizationHelper.getMessage("henix.xsquash4gitlab.mappings.add.invalid", new Object[]{newValue}, "field mapping invalid", LocaleContextHolder.getLocale()));
        }
        if (mapping.isLocked()) {
            throw new IllegalArgumentException("attempted to modify a locked field mapping '" + mappingId + "' !");
        }
        this.checkAvailableSquashMappingsForGitLabStateField(mapping.getGitLabField(), newValue);
        mapping.setSquashField(newValue);
        Optional<String> defaultGitLabValue = FieldMapping.getBuiltinMappingGitLabField(newValue);
        defaultGitLabValue.ifPresent(mapping::setGitLabField);
        this.pluginRequirementDao.storeConfigurationForProject(projectId, userConfiguration);
        return mapping;
    }

    private void checkAvailableSquashMappingsForGitLabStateField(String gitLabFieldId, String newCufCode) {
        CustomField newCuf;
        if (GitLabField.STATE.rawValue.equals(gitLabFieldId) && !ACCEPTED_INPUT_TYPES_FOR_GITLAB_ISSUE_STATE_FIELD.contains((newCuf = this.customFieldDao.findByCode(newCufCode)).getInputType())) {
            throw new UnauthorisedCufMappingException("The GitLabField 'State' cannot be mapped with a numeric, checkbox or date Squash field.");
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateFieldMappingGitLabField(Long projectId, String mappingId, String newValue) {
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        FieldMapping mapping = userConfiguration.getFieldMapping(mappingId);
        if (mapping.isLocked()) {
            throw new IllegalArgumentException("attempted to modify a locked field mapping '" + mappingId + "' !");
        }
        this.checkAvailableGitLabMappingsForGitLabStateField(mapping, newValue);
        mapping.setGitLabField(newValue);
        this.pluginRequirementDao.storeConfigurationForProject(projectId, userConfiguration);
    }

    private void checkAvailableGitLabMappingsForGitLabStateField(FieldMapping mapping, String newGitLabFieldValue) {
        CustomField cuf;
        if (GitLabField.STATE.rawValue.equals(newGitLabFieldValue) && !ACCEPTED_INPUT_TYPES_FOR_GITLAB_ISSUE_STATE_FIELD.contains((cuf = this.customFieldDao.findByCode(mapping.getSquashField())).getInputType())) {
            throw new UnauthorisedCufMappingException("The GitLabField 'State' cannot be mapped with a numeric, checkbox or date Squash field.");
        }
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void updateValueMappings(Long projectId, String newValueMapping) {
        this.valueMappingsYamlDeserializer.deserialize(newValueMapping);
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        userConfiguration.setYamlFieldValueMapping(newValueMapping);
        this.pluginRequirementDao.storeConfigurationForProject(projectId, userConfiguration);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFieldMappings(Long projectId, Collection<String> squashFields) {
        UserConfiguration conf = this.userConfigurationService.getUserConfiguration(projectId);
        for (String squashField : squashFields) {
            FieldMapping realItem = conf.getFieldMapping(squashField);
            if (realItem == null || realItem.isLocked()) continue;
            conf.removeFieldMapping(realItem);
        }
        this.pluginRequirementDao.storeConfigurationForProject(projectId, conf);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void removeFieldMappingsByIds(Long projectId, Collection<String> squashFields) {
        this.removeFieldMappings(projectId, squashFields);
    }

    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setTestReportingEnabled(Long projectId, Boolean isEnabled) {
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        userConfiguration.setTestReportingEnabled(isEnabled);
        this.pluginRequirementDao.storeConfigurationForProject(projectId, userConfiguration);
    }

    public boolean isTestReportingEnabled(Long projectId) {
        UserConfiguration userConfiguration = this.userConfigurationService.getUserConfiguration(projectId);
        return userConfiguration.isTestReportingEnabled();
    }

    private void checkPermissionOnSyncIds(List<Long> syncIds) {
        PermissionsUtils.checkPermission((PermissionEvaluationService)this.permissionEvaluationService, syncIds, (String)Permissions.MANAGE_PROJECT.name(), (String)RemoteSynchronisation.class.getName());
    }

    @PreAuthorize(value="hasPermission(#targetProjectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public void synchronizeTemplateConfiguration(Long templateId, Long targetProjectId) {
        UserConfiguration conf = this.userConfigurationService.getUserConfiguration(templateId);
        if (conf != null) {
            this.pluginRequirementDao.storeConfigurationForProject(targetProjectId, conf);
            this.commandFullSynchronisationForProject(targetProjectId);
        }
    }
}

