/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.graphql.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.FilteredBoardIssuesQueryBuilderAdapterCommunity;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.FilteredBoardIssuesQueryBuilderAdapterPremium;
import org.squashtest.tm.plugin.xsquash4gitlab.adapter.PagingAdapter;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.dto.GitLabNamedReferenceDto;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabConverters;
import org.squashtest.tm.plugin.xsquash4gitlab.converter.GitLabIssueConverter;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabBoardScope;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabInstanceType;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabWildcardGlobalId;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GraphqlClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetBoardListIssuesCommunityQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.GetBoardListIssuesQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.IsEnterpriseEditionQuery;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.IterationWildcardId;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.MilestoneWildcardId;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.generated.type.WeightWildcardId;
import xsquash4gitlab.com.apollographql.apollo.api.Operation;
import xsquash4gitlab.com.apollographql.apollo.api.Query;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;
import xsquash4gitlab.org.jetbrains.annotations.Nullable;

public abstract class AbstractGitLabClient {
    protected static final int DEFAULT_PAGE_SIZE = 100;
    protected static final Collection<GitLabWildcardGlobalId<MilestoneWildcardId>> MILESTONE_WILDCARD_GLOBAL_IDS = Arrays.asList(GitLabWildcardGlobalId.of("gid://gitlab/Milestone/0", MilestoneWildcardId.NONE), GitLabWildcardGlobalId.of("gid://gitlab/Milestone/-1", MilestoneWildcardId.ANY), GitLabWildcardGlobalId.of("gid://gitlab/Milestone/-2", MilestoneWildcardId.UPCOMING), GitLabWildcardGlobalId.of("gid://gitlab/Milestone/-3", MilestoneWildcardId.STARTED));
    protected static final Collection<GitLabWildcardGlobalId<IterationWildcardId>> ITERATION_WILDCARD_GLOBAL_IDS = Arrays.asList(GitLabWildcardGlobalId.of("gid://gitlab/Iteration/0", IterationWildcardId.NONE), GitLabWildcardGlobalId.of("gid://gitlab/Iteration/-4", IterationWildcardId.CURRENT));
    protected static final Map<Integer, WeightWildcardId> WEIGHT_SPECIAL_VALUES = new HashMap<Integer, WeightWildcardId>();
    protected GitLabClient gitLabClient;

    static {
        WEIGHT_SPECIAL_VALUES.put(-1, WeightWildcardId.ANY);
        WEIGHT_SPECIAL_VALUES.put(-2, WeightWildcardId.NONE);
    }

    protected AbstractGitLabClient(GitLabClient baseClient) {
        this.gitLabClient = baseClient;
    }

    public boolean isInstanceEnterpriseEdition() {
        IsEnterpriseEditionQuery.Builder queryBuilder = IsEnterpriseEditionQuery.builder();
        Optional isEnterpriseEdition = this.gitLabClient.executeAndConvert(queryBuilder.build(), GitLabConverters::extractIsEnterpriseEdition);
        return (Boolean)isEnterpriseEdition.orElseThrow(() -> new RuntimeException("Could not retrieve gitlab server metadata"));
    }

    protected boolean isIterationWildcardGlobalId(String candidate) {
        return ITERATION_WILDCARD_GLOBAL_IDS.stream().anyMatch(wildcardGlobalId -> wildcardGlobalId.globalId.equals(candidate));
    }

    protected IterationWildcardId asIterationWildcardValue(String candidate) {
        return ITERATION_WILDCARD_GLOBAL_IDS.stream().filter(wildcardGlobalId -> wildcardGlobalId.globalId.equals(candidate)).findAny().map(wildcardGlobalId -> (IterationWildcardId)((Object)((Object)wildcardGlobalId.wildcardValue))).orElseThrow(() -> GitLabConverters.exception("Could not extract iteration wildcard value from " + candidate));
    }

    protected boolean isMilestoneWildcardGlobalId(String candidate) {
        return MILESTONE_WILDCARD_GLOBAL_IDS.stream().anyMatch(wildcardGlobalId -> wildcardGlobalId.globalId.equals(candidate));
    }

    protected MilestoneWildcardId asMilestoneWildcardValue(String candidate) {
        return MILESTONE_WILDCARD_GLOBAL_IDS.stream().filter(wildcardGlobalId -> wildcardGlobalId.globalId.equals(candidate)).findAny().map(wildcardGlobalId -> (MilestoneWildcardId)((Object)((Object)wildcardGlobalId.wildcardValue))).orElseThrow(() -> GitLabConverters.exception("Could not extract milestone wildcard value from " + candidate));
    }

    protected <B> B getFilteredBoardIssuesQueryBuilderPremium(String perimeter, String boardId, GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builderAdapter) {
        builderAdapter.fullPath(perimeter);
        builderAdapter.boardId(boardId);
        this.appendGitLabBoardScopeFiltersPremium(scope, builderAdapter);
        return builderAdapter.getBuilder();
    }

    protected <B> B getFilteredBoardIssuesQueryBuilderCommunity(String perimeter, String boardId, FilteredBoardIssuesQueryBuilderAdapterCommunity<B> builderAdapter) {
        builderAdapter.fullPath(perimeter);
        builderAdapter.boardId(boardId);
        return builderAdapter.getBuilder();
    }

    protected <D extends Operation.Data, T, V extends Operation.Variables> List<GitLabIssue> getBoardIssuesAndMergeWithNextPages(GitLabBoardScope scope, Query<D, T, V> query, GraphqlClient.Converter<T, GitLabIssueConverter.BoardIssuesFirstPageResult> converter, GitLabInstanceType instanceType) {
        GitLabIssueConverter.BoardIssuesFirstPageResult firstPageIssues = this.gitLabClient.executeAndConvert(query, converter);
        ArrayList<GitLabIssue> allIssues = new ArrayList<GitLabIssue>(firstPageIssues.gitLabIssues);
        if (!allIssues.isEmpty()) {
            this.appendNextBoardListIssues(scope, firstPageIssues, allIssues, instanceType);
        }
        return allIssues;
    }

    private void appendNextBoardListIssues(GitLabBoardScope scope, GitLabIssueConverter.BoardIssuesFirstPageResult firstPageIssues, List<GitLabIssue> allIssues, GitLabInstanceType instanceType) {
        String issuePath = firstPageIssues.gitLabIssues.get(0).getPath();
        firstPageIssues.endCursorByBoardListId.forEach((boardListId, endCursor) -> endCursor.ifPresent(afterCursor -> {
            boolean bl = allIssues.addAll(this.getBoardListIssues(scope, (String)boardListId, (String)afterCursor, issuePath, instanceType));
        }));
    }

    private List<GitLabIssue> getBoardListIssues(GitLabBoardScope scope, String boardListId, String afterCursor, String issuePath, GitLabInstanceType instanceType) {
        if (GitLabInstanceType.PREMIUM.equals((Object)instanceType)) {
            FilteredBoardIssuesQueryBuilderAdapterPremium.BoardListBuilderAdapterPremium builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterPremium.BoardListBuilderAdapterPremium();
            builderAdapter.getBuilder().boardListId(boardListId);
            this.appendGitLabBoardScopeFiltersPremium(scope, builderAdapter);
            GetBoardListIssuesQuery.Builder queryBuilder = builderAdapter.getBuilder();
            PagingAdapter.GetBoardListIssuesPagingAdapterPremium pagingAdapter = new PagingAdapter.GetBoardListIssuesPagingAdapterPremium(queryBuilder);
            return this.gitLabClient.executeAndConvertAllPagesAfter(100, pagingAdapter, GitLabIssueConverter::convertBoardListIssuesPremium, afterCursor).stream().flatMap(Collection::stream).map(issue -> issue.withPath(issuePath)).collect(Collectors.toList());
        }
        FilteredBoardIssuesQueryBuilderAdapterCommunity.BoardListBuilderAdapterCommunity builderAdapter = new FilteredBoardIssuesQueryBuilderAdapterCommunity.BoardListBuilderAdapterCommunity();
        builderAdapter.getBuilder().boardListId(boardListId);
        GetBoardListIssuesCommunityQuery.Builder queryBuilder = builderAdapter.getBuilder();
        PagingAdapter.GetBoardListIssuesPagingAdapterCommunity pagingAdapter = new PagingAdapter.GetBoardListIssuesPagingAdapterCommunity(queryBuilder);
        return this.gitLabClient.executeAndConvertAllPagesAfter(100, pagingAdapter, GitLabIssueConverter::convertBoardListIssuesCommunity, afterCursor).stream().flatMap(Collection::stream).map(issue -> issue.withPath(issuePath)).collect(Collectors.toList());
    }

    private <B> void appendGitLabBoardScopeFiltersPremium(GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builder) {
        this.appendBoardAssigneeFilterPremium(scope, builder);
        this.appendBoardIterationFilterPremium(scope, builder);
        this.appendBoardMilestoneFilterPremium(scope, builder);
        this.appendBoardLabelsFilterPremium(scope, builder);
        this.appendWeightFilterPremium(scope, builder);
    }

    private <B> void appendBoardAssigneeFilterPremium(GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builder) {
        GitLabNamedReferenceDto assignee = scope.getAssignee();
        if (assignee != null) {
            builder.assigneeUsername(Collections.singletonList(scope.getAssignee().getId()));
        }
    }

    private <B> void appendBoardIterationFilterPremium(GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builder) {
        GitLabNamedReferenceDto iteration = scope.getIteration();
        if (iteration == null) {
            return;
        }
        String iterationId = iteration.getId();
        if (this.isIterationWildcardGlobalId(iterationId)) {
            builder.iterationWildcardId(this.asIterationWildcardValue(iterationId));
        } else {
            builder.iterationIds(Collections.singletonList(iterationId));
        }
    }

    private <B> void appendBoardMilestoneFilterPremium(GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builder) {
        GitLabNamedReferenceDto milestone = scope.getMilestone();
        if (milestone == null) {
            return;
        }
        String milestoneId = milestone.getId();
        if (this.isMilestoneWildcardGlobalId(milestoneId)) {
            if (this.asMilestoneWildcardValue(milestoneId).equals((Object)MilestoneWildcardId.ANY)) {
                return;
            }
            builder.milestoneWildcardId(this.asMilestoneWildcardValue(milestoneId));
        } else {
            builder.milestoneTitle(milestone.getTitle());
        }
    }

    private <B> void appendBoardLabelsFilterPremium(GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builder) {
        builder.labelName(scope.getLabels().stream().map(GitLabNamedReferenceDto::getTitle).collect(Collectors.toList()));
    }

    private <B> void appendWeightFilterPremium(GitLabBoardScope scope, FilteredBoardIssuesQueryBuilderAdapterPremium<B> builder) {
        if (scope.getWeight() != null) {
            if (WEIGHT_SPECIAL_VALUES.containsKey(scope.getWeight())) {
                if (WEIGHT_SPECIAL_VALUES.get(scope.getWeight()).equals((Object)WeightWildcardId.ANY)) {
                    return;
                }
                builder.weightWildcardId(WEIGHT_SPECIAL_VALUES.get(scope.getWeight()));
            } else {
                builder.weight(scope.getWeight().toString());
            }
        }
    }

    protected <T> List<T> flattened(@Nullable Collection<List<T>> input) {
        if (input == null) {
            return null;
        }
        if (this.isOneSizedNullCollection(input)) {
            return null;
        }
        if (this.containsNull(input)) {
            throw new IllegalArgumentException("Input cannot be flattened because the collection contains null.");
        }
        return this.doFlatten(input);
    }

    @NotNull
    private <T> List<T> doFlatten(@NotNull Collection<List<T>> input) {
        return input.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private <T> boolean containsNull(@NotNull Collection<List<T>> input) {
        return input.stream().anyMatch(Objects::isNull);
    }

    private <T> boolean isOneSizedNullCollection(@NotNull Collection<List<T>> input) {
        return input.size() == 1 && input.stream().allMatch(Objects::isNull);
    }
}

