/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;

public class UserConfiguration {
    private List<FieldMapping> fieldMappings = FieldMapping.getLockedBuiltinMapping();
    private String yamlFieldValueMapping = "";
    private boolean isTestReportingEnabled = false;

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(List<FieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    public boolean hasFieldMapping(String squashField) {
        return this.fieldMappings.stream().map(FieldMapping::getSquashField).filter(Objects::nonNull).anyMatch(mappedSquashField -> mappedSquashField.equals(squashField));
    }

    public boolean hasFieldMapping(FieldMapping mapping) {
        return this.fieldMappings.contains(mapping);
    }

    public void addFieldMapping(FieldMapping mapping) {
        Optional<String> defaultGitLabValue = FieldMapping.getBuiltinMappingGitLabField(mapping.getId());
        if (mapping.getGitLabField().isBlank() && defaultGitLabValue.isPresent()) {
            mapping.setGitLabField(defaultGitLabValue.get());
        }
        this.fieldMappings.add(mapping);
    }

    public FieldMapping getFieldMapping(String id) {
        for (FieldMapping m : this.fieldMappings) {
            if (!m.getId().equals(id)) continue;
            return m;
        }
        return null;
    }

    public void removeFieldMapping(FieldMapping mapping) {
        this.fieldMappings.remove(mapping);
    }

    public String getYamlFieldValueMapping() {
        return this.yamlFieldValueMapping != null ? this.yamlFieldValueMapping : "";
    }

    public void setYamlFieldValueMapping(String yamlFieldValueMapping) {
        this.yamlFieldValueMapping = yamlFieldValueMapping;
    }

    @JsonProperty(value="isTestReportingEnabled")
    public boolean isTestReportingEnabled() {
        return this.isTestReportingEnabled;
    }

    public void setTestReportingEnabled(boolean testReportingEnabled) {
        this.isTestReportingEnabled = testReportingEnabled;
    }
}

