/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab;

import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.template.TemplateConfigurablePlugin;
import org.squashtest.tm.api.wizard.InternationalizedWorkspaceWizard;
import org.squashtest.tm.api.wizard.SupervisionScreenData;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.xsquash4gitlab.concurrency.SynchronisedSectionWrapper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.SynchronisationService;

public class Xsquash4GitLabPlugin
extends InternationalizedWorkspaceWizard
implements SynchronisationPlugin,
TemplateConfigurablePlugin {
    public static final String PLUGIN_ID = "squash.tm.plugin.xsquash4gitlab";
    public static final String PLUGIN_NAME = "xsquash4gitlab";
    private static final String CONF_URL_TEMPLATE = "plugin/xsquash4gitlab/configuration/project/{projectId}";
    private static final String TEMPLATE_URL_PARAMS = "?template=true";
    private final SynchronisationService synchronisationService;
    private final SynchronisedSectionWrapper synchronisedSectionWrapper;
    private final ConfigurationService configurationService;

    public Xsquash4GitLabPlugin(SynchronisationService synchronisationService, SynchronisedSectionWrapper synchronisedSectionWrapper, ConfigurationService configurationService) {
        this.synchronisationService = synchronisationService;
        this.synchronisedSectionWrapper = synchronisedSectionWrapper;
        this.configurationService = configurationService;
    }

    public WorkspaceType getConfiguringWorkspace() {
        return WorkspaceType.REQUIREMENT_WORKSPACE;
    }

    public void validate(EntityReference reference) throws PluginValidationException {
    }

    public String getConfigurationPath(EntityReference context) {
        Long id = context.getId();
        return CONF_URL_TEMPLATE.replace("{projectId}", id.toString());
    }

    public Runnable performSynchronisation() {
        return new DelegatingSecurityContextRunnable(this.synchronisedSectionWrapper.wrapAsSynchronisedSection(this.synchronisationService::performSynchronisation));
    }

    public SupervisionScreenData getSupervisionScreenData() {
        SupervisionScreenData data = SupervisionScreenData.withNoAdditionalColumn();
        data.setHasPerimeterColumn(true);
        data.setHasSyncNameColumn(true);
        data.setHasSynchronizedRequirementsRatioColumn(true);
        data.setHasSynchronizedSprintTicketsRatioColumn(true);
        return data;
    }

    public String getSyncErrorLogPath(Long syncId) {
        return this.synchronisationService.getSyncErrorLogPath(syncId);
    }

    public String getTemplateConfigurationPath(EntityReference context) {
        return String.valueOf(this.getConfigurationPath(context)) + TEMPLATE_URL_PARAMS;
    }

    public void synchroniseTemplateConfiguration(Long templateId, Long targetProjectId) {
        this.configurationService.synchronizeTemplateConfiguration(templateId, targetProjectId);
    }
}

