/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis.internal.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssueReportForm;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchRequest;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.CredentialHolder;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.MantisClient;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Issue;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.MantisFile;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.MantisFiles;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.Project;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.ProjectCustomField;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisIssueResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.client.model.response.MantisIssuesResponse;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.advancedissue.MantisAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.advancedissue.customfields.defaultvalue.setter.DefaultValueSetter;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.advancedissue.customfields.defaultvalue.setter.factory.DefaultFieldValueSetterFactory;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.mantisissue.SquashToMantisIssueConverter;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.domain.project.customfields.SchemeBuilder;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.service.MantisProjectService;
import org.squashtest.tm.plugin.bugtracker.mantis.internal.service.MantisService;

@Service(value="squash.tm.plugin.bugtracker.mantis.MantisServiceImpl")
public class MantisServiceImpl
implements MantisService {
    private static final String PRIORITY_VALUE = "interface.table.severity.value.";
    private static final String STATUS_VALUE = "interface.table.status.value.";
    private static final Logger LOGGER = LoggerFactory.getLogger(MantisServiceImpl.class);
    private static final String ISSUE_ID = "key";
    private final MantisClient mantisClient;
    private final SchemeBuilder schemeBuilder;
    private final ExceptionHandler exceptionHandler;
    private final MantisProjectService projectService;
    private final MessageSource messageSource;
    private final DefaultFieldValueSetterFactory factory = new DefaultFieldValueSetterFactory();

    public MantisServiceImpl(MantisClient mantisClient, ExceptionHandler exceptionHandler, SchemeBuilder schemeBuilder, MantisProjectService projectService, @Named(value="mantisConnectorMessageSource") @Named(value="mantisConnectorMessageSource") MessageSource messageSource) {
        this.mantisClient = mantisClient;
        this.schemeBuilder = schemeBuilder;
        this.exceptionHandler = exceptionHandler;
        this.projectService = projectService;
        this.messageSource = messageSource;
    }

    @Override
    public void init(BugTracker bugtracker, CredentialHolder credentialHolder) {
        this.checkEmptyCredentials(credentialHolder);
        this.mantisClient.init(bugtracker, credentialHolder);
    }

    @Override
    public List<AdvancedIssue> findKnownIssues(List<String> issueKeys, CredentialHolder credentialHolder) {
        ArrayList<AdvancedIssue> advancedIssues = new ArrayList<AdvancedIssue>();
        issueKeys.forEach(issueKey -> {
            boolean bl = advancedIssues.add(this.findSingleIssue(credentialHolder, (String)issueKey));
        });
        return advancedIssues;
    }

    private AdvancedIssue searchSingleIssue(CredentialHolder credentialHolder, String issueKey) {
        try {
            return this.searchIssue(credentialHolder, issueKey);
        }
        catch (Exception e) {
            LOGGER.error("Encountered exception while searching issue", (Throwable)e);
            throw this.exceptionHandler.issueNotFound(issueKey);
        }
    }

    private AdvancedIssue findSingleIssue(CredentialHolder credentialHolder, String issueKey) {
        try {
            return this.searchIssue(credentialHolder, issueKey);
        }
        catch (Exception e) {
            LOGGER.error("Encountered exception while fetching issue", (Throwable)e);
            return this.unknownIssue(issueKey);
        }
    }

    private AdvancedIssue unknownIssue(String issueKey) {
        AdvancedProject missingProject = new AdvancedProject();
        missingProject.setName("-");
        MantisAdvancedIssue missingIssue = new MantisAdvancedIssue();
        missingIssue.setId(issueKey);
        missingIssue.setProject(missingProject);
        missingIssue.setSummary(this.messageSource.getMessage("interface.table.missing-issue.label", null, LocaleContextHolder.getLocale()));
        missingIssue.setFieldValue("priority", new FieldValue(null, null));
        missingIssue.setFieldValue("assignee", new FieldValue(null, null));
        return missingIssue;
    }

    private AdvancedIssue searchIssue(CredentialHolder credentialHolder, String issueKey) {
        Long issueId = Long.parseLong(issueKey);
        MantisIssuesResponse issues = this.mantisClient.findIssues(issueId, credentialHolder);
        if (issues.getIssues().isEmpty()) {
            throw this.exceptionHandler.issueNotFound(issueKey);
        }
        Issue issue = issues.getIssues().get(0);
        AdvancedProject advancedProject = this.projectService.searchProjectById(issue.getProject().getId(), credentialHolder, this.mantisClient);
        return this.convertIssueToAdvancedIssue(issue, advancedProject);
    }

    @Override
    public Optional<AdvancedIssue> searchIssue(RemoteIssueSearchRequest searchRequest, CredentialHolder credentialHolder) {
        if (searchRequest.hasSearchTerm(ISSUE_ID)) {
            String issueId = searchRequest.getSearchTermStringValue(ISSUE_ID);
            return Optional.of(this.searchSingleIssue(credentialHolder, issueId));
        }
        throw new IllegalArgumentException(String.format("The search terms should contain %s.", ISSUE_ID));
    }

    @Override
    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context, CredentialHolder credentialHolder, BugTracker bugTracker) {
        Project project = this.projectService.findProjectByName(projectName, credentialHolder, this.mantisClient);
        AdvancedProject advancedProject = this.projectService.convertProjectToAdvancedProject(project, credentialHolder, this.mantisClient);
        AdvancedIssueReportForm advancedIssue = new AdvancedIssueReportForm();
        advancedIssue.setBugtracker(bugTracker.getName());
        advancedIssue.setProject(advancedProject);
        advancedIssue.setCurrentScheme("Issue");
        advancedIssue.setRemoteIssueContext(context);
        this.appendDefaultValues(project, (AdvancedIssue)advancedIssue, context);
        return advancedIssue;
    }

    @Override
    public AdvancedIssue createIssue(RemoteIssue remoteIssue, CredentialHolder credentialHolder) {
        if (!(remoteIssue instanceof AdvancedIssue)) {
            throw new RuntimeException("Expected AdvancedIssue");
        }
        AdvancedIssue advancedIssue = (AdvancedIssue)remoteIssue;
        Project currentProject = this.projectService.findProjectById(advancedIssue.getProject().getId(), credentialHolder, this.mantisClient);
        Issue requestIssue = SquashToMantisIssueConverter.convert(advancedIssue, currentProject);
        MantisIssueResponse response = this.mantisClient.createIssue(requestIssue, credentialHolder);
        Issue responseIssue = response.getIssue();
        return this.convertIssueToAdvancedIssue(responseIssue, advancedIssue.getProject());
    }

    @Override
    public void forwardAttachments(String issueKey, List<Attachment> attachments, CredentialHolder credentialHolder) {
        ArrayList<MantisFile> files = new ArrayList<MantisFile>();
        try {
            for (Attachment attachment : attachments) {
                byte[] bytes = IOUtils.toByteArray((InputStream)attachment.getStreamContent());
                String content = Base64.getEncoder().encodeToString(bytes);
                MantisFile file = new MantisFile(attachment.getName(), content);
                files.add(file);
            }
            MantisFiles mantisFiles = new MantisFiles();
            mantisFiles.setFiles(files);
            this.mantisClient.uploadFiles(issueKey, mantisFiles, credentialHolder);
        }
        catch (Exception exception) {
            throw this.exceptionHandler.cantUploadFiles();
        }
    }

    private AdvancedIssue convertIssueToAdvancedIssue(Issue issue, AdvancedProject advancedProject) {
        MantisAdvancedIssue advancedIssue = MantisAdvancedIssue.from(this.createAdvancedIssueReportForm(advancedProject));
        advancedIssue.setId(issue.getId());
        advancedIssue.setSummary(issue.getSummary());
        advancedIssue.setDescription(issue.getDescription());
        this.setAdvancedIssueFieldValueFromIssue(issue, advancedIssue);
        return advancedIssue;
    }

    private void setAdvancedIssueFieldValueFromIssue(Issue issue, MantisAdvancedIssue advancedIssue) {
        advancedIssue.setFieldValue("assignee", issue.getHandler() != null ? new FieldValue(issue.getHandler().getId(), issue.getHandler().getName()) : new FieldValue("", ""));
        advancedIssue.setFieldValue("priority", new FieldValue(issue.getSeverity().getId(), this.schemeBuilder.translateFieldName(PRIORITY_VALUE, issue.getSeverity().getName(), issue.getSeverity().getLabel())));
        advancedIssue.setFieldValue("status", new FieldValue(issue.getStatus().getId(), this.schemeBuilder.translateFieldName(STATUS_VALUE, issue.getStatus().getName(), issue.getStatus().getLabel())));
    }

    private AdvancedIssueReportForm createAdvancedIssueReportForm(AdvancedProject project) {
        AdvancedIssueReportForm advancedIssue = new AdvancedIssueReportForm();
        advancedIssue.setProject(project);
        advancedIssue.setCurrentScheme("Issue");
        return advancedIssue;
    }

    private void checkEmptyCredentials(CredentialHolder credentialHolder) {
        LOGGER.info("Checking if credentials are empty...");
        if (credentialHolder == null) {
            LOGGER.info("Credential holder is empty.");
            throw new NullArgumentException("credentials");
        }
        if (credentialHolder.getCredentials().getToken().isEmpty()) {
            LOGGER.info("Token is empty!!");
            throw new NullArgumentException("token");
        }
        LOGGER.info("Credentials checking is finished successfully");
    }

    private void appendDefaultValues(Project project, AdvancedIssue issue, RemoteIssueContext context) {
        String stepsToReproduceScalar = context != null ? context.getDefaultDescription() : "";
        issue.setFieldValue("stepsToReproduce", new FieldValue(null, stepsToReproduceScalar));
        issue.setFieldValue("description", new FieldValue(null, ""));
        project.getCustomFields().forEach(field -> {
            DefaultValueSetter setter = this.factory.get(field.getType());
            setter.setDefaultValue((ProjectCustomField)field, issue);
        });
    }
}

