/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.mantis;

import java.util.Locale;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;

@Component
public class MantisBugtrackerConnectorInterfaceDescriptor
implements BugTrackerInterfaceDescriptor {
    private static final String REPORT_PRIORITY_LABEL = "interface.report.priority.label";
    private static final String REPORT_SEVERITY_LABEL = "interface.report.severity.label";
    private static final String REPORT_VERSION_LABEL = "interface.report.version.label";
    private static final String REPORT_ASSIGNEE_LABEL = "interface.report.assignee.label";
    private static final String REPORT_CATEGORY_LABEL = "interface.report.category.label";
    private static final String REPORT_SUMMARY_LABEL = "interface.report.summary.label";
    private static final String REPORT_DESCRIPTION_LABEL = "interface.report.description.label";
    private static final String REPORT_COMMENT_LABEL = "interface.report.comment.label";
    private static final String REPORT_EMPTY_VERSION = "interface.report.lists.emptyversion.label";
    private static final String REPORT_EMPTY_CATEGORY = "interface.report.lists.emptycategory.label";
    private static final String REPORT_EMPTY_ASSIGNEE = "interface.report.lists.emptyassignee.label";
    private static final String TABLE_ISSUE_ID_HEADER = "interface.table.issueid.header";
    private static final String TABLE_SUMMARY_HEADER = "interface.table.summary.header";
    private static final String TABLE_PRIORITY_HEADER = "interface.table.priority.header";
    private static final String TABLE_STATUS_HEADER = "interface.table.status.header";
    private static final String TABLE_ASSIGNEE_HEADER = "interface.table.assignee.header";
    private static final String TABLE_REPORTED_IN_HEADER = "interface.table.reportedin.header";
    private static final String TABLE_DESCRIPTION_HEADER = "interface.table.description.header";
    private static final String TABLE_EMPTY_ASSIGNEE = "interface.table.null.assignee.label";
    private Locale locale;
    private final MessageSource messageSource;

    public MantisBugtrackerConnectorInterfaceDescriptor(@Named(value="mantisConnectorMessageSource") @Named(value="mantisConnectorMessageSource") MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getSupportsRichDescription() {
        return false;
    }

    public boolean getSupportsRichComment() {
        return false;
    }

    public String getReportPriorityLabel() {
        return this.messageSource.getMessage(REPORT_PRIORITY_LABEL, null, this.getLocale());
    }

    public String getReportSeverityLabel() {
        return this.messageSource.getMessage(REPORT_SEVERITY_LABEL, null, this.getLocale());
    }

    public String getReportVersionLabel() {
        return this.messageSource.getMessage(REPORT_VERSION_LABEL, null, this.getLocale());
    }

    public String getReportAssigneeLabel() {
        return this.messageSource.getMessage(REPORT_ASSIGNEE_LABEL, null, this.getLocale());
    }

    public String getReportCategoryLabel() {
        return this.messageSource.getMessage(REPORT_CATEGORY_LABEL, null, this.getLocale());
    }

    public String getReportSummaryLabel() {
        return this.messageSource.getMessage(REPORT_SUMMARY_LABEL, null, this.getLocale());
    }

    public String getReportDescriptionLabel() {
        return this.messageSource.getMessage(REPORT_DESCRIPTION_LABEL, null, this.getLocale());
    }

    public String getReportCommentLabel() {
        return this.messageSource.getMessage(REPORT_COMMENT_LABEL, null, this.getLocale());
    }

    public String getEmptyVersionListLabel() {
        return this.messageSource.getMessage(REPORT_EMPTY_VERSION, null, this.getLocale());
    }

    public String getEmptyCategoryListLabel() {
        return this.messageSource.getMessage(REPORT_EMPTY_CATEGORY, null, this.getLocale());
    }

    public String getEmptyAssigneeListLabel() {
        return this.messageSource.getMessage(REPORT_EMPTY_ASSIGNEE, null, this.getLocale());
    }

    public String getTableIssueIDHeader() {
        return this.messageSource.getMessage(TABLE_ISSUE_ID_HEADER, null, this.getLocale());
    }

    public String getTableSummaryHeader() {
        return this.messageSource.getMessage(TABLE_SUMMARY_HEADER, null, this.getLocale());
    }

    public String getTablePriorityHeader() {
        return this.messageSource.getMessage(TABLE_PRIORITY_HEADER, null, this.getLocale());
    }

    public String getTableStatusHeader() {
        return this.messageSource.getMessage(TABLE_STATUS_HEADER, null, this.getLocale());
    }

    public String getTableDescriptionHeader() {
        return this.messageSource.getMessage(TABLE_DESCRIPTION_HEADER, null, this.getLocale());
    }

    public String getTableAssigneeHeader() {
        return this.messageSource.getMessage(TABLE_ASSIGNEE_HEADER, null, this.getLocale());
    }

    public String getTableReportedInHeader() {
        return this.messageSource.getMessage(TABLE_REPORTED_IN_HEADER, null, this.getLocale());
    }

    public String getTableNoAssigneeLabel() {
        return this.messageSource.getMessage(TABLE_EMPTY_ASSIGNEE, null, this.getLocale());
    }
}

