/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.service;

import gitlabbt.com.fasterxml.jackson.core.type.TypeReference;
import gitlabbt.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.plugin.bugtracker.gitlab.GitLabConfigurablePlugin;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@Service
@Transactional
public class ConfigurationDao {
    private final GenericProjectManagerService projectManager;

    public ConfigurationDao(GenericProjectManagerService projectManager) {
        this.projectManager = projectManager;
    }

    public PersistedConfiguration loadOrGetDefaultConfiguration(Long projectId) {
        Map<String, String> rawConfiguration = this.getRawConfiguration(projectId);
        if (rawConfiguration == null || rawConfiguration.isEmpty()) {
            return PersistedConfiguration.withDefaultConfiguration();
        }
        try {
            return PersistedConfiguration.fromRawMap(rawConfiguration);
        }
        catch (IOException e) {
            throw new BugTrackerLocalException("Cannot load configuration for project " + projectId, (Throwable)e);
        }
    }

    public void saveConfiguration(Long projectId, PersistedConfiguration persistedConfiguration) throws IOException {
        if (persistedConfiguration.hasConfiguredMappings()) {
            this.projectManager.setPluginConfiguration(projectId.longValue(), GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker", persistedConfiguration.asRawMap());
        } else {
            this.projectManager.setPluginConfiguration(projectId.longValue(), GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker", null);
        }
    }

    private Map<String, String> getRawConfiguration(Long projectId) {
        return this.projectManager.getPluginConfigurationWithoutCheck(projectId.longValue(), GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker");
    }

    public void updateDisplayState(long projectId, boolean newValue) {
        try {
            PersistedConfiguration configuration = this.loadOrGetDefaultConfiguration(projectId);
            configuration.setDisplayState(newValue);
            this.projectManager.setPluginConfiguration(projectId, GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker", configuration.asRawMap());
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException("Could not load configuration for project " + projectId, (Throwable)ex);
        }
    }

    public static final class PersistedConfiguration {
        private static final String MAPPINGS_KEY = "mappings";
        public static final String DISPLAY_STATE_KEY = "gitLabDisplayState";
        private final Map<String, Mappings> mappingsByProjectPath;
        private boolean displayState;

        public PersistedConfiguration(Map<String, Mappings> mappings, boolean displayState) {
            this.displayState = displayState;
            Objects.requireNonNull(mappings);
            this.mappingsByProjectPath = new HashMap<String, Mappings>(mappings);
        }

        public static PersistedConfiguration withDefaultConfiguration() {
            return new PersistedConfiguration(new HashMap<String, Mappings>(), true);
        }

        public Map<String, Mappings> getMappings() {
            return this.mappingsByProjectPath;
        }

        public boolean isDisplayState() {
            return this.displayState;
        }

        public void setDisplayState(boolean displayState) {
            this.displayState = displayState;
        }

        public boolean hasConfiguredMappings() {
            return this.mappingsByProjectPath.values().stream().anyMatch(mappings -> !Mappings.isEmpty(mappings));
        }

        public Map<String, String> asRawMap() throws IOException {
            String jsonMappings = new ObjectMapper().writeValueAsString(this.mappingsByProjectPath);
            HashMap<String, String> finalMap = new HashMap<String, String>();
            finalMap.put(MAPPINGS_KEY, jsonMappings);
            finalMap.put(DISPLAY_STATE_KEY, String.valueOf(this.isDisplayState()));
            return finalMap;
        }

        public static PersistedConfiguration fromRawMap(Map<String, String> rawConfiguration) throws IOException {
            Map mappings = rawConfiguration.containsKey(MAPPINGS_KEY) ? (Map)new ObjectMapper().readValue(rawConfiguration.get(MAPPINGS_KEY), new TypeReference<HashMap<String, Mappings>>(){}) : new HashMap();
            boolean displayState = rawConfiguration.containsKey(DISPLAY_STATE_KEY) ? new ObjectMapper().readValue(rawConfiguration.get(DISPLAY_STATE_KEY), Boolean.class) : true;
            return new PersistedConfiguration(mappings, displayState);
        }
    }

    public static final class Mappings {
        private final List<String> propertyScopes;
        private final List<String> propertyLabels;
        private final List<String> statusScopes;
        private final List<String> statusLabels;

        public Mappings(List<String> propertyScopes, List<String> propertyLabels, List<String> statusScopes, List<String> statusLabels) {
            this.propertyScopes = propertyScopes;
            this.propertyLabels = propertyLabels;
            this.statusScopes = statusScopes;
            this.statusLabels = statusLabels;
        }

        public static Mappings empty() {
            return new Mappings(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }

        public Mappings withPropertyScopes(List<String> propertyScopes) {
            return new Mappings(propertyScopes, this.propertyLabels, this.statusScopes, this.statusLabels);
        }

        public Mappings withPropertyLabels(List<String> propertyLabels) {
            return new Mappings(this.propertyScopes, propertyLabels, this.statusScopes, this.statusLabels);
        }

        public Mappings withStatusScopes(List<String> statusScopes) {
            return new Mappings(this.propertyScopes, this.propertyLabels, statusScopes, this.statusLabels);
        }

        public Mappings withStatusLabels(List<String> statusLabels) {
            return new Mappings(this.propertyScopes, this.propertyLabels, this.statusScopes, statusLabels);
        }

        public List<String> getPropertyScopes() {
            return this.propertyScopes;
        }

        public List<String> getPropertyLabels() {
            return this.propertyLabels;
        }

        public List<String> getStatusScopes() {
            return this.statusScopes;
        }

        public List<String> getStatusLabels() {
            return this.statusLabels;
        }

        public static boolean isEmpty(Mappings mappings) {
            return mappings.propertyLabels.isEmpty() && mappings.propertyScopes.isEmpty() && mappings.statusLabels.isEmpty() && mappings.statusScopes.isEmpty();
        }

        public Mappings() {
            this.propertyLabels = Collections.emptyList();
            this.propertyScopes = Collections.emptyList();
            this.statusLabels = Collections.emptyList();
            this.statusScopes = Collections.emptyList();
        }
    }
}

