/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.configuration;

import java.util.List;
import java.util.Map;
import org.squashtest.tm.plugin.bugtracker.gitlab.configuration.ProjectMappings;
import org.squashtest.tm.service.internal.display.dto.BugTrackerDto;

public class ConfigurationPage {
    private final Long projectId;
    private final List<String> linkedProjectPaths;
    private final Map<String, ProjectMappings> configuredMappings;
    private final Map<String, AvailableLabels> availableLabels;
    private final boolean authenticationRequired;
    private final BugTrackerDto bugTracker;
    private final boolean displayState;

    public ConfigurationPage() {
        this.projectId = null;
        this.linkedProjectPaths = null;
        this.configuredMappings = null;
        this.availableLabels = null;
        this.authenticationRequired = false;
        this.bugTracker = null;
        this.displayState = true;
    }

    public ConfigurationPage(Long projectId, List<String> linkedProjectPaths, Map<String, ProjectMappings> configuredMappings, Map<String, AvailableLabels> availableLabels, boolean authenticationRequired, BugTrackerDto bugTracker, boolean displayState) {
        this.projectId = projectId;
        this.linkedProjectPaths = linkedProjectPaths;
        this.configuredMappings = configuredMappings;
        this.availableLabels = availableLabels;
        this.authenticationRequired = authenticationRequired;
        this.bugTracker = bugTracker;
        this.displayState = displayState;
    }

    public ConfigurationPage withProjectId(Long projectId) {
        return new ConfigurationPage(projectId, this.linkedProjectPaths, this.configuredMappings, this.availableLabels, this.authenticationRequired, this.bugTracker, this.displayState);
    }

    public ConfigurationPage withLinkedProjectPaths(List<String> linkedProjectPaths) {
        return new ConfigurationPage(this.projectId, linkedProjectPaths, this.configuredMappings, this.availableLabels, this.authenticationRequired, this.bugTracker, this.displayState);
    }

    public ConfigurationPage withMappings(Map<String, ProjectMappings> configuredMappings) {
        return new ConfigurationPage(this.projectId, this.linkedProjectPaths, configuredMappings, this.availableLabels, this.authenticationRequired, this.bugTracker, this.displayState);
    }

    public ConfigurationPage withAvailableLabels(Map<String, AvailableLabels> availableLabels) {
        return new ConfigurationPage(this.projectId, this.linkedProjectPaths, this.configuredMappings, availableLabels, this.authenticationRequired, this.bugTracker, this.displayState);
    }

    public ConfigurationPage withAuthenticationRequired(boolean authenticationRequired) {
        return new ConfigurationPage(this.projectId, this.linkedProjectPaths, this.configuredMappings, this.availableLabels, authenticationRequired, this.bugTracker, this.displayState);
    }

    public ConfigurationPage withBugTracker(BugTrackerDto bugTracker) {
        return new ConfigurationPage(this.projectId, this.linkedProjectPaths, this.configuredMappings, this.availableLabels, this.authenticationRequired, bugTracker, this.displayState);
    }

    public ConfigurationPage withDisplayState(boolean displayState) {
        return new ConfigurationPage(this.projectId, this.linkedProjectPaths, this.configuredMappings, this.availableLabels, this.authenticationRequired, this.bugTracker, displayState);
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public List<String> getLinkedProjectPaths() {
        return this.linkedProjectPaths;
    }

    public Map<String, ProjectMappings> getConfiguredMappings() {
        return this.configuredMappings;
    }

    public Map<String, AvailableLabels> getAvailableLabels() {
        return this.availableLabels;
    }

    public boolean isAuthenticationRequired() {
        return this.authenticationRequired;
    }

    public BugTrackerDto getBugTracker() {
        return this.bugTracker;
    }

    public boolean isDisplayState() {
        return this.displayState;
    }

    public static final class AvailableLabels {
        private final boolean projectAvailable;
        private final List<String> scopes;
        private final List<String> labels;

        public AvailableLabels(boolean projectAvailable, List<String> scopes, List<String> labels) {
            this.projectAvailable = projectAvailable;
            this.scopes = scopes;
            this.labels = labels;
        }

        public boolean isProjectAvailable() {
            return this.projectAvailable;
        }

        public List<String> getScopes() {
            return this.scopes;
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public AvailableLabels() {
            this.projectAvailable = false;
            this.scopes = null;
            this.labels = null;
        }
    }
}

