/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab;

import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.bugtracker.gitlab.service.ConfigurationService;

public final class GitLabConfigurablePlugin
implements ConfigurablePlugin {
    public static final WorkspaceType CONFIGURING_WORKSPACE = WorkspaceType.CAMPAIGN_WORKSPACE;
    public static final String PLUGIN_ID = "gitlab-bugtracker";
    private static final String URL_TEMPLATE = "plugin/gitlab-bugtracker/configuration/project/{projectId}";
    private final MessageSource messageSource;
    private final ConfigurationService configurationService;

    GitLabConfigurablePlugin(MessageSource messageSource, ConfigurationService configurationService) {
        this.messageSource = messageSource;
        this.configurationService = configurationService;
    }

    public WorkspaceType getConfiguringWorkspace() {
        return CONFIGURING_WORKSPACE;
    }

    public String getConfigurationPath(EntityReference entityReference) {
        return URL_TEMPLATE.replace("{projectId}", entityReference.getId().toString());
    }

    public String getId() {
        return PLUGIN_ID;
    }

    public String getName() {
        return this.localize("plugin.name");
    }

    public String getType() {
        return this.localize("plugin.type");
    }

    public PluginType getPluginType() {
        return null;
    }

    public void validate(EntityReference entityReference) throws PluginValidationException {
        if (!this.configurationService.hasConfiguration(entityReference)) {
            throw new PluginValidationException("No defined mappings");
        }
    }

    private String localize(String key) {
        return this.messageSource.getMessage(key, null, key, LocaleContextHolder.getLocale());
    }
}

