/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab;

import java.util.Locale;
import javax.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;

@Component
public class GitLabBugtrackerConnectorInterfaceDescriptor
implements BugTrackerInterfaceDescriptor {
    private Locale locale;
    private final MessageSource messageSource;

    public GitLabBugtrackerConnectorInterfaceDescriptor(@Named(value="gitlabConnectorMessageSource") MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected Locale getLocale() {
        return this.locale;
    }

    public boolean getSupportsRichDescription() {
        return true;
    }

    public boolean getSupportsRichComment() {
        return true;
    }

    public String getReportPriorityLabel() {
        return this.messageSource.getMessage("interface.report.priority.label", null, this.getLocale());
    }

    public String getReportVersionLabel() {
        return this.messageSource.getMessage("interface.report.version.label", null, this.getLocale());
    }

    public String getReportAssigneeLabel() {
        return this.messageSource.getMessage("interface.report.assignee.label", null, this.getLocale());
    }

    public String getReportCategoryLabel() {
        return this.messageSource.getMessage("interface.report.category.label", null, this.getLocale());
    }

    public String getReportSummaryLabel() {
        return this.messageSource.getMessage("interface.report.summary.label", null, this.getLocale());
    }

    public String getReportDescriptionLabel() {
        return this.messageSource.getMessage("interface.report.description.label", null, this.getLocale());
    }

    public String getReportCommentLabel() {
        return this.messageSource.getMessage("interface.report.comment.label", null, this.getLocale());
    }

    public String getEmptyVersionListLabel() {
        return this.messageSource.getMessage("interface.report.lists.emptyversion.label", null, this.getLocale());
    }

    public String getEmptyCategoryListLabel() {
        return this.messageSource.getMessage("interface.report.lists.emptycategory.label", null, this.getLocale());
    }

    public String getEmptyAssigneeListLabel() {
        return this.messageSource.getMessage("interface.report.lists.emptyassignee.label", null, this.getLocale());
    }

    public String getTableIssueIDHeader() {
        return this.messageSource.getMessage("interface.table.issueid.header", null, this.getLocale());
    }

    public String getTableSummaryHeader() {
        return this.messageSource.getMessage("interface.table.summary.header", null, this.getLocale());
    }

    public String getTablePriorityHeader() {
        return this.messageSource.getMessage("interface.table.priority.header", null, this.getLocale());
    }

    public String getTableStatusHeader() {
        return this.messageSource.getMessage("interface.table.status.header", null, this.getLocale());
    }

    public String getTableDescriptionHeader() {
        return this.messageSource.getMessage("interface.table.description.header", null, this.getLocale());
    }

    public String getTableAssigneeHeader() {
        return this.messageSource.getMessage("interface.table.assignee.header", null, this.getLocale());
    }

    public String getTableReportedInHeader() {
        return this.messageSource.getMessage("interface.table.reportedin.header", null, this.getLocale());
    }

    public String getTableNoAssigneeLabel() {
        return this.messageSource.getMessage("interface.table.null.assignee.label", null, this.getLocale());
    }
}

